/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.patreon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import net.minecraft.class_1664;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.patreon.decrypt.DecryptInputStream;

public class Patreon {
    private static final class_2960 cape1 = new class_2960("xaeropatreon", "capes/cape1.png");
    private static final class_2960 cape2 = new class_2960("xaeropatreon", "capes/cape2.png");
    private static final class_2960 cape3 = new class_2960("xaeropatreon", "capes/cape3.png");
    private static final class_2960 cape4 = new class_2960("xaeropatreon", "capes/cape4.png");
    private static final File optionsFile = new File("./config/xaeropatreon.txt");
    private static final HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    private static boolean pauseCapes = false;
    private static boolean loaded = false;
    private static boolean showCapes = true;
    private static int patronPledge = -1;
    private static Cipher cipher = null;
    private static int KEY_VERSION = 4;
    private static String publicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoBeELcruvAEIeLF/UsWF/v5rxyRXIpCs+eORLCbDw5cz9jHsnoypQKx0RTk5rcXIeA0HbEfY0eREB25quHjhZKul7MnzotQT+F2Qb1bPfHa6+SPie+pj79GGGAFP3npki6RqoU/wyYkd1tOomuD8v5ytEkOPC4U42kxxvx23A7vH6w46dew/E/HvfbBvZF2KrqdJtwKAunk847C3FgyhVq8/vzQc6mqAW6Mmn4zlwFvyCnTOWjIRw/I93WIM/uvhE3lt6pmtrWA2yIbKIj1z4pgG/K72EqHfYLGkBFTh7fV1wwCbpNTXZX2JnTfmvMGqzHjq7FijwVfCpFB/dWR3wQIDAQAB";
    private static boolean shouldChill = false;
    public static boolean optifine = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        if (shouldChill) {
            return;
        }
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon.loadSettings();
            Object s = "http://data.chocolateminecraft.com/Versions_" + KEY_VERSION + "/Patreon.dat";
            s = ((String)s).replaceAll(" ", "%20");
            try {
                String line;
                URL url = new URL((String)s);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(900);
                conn.setConnectTimeout(900);
                if (conn.getContentLengthLong() > 524288L) {
                    throw new IOException("Input too long to trust!");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new DecryptInputStream(conn.getInputStream(), cipher)));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    String[] args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(class_310.method_1551().method_1548().method_1677().getName())) continue;
                    Patreon.setPatronPledge(pledge);
                }
                reader.close();
            }
            catch (Throwable e) {
                OpenPartiesAndClaims.LOGGER.error("suppressed exception", e);
                patrons.clear();
            }
            finally {
                loaded = true;
            }
        }
    }

    public static int getPatronPledge(String name) {
        if (shouldChill) {
            return -1;
        }
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        if (shouldChill) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + showCapes);
            writer.close();
        }
        catch (IOException e) {
            OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static void loadSettings() {
        if (shouldChill) {
            return;
        }
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                showCapes = args[1].equals("true");
            }
            reader.close();
        }
        catch (IOException e) {
            OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static class_2960 getPlayerCape(class_742 playerEntity) {
        if (shouldChill) {
            return null;
        }
        if (!pauseCapes && showCapes) {
            class_2960 cape = null;
            int pledge = Patreon.getPatronPledge(playerEntity.method_5477().getString());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            class_2960 realCape = playerEntity.method_3119();
            boolean realIsWearing = playerEntity.method_7348(class_1664.field_7559);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(class_742 playerEntity) {
        if (shouldChill) {
            return null;
        }
        if (!pauseCapes && showCapes) {
            pauseCapes = true;
            class_2960 realCape = playerEntity.method_3119();
            boolean realIsWearing = playerEntity.method_7348(class_1664.field_7559);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon.getPatronPledge(playerEntity.method_5477().getString());
            return pledge >= 2;
        }
        return null;
    }

    public static int getPatronPledge() {
        if (shouldChill) {
            return -1;
        }
        return patronPledge;
    }

    public static void setPatronPledge(int patronPledge) {
        if (shouldChill) {
            return;
        }
        Patreon.patronPledge = patronPledge;
    }

    public static String getPublicKeyString() {
        return publicKeyString;
    }

    public static int getKEY_VERSION() {
        return KEY_VERSION;
    }

    static {
        try {
            Class.forName("xaero.common.patreon.Patreon");
            shouldChill = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("xaero.map.patreon.Patreon");
            shouldChill = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("optifine.Patcher");
            optifine = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!shouldChill) {
            try {
                cipher = Cipher.getInstance("RSA");
                KeyFactory factory = KeyFactory.getInstance("RSA");
                byte[] byteKey = Base64.getDecoder().decode(Patreon.getPublicKeyString().getBytes());
                X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
                PublicKey publicKey = factory.generatePublic(X509publicKey);
                cipher.init(2, publicKey);
            }
            catch (Exception e) {
                cipher = null;
                OpenPartiesAndClaims.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }
}

