/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.tracker.api.IClaimsManagerTrackerRegisterAPI;
import xaero.pac.common.entity.IEntity;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IOpenPACMinecraftServer;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.ServerDataInitializer;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsCommandRegister;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.protection.ChunkProtection;
import xaero.pac.common.server.command.CommonCommandRegister;
import xaero.pac.common.server.core.ServerCore;
import xaero.pac.common.server.parties.command.PartyCommandRegister;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemRegisterAPI;
import xaero.pac.common.server.parties.system.impl.DefaultPlayerPartySystem;
import xaero.pac.common.server.player.data.IOpenPACServerPlayer;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemRegisterAPI;
import xaero.pac.common.server.world.ServerLevelHelper;

public abstract class CommonEvents {
    protected final OpenPartiesAndClaims modMain;
    public static MinecraftServer lastServerStarted;
    private Class<?> createSuperGlueEntityClass;

    protected CommonEvents(OpenPartiesAndClaims modMain) {
        this.modMain = modMain;
        try {
            this.createSuperGlueEntityClass = Class.forName("com.simibubi.create.content.contraptions.glue.SuperGlueEntity");
        }
        catch (ClassNotFoundException ignored) {
            try {
                this.createSuperGlueEntityClass = Class.forName("com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public void onServerAboutToStart(MinecraftServer server) throws Throwable {
        lastServerStarted = server;
        OpenPartiesAndClaims.LOGGER.info("Initializing Open Parties and Claims for the server...");
        ((IOpenPACMinecraftServer)lastServerStarted).setXaero_OPAC_ServerData(new ServerDataInitializer().init(this.modMain, lastServerStarted));
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
        if (serverData != null) {
            this.modMain.getPacketHandler().onServerAboutToStart();
            try {
                serverData.getPlayerPermissionSystemManager().preRegister();
                serverData.getPlayerPartySystemManager().preRegister();
                serverData.getPlayerPartySystemManager().register("default", new DefaultPlayerPartySystem((IPartyManager<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>>)serverData.getPartyManager()));
                this.fireAddonRegisterEvent(serverData);
            }
            finally {
                serverData.getPlayerPermissionSystemManager().postRegister();
                serverData.getPlayerPartySystemManager().postRegister();
            }
        }
    }

    protected abstract void fireAddonRegisterEvent(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> var1);

    public void onServerStarting(MinecraftServer server) {
        this.modMain.startupCrashHandler.check();
        ServerData.from(server).getServerLoadCallback().onLoad(server);
    }

    public void onPlayerRespawn(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.method_5682());
            if (serverData != null) {
                serverData.getPlayerWorldJoinHandler().onWorldJoin(serverData, serverPlayer.method_51469(), serverPlayer);
            }
        }
    }

    public void onPlayerChangedDimension(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.method_5682());
            if (serverData != null) {
                serverData.getPlayerWorldJoinHandler().onWorldJoin(serverData, serverPlayer.method_51469(), serverPlayer);
            }
        }
    }

    public void onPlayerLogIn(class_1657 player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
        if (player instanceof class_3222 && (serverData = ServerData.from(player.method_5682())) != null) {
            ServerPlayerDataAPI.from((class_3222)player);
        }
    }

    public void onPlayerClone(class_1657 original, class_1657 player) {
        if (original instanceof class_3222) {
            ((IOpenPACServerPlayer)player).setXaero_OPAC_PlayerData(ServerPlayerDataAPI.from((class_3222)original));
        }
    }

    public void onPlayerLogOut(class_1657 player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
        if (player instanceof class_3222 && (serverData = ServerData.from(player.method_5682())) != null) {
            serverData.getPlayerLogoutHandler().handle((class_3222)player, serverData);
        }
    }

    public void onServerTick(MinecraftServer server, boolean isTickStart) throws Throwable {
        if (isTickStart) {
            ServerCore.onServerTickStart(server);
        }
    }

    public void onPlayerTick(boolean isTickStart, boolean isServerSide, class_1657 player) throws Throwable {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
        if (isServerSide && isTickStart && player instanceof class_3222 && (serverData = ServerData.from(player.method_5682())) != null) {
            serverData.getPlayerTickHandler().onTick((class_3222)player, serverData);
        }
    }

    public void onServerStopped(MinecraftServer server) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
        if (serverData != null) {
            serverData.onStop();
        }
        ServerCore.reset();
    }

    public void onRegisterCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        new PartyCommandRegister().register(dispatcher, environment);
        new ClaimsCommandRegister().register(dispatcher, environment);
        new CommonCommandRegister().register(dispatcher, environment);
    }

    public boolean onLeftClickBlock(class_1937 level, class_2338 pos, class_1657 player) {
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityDestroyBlock(serverData, (class_1297)player, serverLevel, pos, true);
    }

    public boolean onDestroyBlock(class_1936 levelAccessor, class_2338 pos, class_1657 player) {
        if (!(levelAccessor instanceof class_1937)) {
            return false;
        }
        class_1937 level = (class_1937)levelAccessor;
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityDestroyBlock(serverData, (class_1297)player, serverLevel, pos, true);
    }

    public boolean onEntityDestroyBlock(class_1937 level, class_2338 pos, class_1297 entity) {
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityDestroyBlock(serverData, entity, serverLevel, pos, false);
    }

    public boolean onRightClickBlock(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitVec) {
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        return ((ChunkProtection)serverData.getChunkProtection()).onBlockInteraction(serverData, (class_1297)player, hand, null, serverLevel, pos, hitVec.method_17780(), false, true);
    }

    public boolean onItemRightClick(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_1799 itemStack) {
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        return ((ChunkProtection)serverData.getChunkProtection()).onItemRightClick(serverData, hand, itemStack, pos, player, true);
    }

    public boolean onMobGrief(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        if (entity.method_5682() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onMobGrief(serverData, entity);
    }

    public boolean onLivingHurt(class_1282 source, class_1297 target) {
        boolean isFire;
        if (target.method_5682() == null) {
            return false;
        }
        boolean bl = isFire = source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337);
        if (!(source.method_5529() != null || source.method_5526() != null || (source.method_48789(class_8103.field_42240) || source.method_49708(class_8111.field_42351) || isFire || source.method_48789(class_8103.field_42247) || source.method_48789(class_8103.field_42249) || source.method_5525().startsWith("create.")) && !source.method_49708(class_8111.field_42338) && !source.method_49708(class_8111.field_42339))) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.method_5682());
        if (isFire) {
            return ((ChunkProtection)serverData.getChunkProtection()).onEntityFire(serverData, target);
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source.method_5529(), source.method_5526(), target, null, class_1268.field_5808, true, true);
    }

    protected boolean onEntityAttack(class_1657 player, class_1297 target) {
        if (target == null || target.method_5682() == null) {
            return false;
        }
        boolean result = false;
        if (!player.method_7325()) {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.method_5682());
            result = ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, (class_1297)player, (class_1297)player, target, null, class_1268.field_5808, true, true);
        }
        if (result) {
            ServerCore.postResourcesDrop((class_1297)player);
        }
        return result;
    }

    public boolean onEntityInteract(class_1297 source, class_1297 target, class_1268 hand) {
        if (target.method_5682() == null) {
            return false;
        }
        if (source.method_7325()) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source, source, target, null, hand, false, false);
    }

    public boolean onInteractEntitySpecific(class_1297 source, class_1297 target, class_1268 hand) {
        if (target.method_5682() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(target.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityInteraction(serverData, source, source, target, null, hand, false, true);
    }

    public void onExplosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities, List<class_2338> affectedBlocks) {
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        ((ChunkProtection)serverData.getChunkProtection()).onExplosionDetonate(serverData, serverLevel, explosion, affectedEntities, affectedBlocks);
    }

    public boolean onChorusFruit(class_1297 entity, class_243 target) {
        if (entity.method_5682() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onChorusFruitTeleport(serverData, target, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEntityJoinWorld(class_1297 entity, class_1937 level, boolean fromDisk) {
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        if (!serverLevel.method_8503().method_18854()) {
            return false;
        }
        try {
            class_2338 contraptionAnchor;
            class_1676 projectile;
            if (!(entity instanceof class_1309) && ServerCore.getDyingDamageSourceForCurrentEntitySpawns(serverLevel.method_8503().method_3780()) != null) {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
                if (serverData == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = ((ChunkProtection)serverData.getChunkProtection()).onLivingLootEntity(serverData, ServerCore.getDyingLivingForCurrentEntitySpawns(serverLevel.method_8503().method_3780()), entity, ServerCore.getDyingDamageSourceForCurrentEntitySpawns(serverLevel.method_8503().method_3780()));
                return bl;
            }
            if (entity instanceof class_1538) {
                class_1538 bolt = (class_1538)entity;
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
                ((ChunkProtection)serverData.getChunkProtection()).onLightningBolt(serverData, bolt);
                boolean bl = false;
                return bl;
            }
            if (entity instanceof class_1676 && (projectile = (class_1676)entity).method_24921() != null && projectile.method_24921().method_37908() == entity.method_37908()) {
                class_4076 oldSection = class_4076.method_18682((class_2338)projectile.method_24921().method_24515());
                class_4076 newSection = class_4076.method_18682((class_2338)entity.method_24515());
                if (oldSection.method_18674() != newSection.method_18674() || oldSection.method_18687() != newSection.method_18687()) {
                    IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
                    ((ChunkProtection)serverData.getChunkProtection()).onEntityEnterChunk(serverData, entity, projectile.method_24921().method_23317(), projectile.method_24921().method_23321(), newSection, oldSection);
                }
                boolean serverData = false;
                return serverData;
            }
            if (!fromDisk && entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
                if (serverData == null) {
                    boolean newSection = false;
                    return newSection;
                }
                boolean newSection = ((ChunkProtection)serverData.getChunkProtection()).onItemAddedToWorld(serverData, itemEntity);
                return newSection;
            }
            if (!fromDisk && entity.getClass() == this.createSuperGlueEntityClass && (contraptionAnchor = ServerCore.getFreshAddedSuperGlueAnchor((class_1937)serverLevel)) != null) {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
                ServerCore.postCreateDisassembleSuperGlue();
                boolean bl = ((ChunkProtection)serverData.getChunkProtection()).onCreateGlueEntityFromAnchor(serverData, entity, contraptionAnchor);
                return bl;
            }
        }
        finally {
            if (((IEntity)entity).getXaero_OPAC_lastChunkEntryDimension() == null) {
                ((IEntity)entity).setXaero_OPAC_lastChunkEntryDimension((class_5321<class_1937>)entity.method_37908().method_27983());
            }
            if (entity instanceof class_1542) {
                IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData;
                class_1542 itemEntity = (class_1542)entity;
                if (ServerCore.getItemEntityThrower(itemEntity) == null && ServerCore.getResourcesDropOwner() != null) {
                    itemEntity.method_6981(ServerCore.getResourcesDropOwner().method_5667());
                }
                if (ServerCore.getItemEntityThrower(itemEntity) != null && ServerCore.getThrowerAccessor(itemEntity) == null && (serverData = ServerData.from(serverLevel.method_8503())) != null) {
                    ((ChunkProtection)serverData.getChunkProtection()).setThrowerAccessor(itemEntity);
                }
            }
        }
        return false;
    }

    protected void onEntityEnteringSection(class_1297 entity, class_4076 oldSection, class_4076 newSection, boolean chunkChanged) {
        if (entity.method_5682() != null && chunkChanged && (entity.field_6038 != 0.0 || entity.field_5971 != 0.0 || entity.field_5989 != 0.0)) {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
            if (entity.method_37908().method_27983().equals(((IEntity)entity).getXaero_OPAC_lastChunkEntryDimension())) {
                ((ChunkProtection)serverData.getChunkProtection()).onEntityEnterChunk(serverData, entity, entity.field_6038, entity.field_5989, newSection, oldSection);
            }
            ((IEntity)entity).setXaero_OPAC_lastChunkEntryDimension((class_5321<class_1937>)entity.method_37908().method_27983());
        }
    }

    protected void onPermissionsChanged(class_3222 player) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.method_5682());
        if (serverData != null) {
            serverData.getPlayerPermissionChangeHandler().handle(player, serverData);
        }
    }

    protected boolean onCropTrample(class_1297 entity, class_2338 pos) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onCropTrample(serverData, entity, pos);
    }

    public boolean onBucketUse(class_1297 entity, class_1937 level, class_239 hitResult, class_1799 itemStack) {
        if (entity.method_5682() == null) {
            return false;
        }
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onBucketUse(serverData, entity, serverLevel, hitResult, itemStack);
    }

    protected boolean onEntityPlaceBlock(class_1936 levelAccessor, class_2338 pos, class_1297 entity) {
        if (!(levelAccessor instanceof class_1937)) {
            return false;
        }
        class_1937 level = (class_1937)levelAccessor;
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        if (ServerCore.isHandlingFrostWalk()) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        if (serverData == null) {
            return false;
        }
        return ((ChunkProtection)serverData.getChunkProtection()).onEntityPlaceBlock(serverData, entity, serverLevel, pos, null);
    }

    protected boolean onEntityMultiPlaceBlock(class_1936 levelAccessor, Stream<class_2338> positions, class_1297 entity) {
        if (!(levelAccessor instanceof class_1937)) {
            return false;
        }
        class_1937 level = (class_1937)levelAccessor;
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverLevel.method_8503());
        if (serverData == null) {
            return false;
        }
        if (ServerCore.isHandlingFrostWalk()) {
            return false;
        }
        HashSet<class_1923> chunkPositions = new HashSet<class_1923>();
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            class_2338 pos = (class_2338)iterator.next();
            if (!chunkPositions.add(new class_1923(pos)) || !((ChunkProtection)serverData.getChunkProtection()).onEntityPlaceBlock(serverData, entity, serverLevel, pos, null)) continue;
            return true;
        }
        return false;
    }

    protected void onTagsUpdate() {
        if (lastServerStarted == null || !lastServerStarted.method_3806() || !lastServerStarted.method_18854()) {
            return;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(lastServerStarted);
        if (serverData == null) {
            return;
        }
        ((ChunkProtection)serverData.getChunkProtection()).updateTagExceptions(lastServerStarted);
    }

    public boolean onItemPickup(class_1297 entity, class_1542 itemEntity) {
        if (itemEntity.method_5682() == null) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(itemEntity.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onItemPickup(serverData, entity, itemEntity);
    }

    public boolean onMobSpawn(class_1297 entity, double x, double y, double z, class_3730 spawnReason) {
        if (spawnReason == class_3730.field_16472) {
            return false;
        }
        if (entity == null || entity.method_5682() == null || !entity.method_5682().method_18854()) {
            return false;
        }
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(entity.method_5682());
        return ((ChunkProtection)serverData.getChunkProtection()).onMobSpawn(serverData, entity, x, y, z, spawnReason);
    }

    public void onServerDataReload(class_3300 resourceManager) {
        if (lastServerStarted != null && lastServerStarted.method_18854()) {
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(lastServerStarted);
            serverData.onServerResourcesReload(resourceManager);
        }
    }

    public void onAddonRegister(MinecraftServer server, IPlayerPermissionSystemRegisterAPI permissionSystemManagerAPI, IPlayerPartySystemRegisterAPI partySystemManagerAPI, IClaimsManagerTrackerRegisterAPI claimsManagerTrackerAPI) {
        if (this.modMain.getModSupport().LUCK_PERMS) {
            permissionSystemManagerAPI.register("luck_perms", this.modMain.getModSupport().getLuckPerms().getPermissionSystem());
        }
        if (this.modMain.getModSupport().FTB_RANKS) {
            permissionSystemManagerAPI.register("ftb_ranks", this.modMain.getModSupport().getFTBRanksSupport().getPermissionSystem());
        }
        if (this.modMain.getModSupport().PROMETHEUS) {
            permissionSystemManagerAPI.register("prometheus", this.modMain.getModSupport().getPrometheusSupport().getPermissionSystem());
        }
        if (this.modMain.getModSupport().FTB_TEAMS) {
            partySystemManagerAPI.register("ftb_teams", this.modMain.getModSupport().getFTBTeamsSupport().getPartySystem());
        }
        if (this.modMain.getModSupport().ARGONAUTS) {
            partySystemManagerAPI.register("argonauts", this.modMain.getModSupport().getArgonautsSupport().getPartySystem());
            partySystemManagerAPI.register("argonauts_guilds", this.modMain.getModSupport().getArgonautsSupport().createGuildSystem(server));
        }
    }
}

