/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.ClientPacketHandlerFabric;
import xaero.pac.common.packet.IPacketHandler;
import xaero.pac.common.packet.PacketType;
import xaero.pac.common.packet.ServerPacketReceiver;

public class PacketHandlerFabric
implements IPacketHandler {
    private final Int2ObjectOpenHashMap<PacketType<?>> int2PacketType;
    private final Map<Class<?>, PacketType<?>> class2PacketType;
    private ClientPacketHandlerFabric clientPacketHandlerFabric;

    private PacketHandlerFabric(Int2ObjectOpenHashMap<PacketType<?>> int2PacketType, Map<Class<?>, PacketType<?>> class2PacketType) {
        this.int2PacketType = int2PacketType;
        this.class2PacketType = class2PacketType;
    }

    private void setClientPacketHandlerFabric(ClientPacketHandlerFabric clientPacketHandlerFabric) {
        this.clientPacketHandlerFabric = clientPacketHandlerFabric;
    }

    public void registerOnClient() {
        this.clientPacketHandlerFabric.registerOnClient();
    }

    @Override
    public void onServerAboutToStart() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OpenPartiesAndClaims.MAIN_CHANNEL_LOCATION, (ServerPlayNetworking.PlayChannelHandler)new ServerPacketReceiver(this));
    }

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, class_2540> encoder, Function<class_2540, P> decoder, BiConsumer<P, class_3222> serverHandler, Consumer<P> clientHandler) {
        PacketType<P> packetType = new PacketType<P>(index, type, encoder, decoder, serverHandler, clientHandler);
        if (this.int2PacketType.containsKey(index)) {
            throw new IllegalArgumentException("duplicate index!");
        }
        if (this.class2PacketType.containsKey(type)) {
            throw new IllegalArgumentException("duplicate packet class!");
        }
        this.int2PacketType.put(index, packetType);
        this.class2PacketType.put(type, packetType);
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.clientPacketHandlerFabric.sendToServer(packet);
    }

    @Override
    public <T> void sendToPlayer(class_3222 player, T packet) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)OpenPartiesAndClaims.MAIN_CHANNEL_LOCATION, (class_2540)this.getPacketBuffer(packet));
    }

    <T> class_2540 getPacketBuffer(T packet) {
        PacketType<?> packetTypePreCast = this.class2PacketType.get(packet.getClass());
        if (packetTypePreCast == null) {
            throw new IllegalArgumentException("unregistered packet class!");
        }
        PacketType<?> packetType = packetTypePreCast;
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeByte(packetType.getIndex());
        packetType.getEncoder().accept(packet, buffer);
        return buffer;
    }

    public PacketType<?> getPacketTypeByIndex(int index) {
        return (PacketType)this.int2PacketType.get(index);
    }

    public static class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public PacketHandlerFabric build() {
            PacketHandlerFabric result = new PacketHandlerFabric(new Int2ObjectOpenHashMap(), new HashMap());
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                result.setClientPacketHandlerFabric(new ClientPacketHandlerFabric(result));
            }
            return result;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

