/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class InvitePartyCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<class_2168> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"member").requires(requirement)).then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).suggests((context, builder) -> {
            class_3324 playerlist = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerlist.method_14571().stream().map(targetPlayer -> targetPlayer.method_7334().getName()), (SuggestionsBuilder)builder);
        }).executes(context -> {
            class_3222 targetPlayer;
            UUID targetPlayerId;
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(playerId);
            if (playerParty.getMemberInfo(targetPlayerId = (targetPlayer = class_2186.method_9315((CommandContext)context, (String)"player")).method_5667()) != null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_invite_already_your_party", targetPlayer.method_7334().getName()));
                return 0;
            }
            if (partyManager.getPartyByMember(targetPlayerId) != null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_invite_already_a_party", targetPlayer.method_7334().getName()));
                return 0;
            }
            if (playerParty.getInviteCount() >= (Integer)ServerConfig.CONFIG.maxPartyInvites.get()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_invite_invite_limit", new Object[0]));
                return 0;
            }
            if (playerParty.getMemberCount() >= (Integer)ServerConfig.CONFIG.maxPartyMembers.get()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(player, "gui.xaero_parties_invite_member_limit", new Object[0]));
                return 0;
            }
            playerParty.invitePlayer(targetPlayerId, targetPlayer.method_7334().getName());
            IPartyMember casterInfo = (IPartyMember)playerParty.getMemberInfo(playerId);
            class_5250 acceptComponent = adaptiveLocalizer.getFor(targetPlayer, "gui.xaero_parties_invite_target_message", casterInfo.getUsername(), playerParty.getDefaultName());
            acceptComponent.method_10855().add(class_2561.method_43470((String)" "));
            acceptComponent.method_10855().add(adaptiveLocalizer.getFor(targetPlayer, "gui.xaero_parties_invite_target_message_accept", new Object[0]).method_27694(s -> s.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/openpac-parties join " + playerParty.getId())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)adaptiveLocalizer.getFor(targetPlayer, "gui.xaero_parties_invite_target_message_accept_tooltip", new Object[0])))));
            targetPlayer.method_43496((class_2561)acceptComponent);
            Services.PLATFORM.getEntityAccess().getPersistentData((class_1297)targetPlayer).method_25927("xaero_OPAC_LastInviteId", playerParty.getId());
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (class_2561)class_2561.method_43469((String)"gui.xaero_parties_invite_party_message", (Object[])new Object[]{class_2561.method_43470((String)casterInfo.getUsername()).method_27694(s -> s.method_10977(class_124.field_1060)), class_2561.method_43470((String)targetPlayer.method_7334().getName()).method_27694(s -> s.method_10977(class_124.field_1054))}));
            return 1;
        }))));
        dispatcher.register(command);
    }
}

