/*
 * Decompiled with CFR 0.152.
 */
package forge.net.raphimc.immediatelyfast.feature.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.net.raphimc.immediatelyfast.compat.IrisCompat;
import forge.net.raphimc.immediatelyfast.feature.core.BufferBuilderPool;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public abstract class ImmediateAdapter
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private static final BufferBuilder FALLBACK_BUFFER = new BufferBuilder(0);
    protected final Reference2ObjectMap<RenderType, ReferenceSet<BufferBuilder>> fallbackBuffers = new Reference2ObjectLinkedOpenHashMap();
    protected final ReferenceSet<RenderType> activeLayers = new ReferenceLinkedOpenHashSet();
    protected boolean drawFallbackLayersFirst = false;

    public ImmediateAdapter() {
        this((Map<RenderType, BufferBuilder>)ImmutableMap.of());
    }

    public ImmediateAdapter(Map<RenderType, BufferBuilder> layerBuffers) {
        super(FALLBACK_BUFFER, layerBuffers);
    }

    public VertexConsumer m_6299_(RenderType layer) {
        Optional newLayer = layer.m_110406_();
        if (!this.drawFallbackLayersFirst && !this.f_109906_.equals(newLayer) && this.f_109906_.isPresent() && !this.f_109905_.containsKey(this.f_109906_.get())) {
            this.drawFallbackLayersFirst = true;
        }
        this.f_109906_ = newLayer;
        BufferBuilder bufferBuilder = this.getOrCreateBufferBuilder(layer);
        if (bufferBuilder.m_85732_() && !layer.m_234326_()) {
            throw new IllegalStateException("Tried to write shared vertices into the same buffer");
        }
        if (!bufferBuilder.m_85732_()) {
            if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
                IrisCompat.iris$beginWithoutExtending.accept(bufferBuilder, layer.m_173186_(), layer.m_110508_());
            } else {
                bufferBuilder.m_166779_(layer.m_173186_(), layer.m_110508_());
            }
            this.activeLayers.add((Object)layer);
        }
        return bufferBuilder;
    }

    public void m_173043_() {
        this.f_109906_ = Optional.empty();
        this.drawFallbackLayersFirst = false;
        this.activeLayers.stream().filter(l -> !this.f_109905_.containsKey(l)).sorted((l1, l2) -> {
            if (l1.f_110393_ == l2.f_110393_) {
                return 0;
            }
            return l1.f_110393_ ? 1 : -1;
        }).forEachOrdered(this::m_109912_);
    }

    public void m_109911_() {
        if (this.activeLayers.isEmpty()) {
            this.close();
            return;
        }
        this.m_173043_();
        for (RenderType layer : this.f_109905_.keySet()) {
            this.m_109912_(layer);
        }
    }

    public void m_109912_(RenderType layer) {
        if (this.drawFallbackLayersFirst) {
            this.m_173043_();
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeLayers.remove((Object)layer);
        this._draw(layer);
        this.fallbackBuffers.remove((Object)layer);
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    @Override
    public void close() {
        this.f_109906_ = Optional.empty();
        this.drawFallbackLayersFirst = false;
        for (RenderType layer : this.activeLayers) {
            for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
                bufferBuilder.m_231175_().m_231200_();
            }
        }
        this.activeLayers.clear();
        this.fallbackBuffers.clear();
    }

    public boolean hasActiveLayers() {
        return !this.activeLayers.isEmpty();
    }

    protected abstract void _draw(RenderType var1);

    protected BufferBuilder getOrCreateBufferBuilder(RenderType layer) {
        if (!layer.m_234326_()) {
            return this.addNewFallbackBuffer(layer);
        }
        if (this.f_109905_.containsKey(layer)) {
            return (BufferBuilder)this.f_109905_.get(layer);
        }
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (BufferBuilder)((ReferenceSet)this.fallbackBuffers.get((Object)layer)).iterator().next();
        }
        return this.addNewFallbackBuffer(layer);
    }

    protected Set<BufferBuilder> getBufferBuilder(RenderType layer) {
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (Set)this.fallbackBuffers.get((Object)layer);
        }
        if (this.f_109905_.containsKey(layer)) {
            return Collections.singleton((BufferBuilder)this.f_109905_.get(layer));
        }
        return Collections.emptySet();
    }

    protected BufferBuilder addNewFallbackBuffer(RenderType layer) {
        BufferBuilder bufferBuilder = BufferBuilderPool.get();
        ((ReferenceSet)this.fallbackBuffers.computeIfAbsent((Object)layer, k -> new ReferenceLinkedOpenHashSet())).add((Object)bufferBuilder);
        return bufferBuilder;
    }
}

