/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup;

import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.mixin.itemgroup.ItemGroupAccessor;
import io.wispforest.owo.util.pond.OwoItemExtensions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class OwoItemGroup
extends class_1761 {
    public static final BiConsumer<class_1792, class_1761.class_7704> DEFAULT_STACK_GENERATOR = (item, stacks) -> stacks.method_45420(item.method_7854());
    protected static final ItemGroupTab PLACEHOLDER_TAB = new ItemGroupTab(Icon.of((class_1935)class_1802.field_8162), (class_2561)class_2561.method_43473(), (br, uh) -> {}, ItemGroupTab.DEFAULT_TEXTURE, false);
    public final List<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
    public final List<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
    private final class_2960 id;
    private final Consumer<OwoItemGroup> initializer;
    private final Supplier<Icon> iconSupplier;
    private Icon icon;
    private int selectedTab = 0;
    private boolean initialized = false;
    private final int tabStackHeight;
    private final int buttonStackHeight;
    private final class_2960 customTexture;
    private final boolean useDynamicTitle;
    private final boolean displaySingleTab;

    protected OwoItemGroup(class_2960 id, Consumer<OwoItemGroup> initializer, Supplier<Icon> iconSupplier, int tabStackHeight, int buttonStackHeight, @Nullable class_2960 customTexture, boolean useDynamicTitle, boolean displaySingleTab) {
        super(null, -1, class_1761.class_7916.field_41052, (class_2561)class_2561.method_43471((String)"itemGroup.%s.%s".formatted(id.method_12836(), id.method_12832())), () -> class_1799.field_8037, (displayContext, entries) -> {});
        this.id = id;
        this.initializer = initializer;
        this.iconSupplier = iconSupplier;
        this.tabStackHeight = tabStackHeight;
        this.buttonStackHeight = buttonStackHeight;
        this.customTexture = customTexture;
        this.useDynamicTitle = useDynamicTitle;
        this.displaySingleTab = displaySingleTab;
        ((ItemGroupAccessor)((Object)this)).owo$setEntryCollector((context, entries) -> {
            if (!this.initialized) {
                throw new IllegalStateException("o\u03c9o item group not initialized, was 'initialize()' called?");
            }
            this.getSelectedTab().contentSupplier().addItems(context, entries);
            this.collectItemsFromRegistry(entries, true);
        });
    }

    public static Builder builder(class_2960 id, Supplier<Icon> iconSupplier) {
        return new Builder(id, iconSupplier);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.initializer.accept(this);
        }
        if (this.tabs.size() == 0) {
            this.tabs.add(PLACEHOLDER_TAB);
        }
        this.initialized = true;
    }

    public void addButton(ItemGroupButton button) {
        this.buttons.add(button);
    }

    public void addTab(Icon icon, String name, @Nullable class_6862<class_1792> contentTag, class_2960 texture, boolean primary) {
        this.tabs.add(new ItemGroupTab(icon, ButtonDefinition.tooltipFor(this, "tab", name), contentTag == null ? (context, entries) -> {} : (context, entries) -> class_7923.field_41178.method_10220().filter(item -> item.method_40131().method_40220(contentTag)).forEach(arg_0 -> ((class_1761.class_7704)entries).method_45421(arg_0)), texture, primary));
    }

    public void addTab(Icon icon, String name, @Nullable class_6862<class_1792> contentTag, boolean primary) {
        this.addTab(icon, name, contentTag, ItemGroupTab.DEFAULT_TEXTURE, primary);
    }

    public void addCustomTab(Icon icon, String name, ItemGroupTab.ContentSupplier contentSupplier, class_2960 texture, boolean primary) {
        this.tabs.add(new ItemGroupTab(icon, ButtonDefinition.tooltipFor(this, "tab", name), contentSupplier, texture, primary));
    }

    public void addCustomTab(Icon icon, String name, ItemGroupTab.ContentSupplier contentSupplier, boolean primary) {
        this.addCustomTab(icon, name, contentSupplier, ItemGroupTab.DEFAULT_TEXTURE, primary);
    }

    public void method_47306(class_1761.class_8128 context) {
        super.method_47306(context);
        SearchOnlyEntries searchEntries = new SearchOnlyEntries(this, context.comp_1251());
        this.collectItemsFromRegistry((class_1761.class_7704)searchEntries, false);
        this.tabs.forEach(tab -> tab.contentSupplier().addItems(context, (class_1761.class_7704)searchEntries));
        ((ItemGroupAccessor)((Object)this)).owo$setSearchTabStacks(searchEntries.field_40188);
    }

    protected void collectItemsFromRegistry(class_1761.class_7704 entries, boolean matchTab) {
        class_7923.field_41178.method_10220().filter(item -> ((OwoItemExtensions)item).owo$group() == this && (!matchTab || ((OwoItemExtensions)item).owo$tab() == this.selectedTab)).forEach(item -> ((OwoItemExtensions)item).owo$stackGenerator().accept((class_1792)item, entries));
    }

    public void setSelectedTab(int selectedTab, class_1761.class_8128 context) {
        this.selectedTab = selectedTab;
        this.method_47306(context);
    }

    public ItemGroupTab getSelectedTab() {
        return this.tabs.get(this.selectedTab);
    }

    public int getSelectedTabIndex() {
        return this.selectedTab;
    }

    public class_2960 getCustomTexture() {
        return this.customTexture;
    }

    public int getTabStackHeight() {
        return this.tabStackHeight;
    }

    public int getButtonStackHeight() {
        return this.buttonStackHeight;
    }

    public boolean hasDynamicTitle() {
        return this.useDynamicTitle && (this.tabs.size() > 1 || this.shouldDisplaySingleTab());
    }

    public boolean shouldDisplaySingleTab() {
        return this.displaySingleTab;
    }

    public List<ItemGroupButton> getButtons() {
        return this.buttons;
    }

    public ItemGroupTab getTab(int index) {
        return index < this.tabs.size() ? this.tabs.get(index) : null;
    }

    public Icon icon() {
        return this.icon == null ? (this.icon = this.iconSupplier.get()) : this.icon;
    }

    public boolean method_47311() {
        return true;
    }

    public class_2960 id() {
        return class_7923.field_44687.method_10221((Object)this);
    }

    public static class Builder {
        private final class_2960 id;
        private final Supplier<Icon> iconSupplier;
        private Consumer<OwoItemGroup> initializer = owoItemGroup -> {};
        private int tabStackHeight = 4;
        private int buttonStackHeight = 4;
        @Nullable
        private class_2960 customTexture = null;
        private boolean useDynamicTitle = true;
        private boolean displaySingleTab = false;

        private Builder(class_2960 id, Supplier<Icon> iconSupplier) {
            this.id = id;
            this.iconSupplier = iconSupplier;
        }

        public Builder initializer(Consumer<OwoItemGroup> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder tabStackHeight(int tabStackHeight) {
            this.tabStackHeight = tabStackHeight;
            return this;
        }

        public Builder buttonStackHeight(int buttonStackHeight) {
            this.buttonStackHeight = buttonStackHeight;
            return this;
        }

        public Builder customTexture(@Nullable class_2960 customTexture) {
            this.customTexture = customTexture;
            return this;
        }

        public Builder disableDynamicTitle() {
            this.useDynamicTitle = false;
            return this;
        }

        public Builder displaySingleTab() {
            this.displaySingleTab = true;
            return this;
        }

        public OwoItemGroup build() {
            OwoItemGroup group = new OwoItemGroup(this.id, this.initializer, this.iconSupplier, this.tabStackHeight, this.buttonStackHeight, this.customTexture, this.useDynamicTitle, this.displaySingleTab){};
            class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)this.id, (Object)((Object)group));
            return group;
        }
    }

    public static interface ButtonDefinition {
        public Icon icon();

        public class_2960 texture();

        public class_2561 tooltip();

        public static class_2561 tooltipFor(class_1761 group, String component, String componentName) {
            class_2960 registryId = class_7923.field_44687.method_10221((Object)group);
            String groupId = registryId.method_12836().equals("minecraft") ? registryId.method_12832() : registryId.method_12836() + "." + registryId.method_12832();
            return class_2561.method_43471((String)("itemGroup." + groupId + "." + component + "." + componentName));
        }
    }

    protected static class SearchOnlyEntries
    extends class_1761.class_7703 {
        public SearchOnlyEntries(class_1761 group, class_7699 enabledFeatures) {
            super(group, enabledFeatures);
        }

        public void method_45417(class_1799 stack, class_1761.class_7705 visibility) {
            if (visibility == class_1761.class_7705.field_40192) {
                return;
            }
            super.method_45417(stack, class_1761.class_7705.field_40193);
        }
    }
}

