/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import fzzyhmstrs.emi_loot.server.ArchaeologyLootTableSender;
import fzzyhmstrs.emi_loot.server.BlockLootTableSender;
import fzzyhmstrs.emi_loot.server.ChestLootTableSender;
import fzzyhmstrs.emi_loot.server.GameplayLootTableSender;
import fzzyhmstrs.emi_loot.server.MobLootTableSender;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;

public class ClientLootTables {
    private final List<LootReceiver> loots = new LinkedList<LootReceiver>();

    public List<LootReceiver> getLoots() {
        return this.loots;
    }

    public void registerClient() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.loots.clear());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ChestLootTableSender.CHEST_SENDER, (minecraftClient, playNetworkHandler, buf, sender) -> {
            LootReceiver table = ClientChestLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received chest " + table.getId());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BlockLootTableSender.BLOCK_SENDER, (minecraftClient, playNetworkHandler, buf, sender) -> {
            LootReceiver table = ClientBlockLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received block " + table.getId());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MobLootTableSender.MOB_SENDER, (minecraftClient, playNetworkHandler, buf, sender) -> {
            LootReceiver table = ClientMobLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received mob " + table.getId());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GameplayLootTableSender.GAMEPLAY_SENDER, (minecraftClient, playNetworkHandler, buf, sender) -> {
            LootReceiver table = ClientGameplayLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received gameplay loot: " + table.getId());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ArchaeologyLootTableSender.ARCHAEOLOGY_SENDER, (minecraftClient, playNetworkHandler, buf, sender) -> {
            LootReceiver table = ClientArchaeologyLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("received archaeology loot: " + table.getId());
            }
        });
    }
}

