/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.server.ChestLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ChestLootTableSender
implements LootSender<ChestLootPoolBuilder> {
    private final String idToSend;
    final List<ChestLootPoolBuilder> builderList = new LinkedList<ChestLootPoolBuilder>();
    HashMap<class_1799, Float> floatMap = new HashMap();
    public static class_2960 CHEST_SENDER = new class_2960("e_l", "c_s");

    public ChestLootTableSender(class_2960 id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            builder.builtMap.forEach((item, weight) -> {
                if (this.floatMap.containsKey(item)) {
                    float oldWeight = this.floatMap.getOrDefault(item, Float.valueOf(0.0f)).floatValue();
                    this.floatMap.put((class_1799)item, Float.valueOf(oldWeight + weight.floatValue()));
                } else {
                    this.floatMap.put((class_1799)item, (Float)weight);
                }
            });
        });
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(this.idToSend);
        buf.writeShort(this.floatMap.size());
        this.floatMap.forEach((item, floatWeight) -> {
            buf.method_10793(item);
            buf.writeFloat(floatWeight.floatValue());
        });
        ServerPlayNetworking.send((class_3222)player, (class_2960)CHEST_SENDER, (class_2540)buf);
    }

    @Override
    public void addBuilder(ChestLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ChestLootPoolBuilder> getBuilders() {
        return this.builderList;
    }
}

