/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.fluid.holder.ItemStackStorage;
import earth.terrarium.botarium.fabric.fluid.storage.PlatformFluidContainer;
import earth.terrarium.botarium.fabric.fluid.storage.PlatformFluidItemHandler;
import earth.terrarium.botarium.util.Updatable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class FluidApi {
    private static final Map<Supplier<class_2591<?>>, BlockFluidGetter<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_2248>, BlockFluidGetter<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_1792>, ItemFluidGetter<?>> ITEM_LOOKUP_MAP = new HashMap();
    public static final Map<class_2591<?>, BlockFluidGetter<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    public static final Map<class_2248, BlockFluidGetter<?>> FINALIZED_BLOCK_LOOKUP_MAP = new HashMap();
    public static boolean blocksFinalized = false;
    public static final Map<class_1792, ItemFluidGetter<?>> FINALIZED_ITEM_LOOKUP_MAP = new HashMap();
    public static boolean itemsFinalized = false;

    public static void finalizeBlockRegistration() {
        if (!blocksFinalized) {
            System.out.println("Finalizing fluid block registration");
            for (Map.Entry<Supplier<class_2591<?>>, BlockFluidGetter<?>> entry : BLOCK_ENTITY_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_ENTITY_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            for (Map.Entry<Supplier<class_2591<?>>, BlockFluidGetter<?>> entry : BLOCK_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_LOOKUP_MAP.put((class_2248)entry.getKey().get(), entry.getValue());
            }
            blocksFinalized = true;
        }
    }

    public static void finalizeItemRegistration() {
        if (!itemsFinalized) {
            System.out.println("Finalizing fluid item registration");
            for (Map.Entry<Supplier<class_1792>, ItemFluidGetter<?>> entry : ITEM_LOOKUP_MAP.entrySet()) {
                FINALIZED_ITEM_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            itemsFinalized = true;
        }
    }

    public static void registerFluidBlockEntity(Supplier<class_2591<?>> block, BlockFluidGetter<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlockEntity(BlockFluidGetter<?> getter, Supplier<class_2591<?>> ... blocks) {
        for (Supplier<class_2591<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidBlock(Supplier<class_2248> block, BlockFluidGetter<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerFluidBlock(BlockFluidGetter<?> getter, Supplier<class_2248> ... blocks) {
        for (Supplier<class_2248> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerFluidItem(Supplier<class_1792> item, ItemFluidGetter<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerFluidItem(ItemFluidGetter<?> getter, Supplier<class_1792> ... items) {
        for (Supplier<class_1792> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static ItemFluidContainer getItemFluidContainer(ItemStackHolder stack) {
        return new PlatformFluidItemHandler(stack);
    }

    public static FluidContainer getBlockFluidContainer(class_2586 entity, @Nullable class_2350 direction) {
        return new PlatformFluidContainer((Storage<FluidVariant>)((Storage)FluidStorage.SIDED.find(entity.method_10997(), entity.method_11016(), (Object)direction)));
    }

    public static boolean isFluidContainingBlock(class_2586 entity, @Nullable class_2350 direction) {
        return FluidStorage.SIDED.find(entity.method_10997(), entity.method_11016(), (Object)direction) != null;
    }

    public static boolean isFluidContainingItem(class_1799 stack) {
        return FluidStorage.ITEM.find(stack, (Object)ItemStackStorage.of(stack)) != null;
    }

    public static long moveFluid(FluidContainer from, FluidContainer to, FluidHolder amount, boolean simulate) {
        FluidHolder extracted = from.extractFluid(amount, true);
        long inserted = to.insertFluid(extracted, true);
        FluidHolder toInsert = FluidHooks.newFluidHolder(amount.getFluid(), inserted, amount.getCompound());
        FluidHolder simulatedExtraction = from.extractFluid(toInsert, true);
        if (!simulate && inserted > 0L && simulatedExtraction.getFluidAmount() == inserted) {
            from.extractFluid(toInsert, false);
            to.insertFluid(toInsert, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveFluid(ItemStackHolder from, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingItem(from.getStack()) || !FluidApi.isFluidContainingItem(to.getStack())) {
            return 0L;
        }
        ItemFluidContainer fromFluid = FluidApi.getItemFluidContainer(from);
        ItemFluidContainer toFluid = FluidApi.getItemFluidContainer(to);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(class_2586 from, class_2586 to, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingBlock(from, null) || !FluidApi.isFluidContainingBlock(to, null)) {
            return 0L;
        }
        FluidContainer fromFluid = FluidApi.getBlockFluidContainer(from, null);
        FluidContainer toFluid = FluidApi.getBlockFluidContainer(to, null);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(class_2586 from, class_2350 direction, ItemStackHolder to, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingBlock(from, direction) || !FluidApi.isFluidContainingItem(to.getStack())) {
            return 0L;
        }
        FluidContainer fromFluid = FluidApi.getBlockFluidContainer(from, direction);
        ItemFluidContainer toFluid = FluidApi.getItemFluidContainer(to);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    public static long moveFluid(ItemStackHolder from, class_2586 to, class_2350 direction, FluidHolder fluidHolder, boolean simulate) {
        if (!FluidApi.isFluidContainingItem(from.getStack()) || !FluidApi.isFluidContainingBlock(to, direction)) {
            return 0L;
        }
        ItemFluidContainer fromFluid = FluidApi.getItemFluidContainer(from);
        FluidContainer toFluid = FluidApi.getBlockFluidContainer(to, direction);
        return FluidApi.moveFluid(fromFluid, toFluid, fluidHolder, simulate);
    }

    @FunctionalInterface
    public static interface BlockFluidGetter<T extends FluidContainer & Updatable<class_2586>> {
        public T getFluidContainer(class_1937 var1, class_2338 var2, class_2680 var3, class_2586 var4, class_2350 var5);
    }

    @FunctionalInterface
    public static interface ItemFluidGetter<T extends ItemFluidContainer & Updatable<class_1799>> {
        public T getFluidContainer(class_1799 var1);
    }
}

