/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.impl;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidSnapshot;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.IntToLongFunction;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3612;

public class SimpleFluidContainer
implements FluidContainer {
    public static final String FLUID_KEY = "StoredFluids";
    public class_2371<FluidHolder> storedFluid;
    public final IntToLongFunction maxAmount;
    public final BiPredicate<Integer, FluidHolder> fluidFilter;

    public SimpleFluidContainer(IntToLongFunction maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this.maxAmount = maxAmount;
        this.fluidFilter = fluidFilter;
        this.storedFluid = class_2371.method_10213((int)tanks, (Object)FluidHooks.emptyFluid());
    }

    public SimpleFluidContainer(long maxAmount, int tanks, BiPredicate<Integer, FluidHolder> fluidFilter) {
        this(integer -> maxAmount, tanks, fluidFilter);
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            if (((FluidHolder)this.storedFluid.get(i)).isEmpty()) {
                FluidHolder insertedFluid = fluid.copyHolder();
                insertedFluid.setAmount((long)class_3532.method_15363((float)fluid.getFluidAmount(), (float)0.0f, (float)this.maxAmount.applyAsLong(i)));
                if (simulate) {
                    return insertedFluid.getFluidAmount();
                }
                this.storedFluid.set(i, (Object)insertedFluid);
                return ((FluidHolder)this.storedFluid.get(i)).getFluidAmount();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long insertedAmount = (long)class_3532.method_15363((float)fluid.getFluidAmount(), (float)0.0f, (float)(this.maxAmount.applyAsLong(i) - ((FluidHolder)this.storedFluid.get(i)).getFluidAmount()));
            if (simulate) {
                return insertedAmount;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() + insertedAmount);
            return insertedAmount;
        }
        return 0L;
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        for (int i = 0; i < this.storedFluid.size(); ++i) {
            if (!this.fluidFilter.test(i, fluid)) continue;
            FluidHolder toExtract = fluid.copyHolder();
            if (this.storedFluid.isEmpty()) {
                return FluidHooks.emptyFluid();
            }
            if (!((FluidHolder)this.storedFluid.get(i)).matches(fluid)) continue;
            long extractedAmount = (long)class_3532.method_15363((float)fluid.getFluidAmount(), (float)0.0f, (float)((FluidHolder)this.storedFluid.get(i)).getFluidAmount());
            toExtract.setAmount(extractedAmount);
            if (simulate) {
                return toExtract;
            }
            ((FluidHolder)this.storedFluid.get(i)).setAmount(((FluidHolder)this.storedFluid.get(i)).getFluidAmount() - extractedAmount);
            if (((FluidHolder)this.storedFluid.get(i)).getFluidAmount() == 0L) {
                this.storedFluid.set(i, (Object)FluidHooks.emptyFluid());
            }
            return toExtract;
        }
        return FluidHooks.emptyFluid();
    }

    @Override
    public long internalInsert(FluidHolder fluid, boolean simulate) {
        return this.insertFluid(fluid, simulate);
    }

    @Override
    public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        return this.extractFluid(fluid, simulate);
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        if (Objects.equals(fluidHolder.getCompound(), toInsert.getCompound()) && fluidHolder.getFluid().method_15780(toInsert.getFluid())) {
            long extracted = (long)class_3532.method_15363((float)toInsert.getFluidAmount(), (float)0.0f, (float)fluidHolder.getFluidAmount());
            snapshot.run();
            fluidHolder.setAmount(fluidHolder.getFluidAmount() - extracted);
            if (fluidHolder.getFluidAmount() == 0L) {
                fluidHolder.setFluid(class_3612.field_15906);
            }
            return extracted;
        }
        return 0L;
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
        this.storedFluid.set(slot, (Object)fluid);
    }

    @Override
    public List<FluidHolder> getFluids() {
        return this.storedFluid;
    }

    @Override
    public int getSize() {
        return this.getFluids().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getFluids().isEmpty() || this.getFluids().get(0) == null || this.getFluids().get(0).isEmpty();
    }

    public void clear() {
        this.storedFluid.clear();
    }

    @Override
    public SimpleFluidContainer copy() {
        return new SimpleFluidContainer(this.maxAmount, this.getSize(), this.fluidFilter);
    }

    @Override
    public long getTankCapacity(int slot) {
        return this.maxAmount.applyAsLong(slot);
    }

    @Override
    public void fromContainer(FluidContainer container) {
        this.storedFluid = class_2371.method_10213((int)container.getSize(), (Object)FluidHooks.emptyFluid());
        for (int i = 0; i < container.getSize(); ++i) {
            this.storedFluid.set(i, (Object)container.getFluids().get(i).copyHolder());
        }
    }

    @Override
    public void deserialize(class_2487 root) {
        class_2487 tag = root.method_10562("BotariumData");
        class_2499 fluids = tag.method_10554(FLUID_KEY, 10);
        for (int i = 0; i < fluids.size(); ++i) {
            class_2487 fluid = fluids.method_10602(i);
            this.storedFluid.set(i, (Object)FluidHooks.fluidFromCompound(fluid));
        }
    }

    @Override
    public class_2487 serialize(class_2487 root) {
        class_2487 tag = root.method_10562("BotariumData");
        if (!this.storedFluid.isEmpty()) {
            class_2499 tags = new class_2499();
            for (FluidHolder fluidHolder : this.storedFluid) {
                tags.add((Object)fluidHolder.serialize());
            }
            tag.method_10566(FLUID_KEY, (class_2520)tags);
        }
        root.method_10566("BotariumData", (class_2520)tag);
        return root;
    }

    @Override
    public boolean allowsInsertion() {
        return true;
    }

    @Override
    public boolean allowsExtraction() {
        return true;
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    public void method_5448() {
        this.storedFluid.clear();
    }
}

