/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.holder.ManualSyncing;
import earth.terrarium.botarium.fabric.fluid.holder.WrappedFluidHolder;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class FabricItemFluidContainer
extends ExtendedFluidContainer
implements Storage<FluidVariant>,
ManualSyncing {
    private final FluidContainer container;
    private final ContainerItemContext ctx;

    public FabricItemFluidContainer(ContainerItemContext ctx, FluidContainer container) {
        this.container = container;
        this.ctx = ctx;
        class_2487 nbt = ctx.getItemVariant().getNbt();
        if (nbt != null) {
            container.deserialize(nbt);
        }
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long inserted = this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
        this.setChanged(transaction);
        return inserted;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long extracted = this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
        this.setChanged(transaction);
        return extracted;
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        List<FluidHolder> fluids = this.container.getFluids();
        return IntStream.range(0, fluids.size()).mapToObj(index -> new WrappedFluidHolder(this, (FluidHolder)fluids.get(index), this.container::extractFromSlot, this.container.getTankCapacity(index))).map(holder -> holder).iterator();
    }

    @Override
    public void onFinalCommit() {
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void setChanged(TransactionContext transaction) {
        class_1799 stack = this.ctx.getItemVariant().toStack();
        this.container.serialize(stack.method_7948());
        this.ctx.exchange(ItemVariant.of((class_1799)stack), this.ctx.getAmount(), transaction);
    }
}

