/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.blocks.TrashCanBlock;
import aztech.modern_industrialization.blocks.creativestorageunit.CreativeStorageUnitBlock;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerBlock;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelItem;
import aztech.modern_industrialization.blocks.storage.barrel.CreativeBarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.blocks.storage.tank.TankItem;
import aztech.modern_industrialization.blocks.storage.tank.creativetank.CreativeTankBlockEntity;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.TankPart;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4946;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7788;

public class MIBlock {
    public static SortedMap<class_2960, BlockDefinition<?>> BLOCKS = new TreeMap();
    public static final BlockDefinition<ForgeHammerBlock> FORGE_HAMMER = MIBlock.block("Forge Hammer", "forge_hammer", BlockDefinitionParams.defaultStone().withBlockConstructor(ForgeHammerBlock::new).sortOrder(SortOrder.FORGE_HAMMER).noModel().method_36557(6.0f).method_36558(1200.0f).method_9626(class_2498.field_11531), ForgeHammerBlock.class);
    public static final BlockDefinition<TrashCanBlock> TRASH_CAN = MIBlock.block("Automatic Trash Can", "trash_can", BlockDefinitionParams.defaultStone().withBlockConstructor(TrashCanBlock::new).method_36557(6.0f).method_36558(1200.0f), TrashCanBlock.class).withBlockRegistrationEvent(TrashCanBlock::onRegister);
    public static final BlockDefinition<class_2248> BASIC_MACHINE_HULL = MIBlock.block("Basic Machine Hull", "basic_machine_hull");
    public static final BlockDefinition<class_2248> ADVANCED_MACHINE_HULL = MIBlock.block("Advanced Machine Hull", "advanced_machine_hull");
    public static final BlockDefinition<class_2248> TURBO_MACHINE_HULL = MIBlock.block("Turbo Machine Hull", "turbo_machine_hull");
    public static final BlockDefinition<class_2248> HIGHLY_ADVANCED_MACHINE_HULL = MIBlock.block("Highly Advanced Machine Hull", "highly_advanced_machine_hull");
    public static final BlockDefinition<class_2248> QUANTUM_MACHINE_HULL = MIBlock.block("Quantum Machine Hull", "quantum_machine_hull", (class_4970.class_2251)BlockDefinitionParams.defaultStone().resistance(6000.0f));
    public static final BlockDefinition<class_2248> FUSION_CHAMBER = MIBlock.block("Fusion Chamber", "fusion_chamber");
    public static final BlockDefinition<class_2248> INDUSTRIAL_TNT = MIBlock.blockExplosive("Industrial TNT", "industrial_tnt");
    public static final BlockDefinition<class_2248> NUKE = MIBlock.blockExplosive("Nuke", "nuke");
    public static final BlockDefinition<TankBlock> CREATIVE_TANK = MIBlock.block("Creative Tank", "creative_tank", BlockDefinitionParams.defaultStone().withBlockConstructor(() -> new TankBlock(CreativeTankBlockEntity::new, StorageBehaviour.creative())).withBlockItemConstructor(TankItem::new).withModel(TankPart.MODEL_GENERATOR).withBlockEntityRendererItemModel().noLootTable(), TankBlock.class).withBlockRegistrationEvent((block, item) -> ((TankItem)item).registerItemApi());
    public static final BlockDefinition<BarrelBlock> CREATIVE_BARREL = MIBlock.block("Creative Barrel", "creative_barrel", BlockDefinitionParams.defaultStone().withBlockConstructor(p -> new BarrelBlock(CreativeBarrelBlockEntity::new, StorageBehaviour.creative())).withBlockItemConstructor(BarrelItem::new).withModel(class_4946.field_23038).withBlockEntityRendererItemModel().noLootTable(), BarrelBlock.class);
    public static final BlockDefinition<CreativeStorageUnitBlock> CREATIVE_STORAGE_UNIT = MIBlock.block("Creative Storage Unit", "creative_storage_unit", BlockDefinitionParams.defaultStone().withBlockConstructor(CreativeStorageUnitBlock::new));
    public static final BlockDefinition<class_2248> BLOCK_FIRE_CLAY_BRICKS = MIBlock.block("Fire Clay Bricks", "fire_clay_bricks", BlockDefinitionParams.of(class_4970.class_2251.method_9637().method_31710(class_3620.field_16023)).sortOrder(SortOrder.MATERIALS.and((Comparable)((Object)"fire_clay"))).method_36557(2.0f).method_36558(6.0f).method_29292());

    private static <T extends class_2248> BlockDefinition<T> block(String englishName, String id, T block, BiFunction<? super T, FabricItemSettings, class_1747> blockItemCtor, BiConsumer<class_2248, class_4910> modelGenerator, BiConsumer<class_1792, class_4915> itemModelGenerator, BiConsumer<class_2248, class_7788> lootTableGenerator, List<class_6862<class_2248>> tags, SortOrder sortOrder) {
        BlockDefinition<T> definition = new BlockDefinition<T>(englishName, id, block, blockItemCtor, modelGenerator, itemModelGenerator, lootTableGenerator, tags, sortOrder);
        if (BLOCKS.put(definition.getId(), definition) != null) {
            throw new IllegalArgumentException("Block id already taken : " + definition.getId());
        }
        return definition;
    }

    public static <T extends class_2248> BlockDefinition<T> block(String englishName, String id, BlockDefinitionParams<T> params) {
        return MIBlock.block(englishName, id, (class_2248)params.ctor.apply((class_4970.class_2251)params), params.blockItemCtor, params.modelGenerator, params.itemModelGenerator, params.lootTableGenerator, params.tags, params.sortOrder);
    }

    public static BlockDefinition<class_2248> block(String englishName, String id, class_4970.class_2251 params) {
        return MIBlock.block(englishName, id, params, class_2248.class);
    }

    public static <T extends class_2248> BlockDefinition<T> block(String englishName, String id, class_4970.class_2251 params, Class<T> blockClass) {
        return MIBlock.block(englishName, id, (BlockDefinitionParams)params);
    }

    public static BlockDefinition<class_2248> block(String englishName, String id) {
        return MIBlock.block(englishName, id, BlockDefinitionParams.defaultStone());
    }

    public static BlockDefinition<class_2248> blockExplosive(String englishName, String id) {
        return MIBlock.block(englishName, id, BlockDefinitionParams.of(class_4970.class_2251.method_9637().method_31710(class_3620.field_16002).method_50013().method_9618().method_9626(class_2498.field_11535)).clearTags().noModel());
    }

    public static class BlockDefinitionParams<T extends class_2248>
    extends FabricBlockSettings {
        public BiConsumer<class_2248, class_4910> modelGenerator;
        public BiConsumer<class_1792, class_4915> itemModelGenerator = (item, gen) -> {};
        public BiConsumer<class_2248, class_7788> lootTableGenerator;
        public final ArrayList<class_6862<class_2248>> tags = new ArrayList();
        public SortOrder sortOrder = SortOrder.BLOCKS_OTHERS;
        public Function<class_4970.class_2251, T> ctor;
        public BiFunction<? super T, FabricItemSettings, class_1747> blockItemCtor;

        protected BlockDefinitionParams(class_4970.class_2251 properties, Function<class_4970.class_2251, T> ctor, BiFunction<? super T, FabricItemSettings, class_1747> blockItemCtor, BiConsumer<class_2248, class_4910> modelGenerator, BiConsumer<class_2248, class_7788> lootTableGenerator, List<class_6862<class_2248>> tags) {
            super(properties);
            this.ctor = ctor;
            this.blockItemCtor = blockItemCtor;
            this.modelGenerator = modelGenerator;
            this.lootTableGenerator = lootTableGenerator;
            this.tags.addAll(tags);
        }

        public static BlockDefinitionParams<class_2248> of(class_4970.class_2251 properties) {
            return new BlockDefinitionParams<class_2248>(properties, class_2248::new, class_1747::new, (block, modelGenerator) -> modelGenerator.method_25641(block), (block, lootGenerator) -> lootGenerator.method_46025(block), List.of(class_3481.field_33719, class_3481.field_33715));
        }

        public static BlockDefinitionParams<class_2248> defaultStone() {
            return BlockDefinitionParams.of(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_36557(4.0f).method_29292());
        }

        public <U extends class_2248> BlockDefinitionParams<U> withBlockConstructor(Function<class_4970.class_2251, U> ctor) {
            return new BlockDefinitionParams<T>((class_4970.class_2251)this, ctor, this.blockItemCtor, this.modelGenerator, this.lootTableGenerator, this.tags);
        }

        public <U extends class_2248> BlockDefinitionParams<U> withBlockConstructor(Supplier<U> ctor) {
            return new BlockDefinitionParams<T>((class_4970.class_2251)this, p -> (class_2248)ctor.get(), this.blockItemCtor, this.modelGenerator, this.lootTableGenerator, this.tags);
        }

        public BlockDefinitionParams<T> withBlockItemConstructor(BiFunction<? super T, FabricItemSettings, class_1747> blockItemCtor) {
            this.blockItemCtor = blockItemCtor;
            return this;
        }

        public BlockDefinitionParams<T> withModel(BiConsumer<class_2248, class_4910> modelGenerator) {
            this.modelGenerator = modelGenerator;
            return this;
        }

        public BlockDefinitionParams<T> withModel(class_4946.class_4947 model) {
            return this.withModel((class_2248 block, class_4910 blockModelGenerator) -> blockModelGenerator.method_25622(block, model));
        }

        public BlockDefinitionParams<T> withItemModel(BiConsumer<class_1792, class_4915> itemModelGenerator) {
            this.itemModelGenerator = itemModelGenerator;
            return this;
        }

        public BlockDefinitionParams<T> withBlockEntityRendererItemModel() {
            BiConsumer<class_2248, class_4910> currentModel = this.modelGenerator;
            return this.withModel((class_2248 block, class_4910 gen) -> {
                currentModel.accept((class_2248)block, (class_4910)gen);
                gen.method_25540(block);
            }).withItemModel((item, gen) -> gen.field_22844.accept(class_4941.method_25840((class_1792)item), () -> {
                JsonObject json = JsonParser.parseString((String)"{\n    \"display\": {\n        \"gui\": {\n            \"rotation\": [ 30, 225, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 0.625, 0.625, 0.625 ]\n        },\n        \"ground\": {\n            \"rotation\": [ 0, 0, 0 ],\n            \"translation\": [ 0, 3, 0],\n            \"scale\":[ 0.25, 0.25, 0.25 ]\n        },\n        \"fixed\": {\n            \"rotation\": [ 0, 0, 0 ],\n            \"translation\": [ 0, 0, 0],\n            \"scale\":[ 0.5, 0.5, 0.5 ]\n        },\n        \"thirdperson_righthand\": {\n            \"rotation\": [ 75, 45, 0 ],\n            \"translation\": [ 0, 2.5, 0],\n            \"scale\": [ 0.375, 0.375, 0.375 ]\n        },\n        \"firstperson_righthand\": {\n            \"rotation\": [ 0, 45, 0 ],\n            \"translation\": [ 0, 0, 0 ],\n            \"scale\": [ 0.40, 0.40, 0.40 ]\n        },\n        \"firstperson_lefthand\": {\n            \"rotation\": [ 0, 225, 0 ],\n            \"translation\": [ 0, 0, 0 ],\n            \"scale\": [ 0.40, 0.40, 0.40 ]\n        }\n    }\n}\n").getAsJsonObject();
                json.addProperty("parent", "builtin/entity");
                return json;
            }));
        }

        public BlockDefinitionParams<T> withLootTable(BiConsumer<class_2248, class_7788> lootTableGenerator) {
            this.lootTableGenerator = lootTableGenerator;
            return this;
        }

        public BlockDefinitionParams<T> noModel() {
            this.modelGenerator = (block, modelGenerator) -> modelGenerator.method_25681(block);
            return this;
        }

        public BlockDefinitionParams<T> noLootTable() {
            this.lootTableGenerator = null;
            return this;
        }

        public BlockDefinitionParams<T> clearTags() {
            this.tags.clear();
            return this;
        }

        public BlockDefinitionParams<T> addMoreTags(class_6862<class_2248> ... tagsToAdd) {
            return this.addMoreTags(Arrays.asList(tagsToAdd));
        }

        public BlockDefinitionParams<T> addMoreTags(Collection<class_6862<class_2248>> tagsToAdd) {
            this.tags.addAll(tagsToAdd);
            return this;
        }

        public BlockDefinitionParams<T> sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }
    }
}

