/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.blocks.storage.AbstractStorageBlock;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelItem;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.util.MobSpawning;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class BarrelBlock
extends AbstractStorageBlock<ItemVariant>
implements class_2343 {
    public BarrelBlock(class_2343 factory, StorageBehaviour<ItemVariant> behaviour) {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_36557(4.0f).method_26235(MobSpawning.NO_SPAWN), factory, behaviour);
    }

    public static void setupBarrelEvents() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_2586 patt2695$temp = world.method_8321(hitResult.method_17777());
            if (patt2695$temp instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)patt2695$temp;
                if (hitResult.method_17780().method_10166().method_10179()) {
                    ItemVariant currentInHand;
                    if (barrel.behaviour.isCreative() && !(currentInHand = ItemVariant.of((class_1799)player.method_6047())).isBlank() && barrel.isResourceBlank()) {
                        barrel.setResource(currentInHand);
                        return class_1269.method_29236((boolean)world.field_9236);
                    }
                    if (!player.method_5715()) {
                        BarrelItem barrelItem;
                        ContainerItem.GenericItemStorage<ItemVariant> storage;
                        class_1799 stack = player.method_5998(hand);
                        class_1792 patt3370$temp = stack.method_7909();
                        if (patt3370$temp instanceof BarrelItem && StorageUtil.move(storage = ContainerItem.GenericItemStorage.of(stack, barrelItem = (BarrelItem)patt3370$temp), (Storage)barrel, itemVariant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                            return class_1269.method_29236((boolean)world.field_9236);
                        }
                        if (StorageUtil.move((Storage)((Storage)PlayerInventoryStorage.of((class_1657)player).getSlots().get(player.method_31548().field_7545)), (Storage)barrel, itemVariant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                            return class_1269.method_29236((boolean)world.field_9236);
                        }
                    } else {
                        currentInHand = ItemVariant.of((class_1799)player.method_6047());
                        if (StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), (Storage)barrel, itemVariant -> itemVariant.equals(currentInHand), (long)Long.MAX_VALUE, null) > 0L) {
                            return class_1269.method_29236((boolean)world.field_9236);
                        }
                    }
                }
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            class_2586 patt4695$temp = world.method_8321(pos);
            if (patt4695$temp instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)patt4695$temp;
                if (direction.method_10166().method_10179() && !barrel.isEmpty()) {
                    BarrelItem barrelItem;
                    ContainerItem.GenericItemStorage<ItemVariant> storage;
                    class_1799 stack = player.method_5998(hand);
                    class_1792 patt4921$temp = stack.method_7909();
                    if (patt4921$temp instanceof BarrelItem && StorageUtil.move((Storage)barrel, storage = ContainerItem.GenericItemStorage.of(stack, barrelItem = (BarrelItem)patt4921$temp), itemVariant -> true, (long)Long.MAX_VALUE, null) > 0L) {
                        return class_1269.method_29236((boolean)world.field_9236);
                    }
                    try (Transaction transaction = Transaction.openOuter();){
                        ItemVariant extractedResource = (ItemVariant)barrel.getResource();
                        long extracted = barrel.extract((ItemVariant)barrel.getResource(), player.method_5715() ? 1L : (long)((ItemVariant)barrel.getResource()).getItem().method_7882(), (TransactionContext)transaction);
                        PlayerInventoryStorage.of((class_1657)player).offerOrDrop(extractedResource, extracted, (TransactionContext)transaction);
                        transaction.commit();
                        CommonProxy.INSTANCE.delayNextBlockAttack(player);
                    }
                    return class_1269.method_29236((boolean)world.field_9236);
                }
            }
            return class_1269.field_5811;
        });
    }

    public static BarrelStorage withStackCapacity(long stackCapacity) {
        return new BarrelStorage(stackCapacity);
    }

    public static class BarrelStorage
    extends StorageBehaviour<ItemVariant> {
        public final long stackCapacity;

        public BarrelStorage(long stackCapacity) {
            this.stackCapacity = stackCapacity;
        }

        @Override
        public boolean isLockable() {
            return true;
        }

        @Override
        public long getCapacityForResource(ItemVariant resource) {
            if (resource.isBlank()) {
                return this.stackCapacity * 64L;
            }
            return this.stackCapacity * (long)resource.getItem().method_7882();
        }

        @Override
        public boolean canInsert(ItemVariant resource) {
            return resource.getItem().method_31568();
        }
    }
}

