/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2.pipe;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AEColor;
import aztech.modern_industrialization.compat.ae2.pipe.MENetwork;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class MENetworkNode
extends PipeNetworkNode {
    @Nullable
    IManagedGridNode mainNode;
    int connectDelay = 0;
    final Set<class_2350> connections = EnumSet.noneOf(class_2350.class);

    void updateNode() {
        if (this.mainNode == null && this.connections.size() > 0) {
            this.mainNode = GridHelper.createManagedNode((Object)this, (nodeOwner, node) -> {}).setFlags(new GridFlags[]{GridFlags.PREFERRED}).setIdlePowerUsage(0.0);
        }
        if (this.mainNode != null && this.connections.size() == 0) {
            this.mainNode.destroy();
            this.mainNode = null;
        }
    }

    @Override
    public void buildInitialConnections(class_1937 world, class_2338 pos) {
    }

    @Override
    public void updateConnections(class_1937 world, class_2338 pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((class_3218)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, (class_2350)connection)) continue;
                return true;
            }
            return false;
        });
        this.updateNode();
        this.connectDelay = 0;
    }

    @Override
    public PipeEndpointType[] getConnections(class_2338 pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (class_2350 direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.method_10146()] = PipeEndpointType.PIPE;
        }
        for (class_2350 connection : this.connections) {
            connections[connection.method_10146()] = PipeEndpointType.BLOCK;
        }
        return connections;
    }

    @Override
    public void removeConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        this.connections.remove(direction);
        if (this.mainNode != null && this.mainNode.isReady()) {
            for (IGridConnection conn : this.mainNode.getNode().getConnections()) {
                if (conn.getDirection(this.mainNode.getNode()) != direction) continue;
                conn.destroy();
                break;
            }
        }
        this.updateNode();
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, class_1657 player, class_1937 world, class_2338 pos, class_2350 direction) {
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(direction);
            this.updateNode();
            this.connectDelay = 0;
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        tag.method_10567("connections", NbtHelper.encodeDirections(this.connections));
        if (this.mainNode != null) {
            this.mainNode.saveToNBT(tag);
        }
        return tag;
    }

    @Override
    public void fromTag(class_2487 tag) {
        this.connections.clear();
        this.connections.addAll(Arrays.asList(NbtHelper.decodeDirections(tag.method_10571("connections"))));
        this.updateNode();
        if (this.mainNode != null) {
            this.mainNode.loadFromNBT(tag);
        }
    }

    private boolean canConnect(class_1937 world, class_2338 pos, class_2350 direction) {
        IGridNode node = GridHelper.getExposedNode((class_1937)world, (class_2338)pos.method_10093(direction), (class_2350)direction.method_10153());
        return node != null && MENetworkNode.areColorsCompatible(((MENetwork)this.network).color, node.getGridColor());
    }

    static boolean areColorsCompatible(AEColor color1, AEColor color2) {
        return color1 == AEColor.TRANSPARENT || color2 == AEColor.TRANSPARENT || color1 == color2;
    }

    @Override
    public void onUnload() {
        if (this.mainNode != null) {
            this.mainNode.destroy();
            this.mainNode = null;
        }
    }
}

