/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.material;

import aztech.modern_industrialization.compat.kubejs.material.PartJsonCreator;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.property.MaterialHardness;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.recipe.ForgeHammerRecipes;
import aztech.modern_industrialization.materials.recipe.SmeltingRecipes;
import aztech.modern_industrialization.materials.recipe.StandardRecipes;
import aztech.modern_industrialization.materials.set.MaterialSet;
import com.google.gson.JsonObject;

class MaterialBuilderJSWrapper {
    protected MaterialBuilder materialBuilder;
    private final PartJsonCreator creator = new PartJsonCreator();

    public MaterialBuilderJSWrapper(MaterialBuilder materialBuilder) {
        this.materialBuilder = materialBuilder;
    }

    public MaterialBuilderJSWrapper hardness(String hardness) {
        this.materialBuilder.set(MaterialProperty.HARDNESS, MaterialHardness.valueOf(hardness.toUpperCase()));
        return this;
    }

    public MaterialBuilderJSWrapper materialSet(String materialSet) {
        this.materialBuilder.set(MaterialProperty.SET, MaterialSet.valueOf(materialSet.toUpperCase()));
        return this;
    }

    public MaterialBuilderJSWrapper setMainPart(String name) {
        this.materialBuilder.set(MaterialProperty.MAIN_PART, new PartKey(name));
        return this;
    }

    public MaterialBuilderJSWrapper addParts(String ... name) {
        for (String s : name) {
            this.materialBuilder.addParts(this.creator.regularPart(s));
        }
        return this;
    }

    public MaterialBuilderJSWrapper addExternalPart(String part, String id, String tag) {
        this.materialBuilder.addMaterialItemParts(MaterialItemPart.external(new PartKey(part), tag, id));
        return this;
    }

    public MaterialBuilderJSWrapper addExternalPart(String part, String id) {
        return this.addExternalPart(part, id, id);
    }

    public MaterialBuilderJSWrapper battery(long energyCapacity) {
        this.materialBuilder.addParts(this.creator.batteryPart(energyCapacity));
        return this;
    }

    public MaterialBuilderJSWrapper barrel(int stackCapacity) {
        this.materialBuilder.addParts(this.creator.barrelPart(stackCapacity));
        return this;
    }

    public MaterialBuilderJSWrapper barrel(String englishName, String path, int stackCapacity) {
        this.materialBuilder.addParts(this.creator.barrelPart(englishName, path, stackCapacity));
        return this;
    }

    public MaterialBuilderJSWrapper block(String materialSet) {
        this.materialBuilder.addParts(this.creator.blockPart(materialSet));
        return this;
    }

    public MaterialBuilderJSWrapper cable(String tier) {
        this.materialBuilder.addParts(this.creator.cablePart(tier));
        return this;
    }

    public MaterialBuilderJSWrapper machineCasing(String englishName, String path) {
        this.materialBuilder.addParts(this.creator.machineCasing(englishName, path));
        return this;
    }

    public MaterialBuilderJSWrapper machineCasing(String englishName, String path, float resistance) {
        this.materialBuilder.addParts(this.creator.machineCasing(englishName, path, resistance));
        return this;
    }

    public MaterialBuilderJSWrapper machineCasing(float resistance) {
        this.materialBuilder.addParts(this.creator.machineCasing(resistance));
        return this;
    }

    public MaterialBuilderJSWrapper machineCasing() {
        this.materialBuilder.addParts(this.creator.machineCasing());
        return this;
    }

    public MaterialBuilderJSWrapper pipeCasing(float resistance) {
        this.materialBuilder.addParts(this.creator.pipeCasing(resistance));
        return this;
    }

    public MaterialBuilderJSWrapper pipeCasing() {
        this.materialBuilder.addParts(this.creator.pipeCasing());
        return this;
    }

    public MaterialBuilderJSWrapper specialCasing(String englishName, String path) {
        this.materialBuilder.addParts(this.creator.specialCasing(englishName, path));
        return this;
    }

    public MaterialBuilderJSWrapper specialCasing(String englishName, String path, float resistance) {
        this.materialBuilder.addParts(this.creator.specialCasing(englishName, path, resistance));
        return this;
    }

    public MaterialBuilderJSWrapper ore(JsonObject json, boolean deepslate) {
        this.materialBuilder.addParts(this.creator.orePart(json, deepslate));
        return this;
    }

    public MaterialBuilderJSWrapper ore(JsonObject json) {
        this.materialBuilder.addParts(this.creator.orePart(json, true));
        this.materialBuilder.addParts(this.creator.orePart(json, false));
        return this;
    }

    public MaterialBuilderJSWrapper rawMetal(String materialSet, boolean block) {
        this.materialBuilder.addParts(this.creator.rawMetalPart(materialSet, block));
        return this;
    }

    public MaterialBuilderJSWrapper rawMetal(String materialSet) {
        this.materialBuilder.addParts(this.creator.rawMetalPart(materialSet, true));
        this.materialBuilder.addParts(this.creator.rawMetalPart(materialSet, false));
        return this;
    }

    public MaterialBuilderJSWrapper tank(int bucketCapacity) {
        this.materialBuilder.addParts(this.creator.tankPart(bucketCapacity));
        return this;
    }

    public MaterialBuilderJSWrapper tank(String englishName, String path, int bucketCapacity) {
        this.materialBuilder.addParts(this.creator.tankPart(englishName, path, bucketCapacity));
        return this;
    }

    public MaterialBuilderJSWrapper customRegularPart(String englishName, String name) {
        this.materialBuilder.addParts(this.creator.customRegularPart(englishName, name));
        return this;
    }

    public MaterialBuilderJSWrapper defaultRecipes() {
        this.materialBuilder.addRecipes(StandardRecipes::apply);
        this.materialBuilder.addRecipes(SmeltingRecipes::apply);
        return this;
    }

    public MaterialBuilderJSWrapper forgeHammerRecipes() {
        this.materialBuilder.addRecipes(ForgeHammerRecipes::apply);
        return this;
    }
}

