/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.compat.kubejs.recipe.ProcessConditionHelper;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.InputReplacement;
import dev.latvian.mods.kubejs.recipe.ItemMatch;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.apache.commons.lang3.ArrayUtils;

public final class MachineRecipeSchema {
    private static final RecipeComponent<Integer> POSITIVE_INTEGER = NumberComponent.intRange((int)1, (int)Integer.MAX_VALUE);
    private static final RecipeComponent<Float> PROBABILITY = NumberComponent.floatRange((float)0.0f, (float)1.0f);
    private static final RecipeComponent<ChancedInputItem> ITEM_INPUT = new RecipeComponent<ChancedInputItem>(){

        public String componentType() {
            return "modern_industrialization_item_input";
        }

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return ChancedInputItem.class;
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.inputItemHasPriority(from);
        }

        public JsonElement write(RecipeJS recipe, ChancedInputItem value) {
            JsonObject obj = new JsonObject();
            obj.add("ingredient", value.input().ingredient.method_8089());
            obj.addProperty("amount", (Number)value.input().count);
            obj.addProperty("probability", (Number)Float.valueOf(value.probability()));
            return obj;
        }

        public ChancedInputItem read(RecipeJS recipe, Object from) {
            if (!(from instanceof JsonObject)) {
                throw new IllegalArgumentException("Expected an object, got " + from);
            }
            JsonObject json = (JsonObject)from;
            MachineRecipe.ItemInput input = MachineRecipeType.readItemInput(json);
            return new ChancedInputItem(InputItem.of((class_1856)input.ingredient, (int)input.amount), input.probability);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isInput(RecipeJS recipe, ChancedInputItem value, ReplacementMatch match) {
            if (!(match instanceof ItemMatch)) return false;
            ItemMatch m = (ItemMatch)match;
            if (value.input().isEmpty()) return false;
            if (!m.contains(value.input().ingredient)) return false;
            return true;
        }

        public ChancedInputItem replaceInput(RecipeJS recipe, ChancedInputItem original, ReplacementMatch match, InputReplacement with) {
            if (this.isInput(recipe, original, match) && with instanceof InputItem) {
                InputItem w = (InputItem)with;
                return new ChancedInputItem(w.withCount(original.input().count), original.probability());
            }
            return original;
        }

        public String checkEmpty(RecipeKey<ChancedInputItem> key, ChancedInputItem value) {
            if (value.input().isEmpty()) {
                return "Ingredient '" + key.name + "' can't be empty!";
            }
            return "";
        }

        public String toString() {
            return this.componentType();
        }
    };
    private static final RecipeKey<Integer> EU = NumberComponent.intRange((int)1, (int)Integer.MAX_VALUE).key("eu");
    private static final RecipeKey<Integer> DURATION = NumberComponent.intRange((int)1, (int)Integer.MAX_VALUE).key("duration");
    private static final RecipeKey<ChancedInputItem[]> ITEM_INPUTS = ITEM_INPUT.asArrayOrSelf().key("item_inputs");
    private static final RecipeKey<OutputItem[]> ITEM_OUTPUTS = ItemComponents.OUTPUT.asArrayOrSelf().key("item_outputs");
    public static final RecipeSchema SCHEMA = new RecipeSchema(MachineRecipeJS.class, MachineRecipeJS::new, new RecipeKey[]{EU, DURATION, ITEM_INPUTS.optional(ty -> new ChancedInputItem[0]), ITEM_OUTPUTS.optional(ty -> new OutputItem[0])}).constructor(new RecipeKey[]{EU, DURATION});
    private static final RecipeKey<Integer> HAMMER_DAMAGE = NumberComponent.INT.key("hammer_damage").optional((Object)0);
    public static final RecipeSchema FORGE_HAMMER_SCHEMA = new RecipeSchema(MachineRecipeJS.class, MachineRecipeJS::new, new RecipeKey[]{HAMMER_DAMAGE, ITEM_INPUTS, ITEM_OUTPUTS}).constructor(new RecipeKey[]{HAMMER_DAMAGE});

    private MachineRecipeSchema() {
    }

    public record ChancedInputItem(InputItem input, float probability) {
    }

    public static class MachineRecipeJS
    extends RecipeJS
    implements ProcessConditionHelper {
        public MachineRecipeJS itemIn(InputItem ingredient) {
            return this.itemIn(ingredient, 1.0f);
        }

        public MachineRecipeJS itemIn(InputItem ingredient, float chance) {
            this.setValue(ITEM_INPUTS, (ChancedInputItem[])ArrayUtils.add((Object[])((ChancedInputItem[])this.getValue(ITEM_INPUTS)), (Object)new ChancedInputItem(ingredient, chance)));
            return this;
        }

        public MachineRecipeJS itemOut(OutputItem output) {
            return this.itemOut(output, 1.0f);
        }

        public MachineRecipeJS itemOut(OutputItem output, float chance) {
            this.setValue(ITEM_OUTPUTS, (OutputItem[])ArrayUtils.add((Object[])((OutputItem[])this.getValue(ITEM_OUTPUTS)), (Object)output.withChance((double)chance)));
            return this;
        }

        public MachineRecipeJS fluidIn(class_3611 fluid, int amount) {
            return this.fluidIn(fluid, amount, 1.0f);
        }

        public MachineRecipeJS fluidIn(class_3611 fluid, double mbs, float chance) {
            if (!this.json.has("fluid_inputs")) {
                this.json.add("fluid_inputs", (JsonElement)new JsonArray());
            }
            JsonObject input = new JsonObject();
            input.addProperty("fluid", class_7923.field_41173.method_10221((Object)fluid).toString());
            input.addProperty("amount", (Number)mbs);
            input.addProperty("probability", (Number)Float.valueOf(chance));
            this.json.get("fluid_inputs").getAsJsonArray().add((JsonElement)input);
            this.changed = true;
            return this;
        }

        public MachineRecipeJS fluidOut(class_3611 fluid, int amount) {
            return this.fluidOut(fluid, amount, 1.0f);
        }

        public MachineRecipeJS fluidOut(class_3611 fluid, double mbs, float chance) {
            if (!this.json.has("fluid_outputs")) {
                this.json.add("fluid_outputs", (JsonElement)new JsonArray());
            }
            JsonObject output = new JsonObject();
            output.addProperty("fluid", class_7923.field_41173.method_10221((Object)fluid).toString());
            output.addProperty("amount", (Number)mbs);
            output.addProperty("probability", (Number)Float.valueOf(chance));
            this.json.get("fluid_outputs").getAsJsonArray().add((JsonElement)output);
            this.changed = true;
            return this;
        }

        @Override
        public MachineRecipeJS processCondition(MachineProcessCondition condition) {
            if (!this.json.has("process_conditions")) {
                this.json.add("process_conditions", (JsonElement)new JsonArray());
            }
            this.json.get("process_conditions").getAsJsonArray().add((JsonElement)condition.toJson());
            this.changed = true;
            return this;
        }

        private float readProbability(JsonObject object) {
            JsonElement jsonElement = object.get("probability");
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive probability = (JsonPrimitive)jsonElement;
                return probability.getAsFloat();
            }
            return 1.0f;
        }

        public JsonElement writeOutputItem(OutputItem value) {
            JsonObject json = new JsonObject();
            json.addProperty("item", class_7923.field_41178.method_10221((Object)value.item.method_7909()).toString());
            json.addProperty("amount", (Number)value.item.method_7947());
            if (value.hasChance()) {
                json.addProperty("probability", (Number)value.getChance());
            }
            return json;
        }
    }
}

