/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.nuclear.FluidNuclearComponents;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.TextHelper;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ThermalInteractionCategory
extends ViewerCategory<Recipe> {
    private final int centerX;
    private final int px;
    private final int py;

    protected ThermalInteractionCategory() {
        super(Recipe.class, (class_2960)new MIIdentifier("thermal_interaction"), (class_2561)MIText.ThermalInteraction.text(), new ViewerCategory.Icon.Texture(MachineScreen.SLOT_ATLAS, 145, 1), 150, 100);
        this.centerX = this.width / 2;
        this.px = this.centerX - 9;
        this.py = 22;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept("nuclear_reactor");
    }

    @Override
    public void buildRecipes(class_1863 recipeManager, class_5455 registryAccess, Consumer<Recipe> consumer) {
        class_7923.field_41178.method_10220().filter(item -> item instanceof NuclearComponentItem).forEach(item -> {
            NuclearComponentItem component = (NuclearComponentItem)item;
            consumer.accept(new Recipe(component, CategoryType.THERMAL_PROPERTIES));
            if (item instanceof NuclearFuel) {
                consumer.accept(new Recipe(component, CategoryType.NEUTRON_EFFICIENCY));
            }
        });
        for (class_3611 fluid : class_7923.field_41173) {
            FluidVariant variant;
            INuclearComponent<FluidVariant> component;
            if (!fluid.method_15793(fluid.method_15785()) || fluid == class_3612.field_15906 || (component = FluidNuclearComponents.of(variant = FluidVariant.of((class_3611)fluid))) == null) continue;
            consumer.accept(new Recipe(component, CategoryType.THERMAL_PROPERTIES));
        }
        for (final String s : new String[]{"item", "fluid"}) {
            consumer.accept(new Recipe(new INuclearComponent<ItemVariant>(){

                @Override
                public double getHeatConduction() {
                    return 0.01;
                }

                @Override
                public INeutronBehaviour getNeutronBehaviour() {
                    return null;
                }

                @Override
                public int getMaxTemperature() {
                    return 3250;
                }

                @Override
                public ItemVariant getVariant() {
                    return ItemVariant.of((class_1935)((class_1935)class_7923.field_41178.method_10223((class_2960)new MIIdentifier(String.format("nuclear_%s_hatch", s)))));
                }
            }, CategoryType.THERMAL_PROPERTIES));
        }
    }

    @Override
    public void buildLayout(Recipe recipe, ViewerCategory.LayoutBuilder builder) {
        builder.inputSlot(this.px, 22).variant((TransferVariant<?>)recipe.nuclearComponent.getVariant());
    }

    @Override
    public void buildWidgets(Recipe recipe, ViewerCategory.WidgetList widgets) {
        widgets.text((class_2561)(switch (recipe.type) {
            default -> throw new IncompatibleClassChangeError();
            case CategoryType.NEUTRON_EFFICIENCY -> MIText.NeutronProductionTemperatureEffect.text();
            case CategoryType.THERMAL_PROPERTIES -> MIText.ThermalInteraction.text();
        }), this.centerX, 8.0f, ViewerCategory.TextAlign.CENTER, false, true, null);
        switch (recipe.type) {
            case NEUTRON_EFFICIENCY: {
                NuclearFuel nuclearComponent = (NuclearFuel)recipe.nuclearComponent;
                Rectangle area = new Rectangle(10, 45, this.width - 20, this.height - 50);
                widgets.rectangle(area, -7631989);
                int py = this.height - 14;
                widgets.text((class_2561)class_2561.method_43470((String)"0\u00b0C"), 11.0f, py, ViewerCategory.TextAlign.LEFT, true, false, null);
                widgets.text((class_2561)class_2561.method_43470((String)String.format("%d\u00b0C", nuclearComponent.tempLimitLow)), this.centerX, py, ViewerCategory.TextAlign.CENTER, true, false, null);
                widgets.text((class_2561)class_2561.method_43470((String)String.format("%d\u00b0C", nuclearComponent.tempLimitHigh)), this.width - 10, py, ViewerCategory.TextAlign.RIGHT, true, false, null);
                widgets.drawable(guiGraphics -> {
                    int i;
                    class_437 helper = class_310.method_1551().field_1755;
                    for (i = 1; i < area.w() / 2; ++i) {
                        guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, area.x() + i, area.y() + 4, 0, 255, 1, 1);
                    }
                    for (i = area.w() / 2; i < area.w() - 1; ++i) {
                        double f = ((double)i - (double)area.w() / 2.0) / ((double)area.w() - (double)area.w() / 2.0);
                        int y = (int)((1.0 - f) * (double)(area.y() + 4) + f * (double)(area.y() + area.h() - 14));
                        guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, area.x() + i, y, 0, 255, 1, 1);
                    }
                });
                widgets.text((class_2561)class_2561.method_43470((String)String.format("%.1f", nuclearComponent.neutronMultiplicationFactor)), 11.0f, area.y() + 2, ViewerCategory.TextAlign.LEFT, false, false, null);
                widgets.text((class_2561)class_2561.method_43470((String)"0"), this.width - 10, py - 10, ViewerCategory.TextAlign.RIGHT, false, false, null);
                break;
            }
            case THERMAL_PROPERTIES: {
                INuclearComponent<?> nuclearComponent = recipe.nuclearComponent;
                int centerX = this.width / 2;
                int centerY = this.height / 2;
                class_5250 heatConduction = MIText.HeatConduction.text(String.format("%d", (int)(1000.0 * nuclearComponent.getHeatConduction()))).method_10862(TextHelper.HEAT_CONDUCTION);
                widgets.text((class_2561)heatConduction, centerX, centerY, ViewerCategory.TextAlign.CENTER, false, false, null);
                int maxTemperature = nuclearComponent.getMaxTemperature();
                if (maxTemperature == Integer.MAX_VALUE) break;
                class_5250 maxTemp = MIText.MaxTemp.text(maxTemperature).method_10862(TextHelper.MAX_TEMP_TEXT);
                widgets.text((class_2561)maxTemp, centerX, centerY + 12, ViewerCategory.TextAlign.CENTER, false, false, null);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected record Recipe(INuclearComponent<?> nuclearComponent, CategoryType type) {
    }

    @Environment(value=EnvType.CLIENT)
    static enum CategoryType {
        NEUTRON_EFFICIENCY,
        THERMAL_PROPERTIES;

    }
}

