/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.blocks.TickableBlock;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.machines.models.MachineCasing;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class MachineBlock
extends class_2248
implements TickableBlock {
    private final BiFunction<class_2338, class_2680, MachineBlockEntity> blockEntityConstructor;
    private volatile MachineBlockEntity blockEntityInstance = null;
    public static final Map<String, MachineCasing> REGISTERED_MACHINES = new HashMap<String, MachineCasing>();

    public MachineBlock(BiFunction<class_2338, class_2680, MachineBlockEntity> blockEntityConstructor, class_4970.class_2251 properties) {
        super(properties);
        this.blockEntityConstructor = blockEntityConstructor;
    }

    public MachineBlockEntity newBlockEntity(class_2338 pos, class_2680 state) {
        return this.blockEntityConstructor.apply(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 be = world.method_8321(pos);
        if (be instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)be;
            class_1269 beResult = machine.onUse(player, hand, MachineOverlay.findHitSide(hit));
            if (beResult.method_23665()) {
                world.method_8408(pos, class_2246.field_10124);
                return beResult;
            }
            machine.openMenu(player);
        }
        return class_1269.field_21466;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 be = world.method_8321(pos);
        ((MachineBlockEntity)be).onPlaced(placer, itemStack);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 be;
        if (!state.method_27852(newState.method_26204()) && (be = world.method_8321(pos)) instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)be;
            List<class_1799> dropExtra = machine.dropExtra();
            for (ConfigurableItemStack stack : machine.getInventory().getItemStacks()) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)((ItemVariant)stack.getResource()).toStack((int)stack.getAmount()));
                stack.setAmount(0L);
            }
            for (class_1799 extra : dropExtra) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)extra);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public MachineBlockEntity getBlockEntityInstance() {
        if (this.blockEntityInstance == null) {
            this.blockEntityInstance = this.newBlockEntity(class_2338.field_10980, this.method_9564());
        }
        return this.blockEntityInstance;
    }

    public boolean method_9498(class_2680 state) {
        return this.getBlockEntityInstance().hasComparatorOutput();
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)class_25862;
            return machine.getComparatorOutput();
        }
        return 0;
    }
}

