/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.FluidItemConsumerComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class GeneratorMachineBlockEntity
extends MachineBlockEntity
implements Tickable,
EnergyComponentHolder {
    private final CableTier outputTier;
    private final MIEnergyStorage extractable;
    protected final MIInventory inventory;
    protected EnergyComponent energy;
    protected IsActiveComponent isActiveComponent;
    protected FluidItemConsumerComponent fluidItemConsumer;

    public GeneratorMachineBlockEntity(BEP bep, String name, CableTier outputTier, long energyCapacity, long fluidCapacity, FluidItemConsumerComponent fluidItemConsumer) {
        super(bep, new MachineGuiParameters.Builder(name, fluidItemConsumer.doAllowMoreThanOne()).build(), new OrientationComponent.Params(true, false, false));
        List<Object> fluidStacks;
        List<ConfigurableItemStack> itemStacks;
        this.outputTier = outputTier;
        this.energy = new EnergyComponent((class_2586)this, energyCapacity);
        this.extractable = this.energy.buildExtractable(tier -> tier == outputTier);
        this.isActiveComponent = new IsActiveComponent();
        this.fluidItemConsumer = fluidItemConsumer;
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        this.registerGuiComponent(new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity));
        SlotPositions itemPositions = SlotPositions.empty();
        SlotPositions fluidPositions = SlotPositions.empty();
        FluidItemConsumerComponent.NumberOfFuel numberOfFluid = fluidItemConsumer.fluidEUProductionMap.getNumberOfFuel();
        FluidItemConsumerComponent.NumberOfFuel numberOfItem = fluidItemConsumer.itemEUProductionMap.getNumberOfFuel();
        if (numberOfFluid == FluidItemConsumerComponent.NumberOfFuel.NONE && numberOfItem == FluidItemConsumerComponent.NumberOfFuel.NONE) {
            throw new IllegalArgumentException(String.format("GeneratorMachineBlockEntity %s must accept at least one item or fluid", name));
        }
        if (numberOfItem != FluidItemConsumerComponent.NumberOfFuel.NONE) {
            itemStacks = numberOfItem == FluidItemConsumerComponent.NumberOfFuel.MANY ? List.of(ConfigurableItemStack.standardInputSlot()) : List.of(ConfigurableItemStack.lockedInputSlot(fluidItemConsumer.itemEUProductionMap.getAllAccepted().iterator().next()));
        } else {
            itemStacks = Collections.emptyList();
            itemPositions = SlotPositions.empty();
            fluidPositions = new SlotPositions.Builder().addSlot(25, 38).build();
        }
        if (numberOfFluid != FluidItemConsumerComponent.NumberOfFuel.NONE) {
            if (fluidCapacity == 0L) {
                throw new IllegalArgumentException(String.format("GeneratorMachineBlockEntity %s must have a fluid capacity > 0 has it accepts fluids", name));
            }
            fluidStacks = numberOfFluid == FluidItemConsumerComponent.NumberOfFuel.MANY ? List.of(ConfigurableFluidStack.standardInputSlot(81L * fluidCapacity)) : List.of(ConfigurableFluidStack.lockedInputSlot(81L * fluidCapacity, fluidItemConsumer.fluidEUProductionMap.getAllAccepted().iterator().next()));
            if (numberOfItem != FluidItemConsumerComponent.NumberOfFuel.NONE) {
                itemPositions = new SlotPositions.Builder().addSlot(15, 38).build();
                fluidPositions = new SlotPositions.Builder().addSlot(35, 38).build();
            }
        } else {
            fluidStacks = Collections.emptyList();
            fluidPositions = SlotPositions.empty();
            itemPositions = new SlotPositions.Builder().addSlot(25, 38).build();
        }
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
        this.registerComponents(this.energy, this.isActiveComponent, this.inventory, fluidItemConsumer);
    }

    public GeneratorMachineBlockEntity(BEP bep, String name, CableTier outputTier, long energyCapacity, long fluidCapacity, long maxEnergyOutput, FluidDefinition acceptedFluid, long fluidEUperMb) {
        this(bep, name, outputTier, energyCapacity, fluidCapacity, FluidItemConsumerComponent.ofSingleFluid(maxEnergyOutput, acceptedFluid, fluidEUperMb));
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void tick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        long euProduced = this.fluidItemConsumer.getEuProduction(this.inventory.getFluidStacks(), this.inventory.getItemStacks(), this.energy.getRemainingCapacity());
        this.energy.insertEu(euProduced, Simulation.ACT);
        this.isActiveComponent.updateActive(0L != euProduced, this);
        EnergyHelper.autoOutput((MachineBlockEntity)this, this.orientation, this.outputTier, this.extractable);
        this.method_5431();
    }

    @Override
    public EnergyComponent getEnergyComponent() {
        return this.energy;
    }

    public static void registerEnergyApi(class_2591<?> bet) {
        EnergyApi.SIDED.registerForBlockEntities((be, direction) -> {
            GeneratorMachineBlockEntity abe = (GeneratorMachineBlockEntity)be;
            if (abe.orientation.outputDirection == direction) {
                return abe.extractable;
            }
            return null;
        }, new class_2591[]{bet});
    }

    @Override
    public List<class_2561> getTooltips() {
        return this.fluidItemConsumer.getTooltips();
    }
}

