/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.GunpowderOverclockGui;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2561;

public class SteamCraftingMachineBlockEntity
extends AbstractCraftingMachineBlockEntity {
    private final OverclockComponent overclockComponent;

    public SteamCraftingMachineBlockEntity(BEP bep, MachineRecipeType recipeType, MachineInventoryComponent inventory, MachineGuiParameters guiParams, ProgressBar.Parameters progressBarParams, MachineTier tier, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, recipeType, inventory, guiParams, progressBarParams, tier);
        this.overclockComponent = new OverclockComponent(overclockCatalysts);
        GunpowderOverclockGui.Parameters gunpowderOverclockGuiParams = new GunpowderOverclockGui.Parameters(progressBarParams.renderX, progressBarParams.renderY + 20);
        this.registerGuiComponent(new GunpowderOverclockGui.Server(gunpowderOverclockGuiParams, this.overclockComponent::getTicks));
        this.registerComponents(this.overclockComponent);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu(this.getInventory().getFluidStacks(), max, simulation);
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        data.isActive = this.isActiveComponent.isActive;
        return data;
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            return this.overclockComponent.onUse(this, player, hand);
        }
        return result;
    }

    @Override
    public long getMaxRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getMaxEu());
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclockComponent.getRecipeEu(this.tier.getBaseEu());
    }

    @Override
    public void tick() {
        super.tick();
        this.overclockComponent.tick(this);
    }

    @Override
    public List<class_2561> getTooltips() {
        return this.overclockComponent.getTooltips();
    }
}

