/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.compat.viewer.usage.NeutronInteractionCategory;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.NuclearReactorGui;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.INuclearTileData;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class NuclearReactorGuiClient
implements GuiComponentClient {
    private NuclearReactorGui.Data data;

    public NuclearReactorGuiClient(class_2540 buf) {
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        boolean valid = buf.readBoolean();
        if (valid) {
            int sizeX = buf.readInt();
            int sizeY = buf.readInt();
            Optional[] tilesData = new Optional[sizeX * sizeY];
            for (int i = 0; i < sizeX * sizeY; ++i) {
                tilesData[i] = INuclearTileData.read(buf);
            }
            double euProduction = buf.readDouble();
            double euFuelConsumption = buf.readDouble();
            this.data = new NuclearReactorGui.Data(true, sizeX, sizeY, tilesData, euProduction, euFuelConsumption);
        } else {
            this.data = new NuclearReactorGui.Data(false, 0, 0, null, 0.0, 0.0);
        }
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    @Environment(value=EnvType.CLIENT)
    public class Renderer
    implements ClientComponentRenderer {
        final int centerX = 88;
        final int centerY = 88;
        Mode currentMode = Mode.NUCLEAR_FUEL;
        NeutronType neutronMode = NeutronType.BOTH;
        class_1799 fuelStack = new class_1799((class_1935)class_7923.field_41178.method_10223((class_2960)new MIIdentifier("uranium_fuel_rod")), 1);
        private final class_2960 COLORBAR = new MIIdentifier("textures/gui/colorbar.png");
        class_2561[] modeTooltip = new class_2561[]{MIText.NuclearFuelMode.text(), MIText.TemperatureMode.text(), MIText.NeutronAbsorptionMode.text(), MIText.NeutronFluxMode.text(), MIText.NeutronGenerationMode.text(), MIText.EuGenerationMode.text()};
        class_2561[] neutronModeTooltip = new class_2561[]{MIText.FastNeutron.text(), MIText.ThermalNeutron.text(), MIText.Both.text()};

        @Override
        public void renderBackground(class_332 guiGraphics, int x, int y) {
            if (NuclearReactorGuiClient.this.data.valid()) {
                for (int i = 0; i < NuclearReactorGuiClient.this.data.gridSizeX(); ++i) {
                    for (int j = 0; j < NuclearReactorGuiClient.this.data.gridSizeY(); ++j) {
                        class_1792 class_17922;
                        ItemVariant itemVariant;
                        int index = NuclearReactorGuiClient.this.data.toIndex(i, j);
                        Optional<INuclearTileData> tile = NuclearReactorGuiClient.this.data.tilesData()[index];
                        if (!tile.isPresent()) continue;
                        INuclearTileData tileData = tile.get();
                        int px = x + 88 - NuclearReactorGuiClient.this.data.gridSizeX() * 9 + i * 18;
                        int py = y + 88 - NuclearReactorGuiClient.this.data.gridSizeY() * 9 + j * 18;
                        if (tileData.isFluid()) {
                            guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, px, py, 18, 0, 18, 18);
                        } else {
                            guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, px, py, 0, 0, 18, 18);
                        }
                        TransferVariant variant = tile.get().getVariant();
                        long variantAmount = tile.get().getVariantAmount();
                        if (variantAmount > 0L & !variant.isBlank()) {
                            if (variant instanceof ItemVariant) {
                                itemVariant = (ItemVariant)variant;
                                class_1799 stack = itemVariant.toStack((int)variantAmount);
                                RenderHelper.renderAndDecorateItem(guiGraphics, class_310.method_1551().field_1772, stack, px + 1, py + 1);
                            } else if (variant instanceof FluidVariant) {
                                FluidVariant fluidVariant = (FluidVariant)variant;
                                RenderSystem.disableBlend();
                                RenderHelper.drawFluidInGui(guiGraphics, fluidVariant, px + 1, py + 1);
                            }
                        }
                        if (this.currentMode != Mode.NUCLEAR_FUEL) {
                            int u;
                            int v;
                            if (this.currentMode == Mode.TEMPERATURE) {
                                v = 30;
                                u = (int)(299.0 * tileData.getTemperature() / 3250.0);
                            } else if (this.currentMode == Mode.EU_GENERATION) {
                                v = 30;
                                u = (int)(299.0 * Math.min(1.0, tileData.getMeanEuGeneration() / 16384.0));
                            } else {
                                double neutronRate;
                                double factor;
                                double d = factor = this.neutronMode == NeutronType.BOTH ? 2.0 : 1.0;
                                if (this.currentMode == Mode.NEUTRON_ABSORPTION) {
                                    neutronRate = 5.0 * tileData.getMeanNeutronAbsorption(this.neutronMode);
                                } else if (this.currentMode == Mode.NEUTRON_FLUX) {
                                    neutronRate = tileData.getMeanNeutronFlux(this.neutronMode);
                                } else if (this.currentMode == Mode.NEUTRON_GENERATION) {
                                    if (this.neutronMode == NeutronType.THERMAL) {
                                        neutronRate = 0.0;
                                    } else {
                                        neutronRate = tileData.getMeanNeutronGeneration();
                                        factor = 1.0;
                                    }
                                } else {
                                    neutronRate = 0.0;
                                }
                                v = 0;
                                u = (int)(299.0 * NuclearReactorGui.neutronColorScheme(factor * neutronRate));
                            }
                            RenderSystem.disableDepthTest();
                            RenderSystem.enableBlend();
                            guiGraphics.method_51448().method_46416((float)px, (float)py, 0.0f);
                            guiGraphics.method_51448().method_22905(18.0f, 18.0f, 1.0f);
                            guiGraphics.method_25290(this.COLORBAR, 0, 0, (float)u, (float)v, 1, 1, 300, 60);
                            guiGraphics.method_51448().method_22905(0.055555556f, 0.055555556f, 1.0f);
                            guiGraphics.method_51448().method_46416((float)(-px), (float)(-py), 0.0f);
                        }
                        if (this.currentMode != Mode.TEMPERATURE || variant.isBlank() || !(variant instanceof ItemVariant) || !((class_17922 = (itemVariant = (ItemVariant)variant).getItem()) instanceof NuclearComponentItem)) continue;
                        NuclearComponentItem item = (NuclearComponentItem)class_17922;
                        if (!(tileData.getTemperature() + 100.0 > (double)item.getMaxTemperature())) continue;
                        RenderSystem.enableBlend();
                        RenderSystem.disableDepthTest();
                        if (System.currentTimeMillis() % 1000L <= 500L) continue;
                        guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, px + 1, py + 1, 22, 58, 16, 16);
                    }
                }
                if (NuclearReactorGuiClient.this.data.euFuelConsumption() > 0.0 && this.currentMode == Mode.EU_GENERATION) {
                    class_327 font = class_310.method_1551().field_1772;
                    guiGraphics.method_51448().method_46416(0.0f, 0.0f, 256.0f);
                    guiGraphics.method_51439(font, this.getEfficiencyText(), x + 8, y + 16, 0xFFFFFF, false);
                    guiGraphics.method_51448().method_46416(0.0f, 0.0f, -256.0f);
                }
            } else {
                class_327 font = class_310.method_1551().field_1772;
                class_5250 text = MIText.MultiblockShapeInvalid.text().method_10862(TextHelper.RED.method_10982(Boolean.valueOf(true)));
                int width = font.method_27525((class_5348)text);
                guiGraphics.method_51439(font, (class_2561)text, x + 88 - width / 2, y + 88, 0xFFFFFF, false);
            }
        }

        @Override
        public void renderTooltip(MachineScreen screen, class_327 font, class_332 guiGraphics, int x, int y, int cursorX, int cursorY) {
            int i = (cursorX - (x + 88 - NuclearReactorGuiClient.this.data.gridSizeX() * 9)) / 18;
            int j = (cursorY - (y + 88 - NuclearReactorGuiClient.this.data.gridSizeY() * 9)) / 18;
            if (NuclearReactorGuiClient.this.data.valid() && i >= 0 && j >= 0 && i < NuclearReactorGuiClient.this.data.gridSizeX() && j < NuclearReactorGuiClient.this.data.gridSizeY()) {
                int index = NuclearReactorGuiClient.this.data.toIndex(i, j);
                Optional<INuclearTileData> tile = NuclearReactorGuiClient.this.data.tilesData()[index];
                if (tile.isPresent()) {
                    INuclearTileData tileData = tile.get();
                    TransferVariant variant = tileData.getVariant();
                    if (this.currentMode == Mode.NUCLEAR_FUEL) {
                        long variantAmount = tile.get().getVariantAmount();
                        if (variantAmount > 0L & !variant.isBlank()) {
                            if (variant instanceof ItemVariant) {
                                ItemVariant itemVariant = (ItemVariant)variant;
                                guiGraphics.method_51446(font, itemVariant.toStack((int)variantAmount), cursorX, cursorY);
                            } else if (variant instanceof FluidVariant) {
                                FluidVariant fluidVariant = (FluidVariant)variant;
                                guiGraphics.method_51437(font, FluidHelper.getTooltipForFluidStorage(fluidVariant, variantAmount, 5184000L, false), Optional.empty(), cursorX, cursorY);
                            }
                        }
                    } else {
                        INuclearComponent<?> component;
                        double neutronRateThermal;
                        double neutronRateFast;
                        if (this.currentMode == Mode.TEMPERATURE) {
                            ItemVariant itemVariant;
                            class_1792 class_17922;
                            int temperature = (int)tileData.getTemperature();
                            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                            tooltip.add(MIText.Temperature.text(temperature));
                            if (!variant.isBlank() && variant instanceof ItemVariant && (class_17922 = (itemVariant = (ItemVariant)variant).getItem()) instanceof NuclearComponentItem) {
                                NuclearComponentItem item = (NuclearComponentItem)class_17922;
                                tooltip.add(MIText.MaxTemp.text(item.getMaxTemperature()).method_10862(TextHelper.YELLOW));
                            }
                            guiGraphics.method_51437(font, tooltip, Optional.empty(), cursorX, cursorY);
                            return;
                        }
                        if (this.currentMode == Mode.EU_GENERATION) {
                            double euGeneration = tileData.getMeanEuGeneration();
                            guiGraphics.method_51438(font, TextHelper.getEuTextTick(euGeneration, true), cursorX, cursorY);
                            return;
                        }
                        if (this.currentMode == Mode.NEUTRON_ABSORPTION) {
                            neutronRateFast = tileData.getMeanNeutronAbsorption(NeutronType.FAST);
                            neutronRateThermal = tileData.getMeanNeutronAbsorption(NeutronType.THERMAL);
                        } else if (this.currentMode == Mode.NEUTRON_FLUX) {
                            neutronRateFast = tileData.getMeanNeutronFlux(NeutronType.FAST);
                            neutronRateThermal = tileData.getMeanNeutronFlux(NeutronType.THERMAL);
                        } else if (this.currentMode == Mode.NEUTRON_GENERATION) {
                            neutronRateFast = tileData.getMeanNeutronGeneration();
                            neutronRateThermal = 0.0;
                        } else {
                            neutronRateFast = 0.0;
                            neutronRateThermal = 0.0;
                        }
                        double neutronRate = 0.0;
                        if (this.neutronMode == NeutronType.BOTH) {
                            neutronRate = neutronRateFast + neutronRateThermal;
                        } else if (this.neutronMode == NeutronType.FAST) {
                            neutronRate = neutronRateFast;
                        } else if (this.neutronMode == NeutronType.THERMAL) {
                            neutronRate = neutronRateThermal;
                        }
                        String neutronRateString = String.format("%.1f", neutronRate);
                        ArrayList<class_5250> tooltips = new ArrayList<class_5250>();
                        tooltips.add(MIText.NeutronsRate.text(neutronRateString));
                        if (this.neutronMode == NeutronType.BOTH && neutronRate > 0.0 && this.currentMode != Mode.NEUTRON_GENERATION) {
                            String neutronRateFastString = String.format("%.1f", neutronRateFast);
                            String neutronRateThermalString = String.format("%.1f", neutronRateThermal);
                            String neutronRateFastFractionString = String.format(" (%.1f %%)", 100.0 * neutronRateFast / neutronRate);
                            String neutronRateThermalFractionString = String.format(" (%.1f %%)", 100.0 * neutronRateThermal / neutronRate);
                            if (neutronRateFast > 0.0) {
                                tooltips.add(class_2561.method_43470((String)(MIText.FastNeutron.text().getString() + " : " + MIText.NeutronsRate.text(neutronRateFastString).getString() + neutronRateFastFractionString)).method_10862(TextHelper.GRAY_TEXT));
                            }
                            if (neutronRateThermal > 0.0) {
                                tooltips.add(class_2561.method_43470((String)(MIText.ThermalNeutron.text().getString() + " : " + MIText.NeutronsRate.text(neutronRateThermalString).getString() + neutronRateThermalFractionString)).method_10862(TextHelper.GRAY_TEXT));
                            }
                        }
                        if (this.currentMode == Mode.NEUTRON_GENERATION && (component = tileData.getComponent()) instanceof NuclearFuel) {
                            NuclearFuel fuel = (NuclearFuel)component;
                            double efficiencyFactor = fuel.efficiencyFactor(tileData.getTemperature());
                            tooltips.add(MIText.ThermalEfficiency.text(String.format("%.1f", efficiencyFactor * 100.0)).method_10862(TextHelper.YELLOW));
                        }
                        guiGraphics.method_51437(font, tooltips, Optional.empty(), cursorX, cursorY);
                        return;
                    }
                }
            }
            if (NuclearReactorGuiClient.this.data.euFuelConsumption() > 0.0 && this.currentMode == Mode.EU_GENERATION) {
                class_327 renderer = class_310.method_1551().field_1772;
                int width = renderer.method_1727(this.getEfficiencyText().getString());
                if (cursorX > x + 8 && cursorX < x + 8 + width && cursorY >= y + 15 && cursorY < y + 24) {
                    class_2561 euProduction = TextHelper.getEuTextTick(NuclearReactorGuiClient.this.data.euProduction(), true);
                    class_2561 euFuelConsumption = TextHelper.getEuTextTick(NuclearReactorGuiClient.this.data.euFuelConsumption(), true);
                    class_5250 tooltip = MIText.NuclearFuelEfficiencyTooltip.text(euProduction, euFuelConsumption);
                    guiGraphics.method_51438(font, (class_2561)tooltip, cursorX, cursorY);
                }
            }
        }

        public class_2561 getEfficiencyText() {
            String eff = String.format("%.1f", 100.0 * NuclearReactorGuiClient.this.data.euProduction() / NuclearReactorGuiClient.this.data.euFuelConsumption());
            return MIText.EfficiencyNuclear.text(eff).method_10862(TextHelper.RED);
        }

        private boolean drawButton() {
            return NuclearReactorGuiClient.this.data.valid();
        }

        private boolean drawNeutronButton() {
            return NuclearReactorGuiClient.this.data.valid() && (this.currentMode == Mode.NEUTRON_FLUX || this.currentMode == Mode.NEUTRON_ABSORPTION);
        }

        private NeutronType nextNeutronMode() {
            return NeutronType.TYPES[(this.neutronMode.index + 1) % NeutronType.TYPES.length];
        }

        private NeutronType previousNeutronMode() {
            return NeutronType.TYPES[(this.neutronMode.index - 1 + NeutronType.TYPES.length) % NeutronType.TYPES.length];
        }

        private Mode nextMode() {
            return Mode.values()[(this.currentMode.index + 1) % Mode.values().length];
        }

        private Mode previousMode() {
            return Mode.values()[(this.currentMode.index - 1 + Mode.values().length) % Mode.values().length];
        }

        private Mode circulateMode() {
            if (CommonProxy.INSTANCE.hasShiftDown()) {
                return this.previousMode();
            }
            return this.nextMode();
        }

        private NeutronType circulateNeutronMode() {
            if (CommonProxy.INSTANCE.hasShiftDown()) {
                return this.previousNeutronMode();
            }
            return this.nextNeutronMode();
        }

        @Override
        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            container.addButton(152, 4, 20, 20, i -> {
                this.currentMode = this.circulateMode();
            }, () -> List.of(this.modeTooltip[this.currentMode.index], MIText.ClickToSwitch.text(this.modeTooltip[this.nextMode().index]).method_10862(TextHelper.GRAY_TEXT), MIText.ShiftClickToSwitch.text(this.modeTooltip[this.previousMode().index]).method_10862(TextHelper.GRAY_TEXT)), (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                button.renderVanilla(guiGraphics, mouseX, mouseY, delta);
                if (this.currentMode == Mode.NUCLEAR_FUEL) {
                    RenderHelper.renderAndDecorateItem(guiGraphics, this.fuelStack, button.method_46426() + 1, button.method_46427() + 1);
                } else if (this.currentMode == Mode.EU_GENERATION) {
                    guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, button.method_46426() + 4, button.method_46427() + 2, 243, 1, 13, 17);
                } else {
                    guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, button.method_46426(), button.method_46427(), 124 + this.currentMode.index * 20, 0, 20, 20);
                }
            }, this::drawButton);
            container.addButton(152, 150, 20, 20, i -> {
                this.neutronMode = this.circulateNeutronMode();
            }, () -> List.of(this.neutronModeTooltip[this.neutronMode.index], MIText.ClickToSwitch.text(this.neutronModeTooltip[this.nextNeutronMode().index]).method_10862(TextHelper.GRAY_TEXT), MIText.ShiftClickToSwitch.text(this.neutronModeTooltip[this.previousNeutronMode().index]).method_10862(TextHelper.GRAY_TEXT)), (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                button.renderVanilla(guiGraphics, mouseX, mouseY, delta);
                if (this.neutronMode == NeutronType.FAST) {
                    guiGraphics.method_25302(NeutronInteractionCategory.TEXTURE_ATLAS, button.method_46426() + 2, button.method_46427() + 2, 0, 240, 16, 16);
                } else if (this.neutronMode == NeutronType.THERMAL) {
                    guiGraphics.method_25302(NeutronInteractionCategory.TEXTURE_ATLAS, button.method_46426() + 2, button.method_46427() + 2, 160, 240, 16, 16);
                } else if (this.neutronMode == NeutronType.BOTH) {
                    guiGraphics.method_25302(NeutronInteractionCategory.TEXTURE_ATLAS, button.method_46426() + 2, button.method_46427() + 2, 80, 240, 16, 16);
                }
            }, this::drawNeutronButton);
        }

        @Environment(value=EnvType.CLIENT)
        private static enum Mode {
            NUCLEAR_FUEL(0),
            TEMPERATURE(1),
            NEUTRON_ABSORPTION(2),
            NEUTRON_FLUX(3),
            NEUTRON_GENERATION(4),
            EU_GENERATION(5);

            final int index;

            private Mode(int index) {
                this.index = index;
            }
        }
    }
}

