/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.datagen.model.MachineModelsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.util.MobSpawning;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4941;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class MachineRegistrationHelper {
    @SafeVarargs
    public static class_2591<?> registerMachine(String englishName, String id, Function<BEP, MachineBlockEntity> factory, Consumer<class_2591<?>> ... extraRegistrators) {
        class_2591[] bet = new class_2591[1];
        BiFunction<class_2338, class_2680, MachineBlockEntity> ctor = (pos, state) -> (MachineBlockEntity)factory.apply(new BEP((class_2591<?>)bet[0], (class_2338)pos, (class_2680)state));
        BlockDefinition<MachineBlock> blockDefinition = MIBlock.block(englishName, id, MIBlock.BlockDefinitionParams.defaultStone().sortOrder(SortOrder.MACHINES).withBlockConstructor(s -> new MachineBlock(ctor, (class_4970.class_2251)s)).withModel((block, gen) -> {
            gen.method_25540(block);
            gen.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)class_4941.method_25840((class_1792)block.method_8389())));
        }).method_26235(MobSpawning.NO_SPAWN), MachineBlock.class);
        MachineBlock block2 = blockDefinition.asBlock();
        bet[0] = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new MIIdentifier(id), (Object)FabricBlockEntityTypeBuilder.create(ctor::apply, (class_2248[])new class_2248[]{block2}).build(null));
        for (Consumer<class_2591<?>> extraRegistrator : extraRegistrators) {
            extraRegistrator.accept(bet[0]);
        }
        return bet[0];
    }

    public static void addMachineModel(String tier, String id, String machineType, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        MachineCasing defaultCasing;
        if (tier.equals("bronze")) {
            defaultCasing = MachineCasings.BRONZE;
        } else if (tier.equals("steel")) {
            defaultCasing = MachineCasings.STEEL;
        } else if (tier.equals("electric")) {
            defaultCasing = MachineCasings.LV;
        } else {
            throw new RuntimeException("Invalid tier: " + tier);
        }
        MachineRegistrationHelper.addMachineModel(id, machineType, defaultCasing, frontOverlay, topOverlay, sideOverlay);
    }

    public static void addMachineModel(String id, String overlayFolder, MachineCasing defaultCasing, boolean frontOverlay, boolean topOverlay, boolean sideOverlay) {
        MachineRegistrationHelper.addMachineModel(id, overlayFolder, defaultCasing, frontOverlay, topOverlay, sideOverlay, true);
    }

    public static void addMachineModel(String id, String overlayFolder, MachineCasing defaultCasing, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, boolean hasActive) {
        MachineBlock.REGISTERED_MACHINES.put(id, defaultCasing);
        MachineModelsToGenerate.register(id, overlayFolder, frontOverlay, topOverlay, sideOverlay, hasActive);
    }

    public static void addModelsForTiers(String name, boolean frontOverlay, boolean topOverlay, boolean sideOverlay, String ... tiers) {
        for (String tier : tiers) {
            MachineRegistrationHelper.addMachineModel(tier, tier + "_" + name, name, frontOverlay, topOverlay, sideOverlay);
        }
    }
}

