/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.models;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasingModel;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineUnbakedModel;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5616;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class MachineRendering {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        for (MachineCasing machineCasing : MachineCasings.registeredCasings.values()) {
            machineCasing.model = new MachineCasingModel(machineCasing.name);
        }
        for (BlockDefinition blockDefinition : MIBlock.BLOCKS.values()) {
            Object t = blockDefinition.asBlock();
            if (!(t instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)t;
            MachineRendering.registerBer(machine);
        }
        PreparableModelLoadingPlugin.register(MachineRendering::prepareUnbakedModels, (modelsToResolve, pluginCtx) -> {
            for (MachineCasing casing : MachineCasings.registeredCasings.values()) {
                MachineCasingModel casingModel = (MachineCasingModel)casing.model;
                pluginCtx.addModels(new class_2960[]{casingModel.id});
            }
            pluginCtx.resolveModel().register(ctx -> {
                if (!ctx.id().method_12836().equals("modern_industrialization")) {
                    return null;
                }
                return (class_1100)modelsToResolve.get(ctx.id());
            });
        });
    }

    private static void registerBer(MachineBlock machine) {
        MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
        class_2591 type = blockEntity.method_11017();
        if (blockEntity instanceof LargeTankMultiblockBlockEntity) {
            class_5616.method_32144((class_2591)type, MultiblockTankBER::new);
        } else if (blockEntity instanceof MultiblockMachineBlockEntity) {
            class_5616.method_32144((class_2591)type, MultiblockMachineBER::new);
        } else {
            class_5616.method_32144((class_2591)type, c -> new MachineBlockEntityRenderer(c));
        }
    }

    private static CompletableFuture<Map<class_2960, class_1100>> prepareUnbakedModels(class_3300 resourceManager, Executor executor) {
        return ((CompletableFuture)CompletableFuture.completedFuture(MachineBlock.REGISTERED_MACHINES).thenComposeAsync(machinesToLoad -> {
            ArrayList<CompletableFuture<Pair>> futures = new ArrayList<CompletableFuture<Pair>>();
            for (Map.Entry entry : machinesToLoad.entrySet()) {
                futures.add(CompletableFuture.supplyAsync(() -> {
                    block10: {
                        Pair pair;
                        block9: {
                            String machine = (String)entry.getKey();
                            MachineCasing casing = (MachineCasing)entry.getValue();
                            BufferedReader resource = ((class_3298)resourceManager.method_14486((class_2960)new MIIdentifier("models/machine/" + machine + ".json")).get()).method_43039();
                            try {
                                pair = Pair.of((Object)((Object)new MIIdentifier("item/" + machine)), (Object)MachineUnbakedModel.deserialize(casing, resource));
                                if (resource == null) break block9;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (resource != null) {
                                        try {
                                            resource.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (IOException exception) {
                                    LOGGER.error("Failed to find machine model json for machine " + machine, (Throwable)exception);
                                    break block10;
                                }
                                catch (RuntimeException exception) {
                                    LOGGER.error("Failed to load machine model json for machine " + machine, (Throwable)exception);
                                }
                            }
                            resource.close();
                        }
                        return pair;
                    }
                    return null;
                }, executor));
            }
            return class_156.method_33791(futures).thenApply(list -> list.stream().filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }, executor)).thenApply(machineModels -> {
            HashMap<class_2960, MachineCasingModel> unbakedModels = new HashMap<class_2960, MachineCasingModel>((Map<class_2960, MachineCasingModel>)machineModels);
            for (MachineCasing casing : MachineCasings.registeredCasings.values()) {
                MachineCasingModel casingModel = (MachineCasingModel)casing.model;
                unbakedModels.put(casingModel.id, casingModel);
            }
            return unbakedModels;
        });
    }

    private MachineRendering() {
    }
}

