/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public class FluidNuclearComponents {
    private static final INuclearComponent<FluidVariant> WATER = FluidNuclearComponents.create((class_3611)class_3612.field_15910, 0.05, 1.0, NuclearConstant.ScatteringType.ULTRA_LIGHT, NuclearConstant.HYDROGEN, MIFluids.DEUTERIUM.variant(), false);
    private static final INuclearComponent<FluidVariant> HEAVY_WATER = FluidNuclearComponents.create(MIFluids.HEAVY_WATER.asFluid(), 0.06, 1.0, NuclearConstant.ScatteringType.LIGHT, NuclearConstant.DEUTERIUM, MIFluids.TRITIUM.variant(), false);
    private static final INuclearComponent<FluidVariant> HIGH_PRESSURE_WATER = FluidNuclearComponents.create(MIFluids.HIGH_PRESSURE_WATER.asFluid(), 0.05, 4.0, NuclearConstant.ScatteringType.ULTRA_LIGHT, NuclearConstant.HYDROGEN, MIFluids.DEUTERIUM.variant(), true);
    private static final INuclearComponent<FluidVariant> HIGH_PRESSURE_HEAVY_WATER = FluidNuclearComponents.create(MIFluids.HIGH_PRESSURE_HEAVY_WATER.asFluid(), 0.06, 4.0, NuclearConstant.ScatteringType.LIGHT, NuclearConstant.DEUTERIUM, MIFluids.TRITIUM.variant(), true);

    @Nullable
    public static INuclearComponent<FluidVariant> of(FluidVariant variant) {
        class_3611 fluid = variant.getFluid();
        if (fluid == class_3612.field_15910) {
            return WATER;
        }
        if (fluid == MIFluids.HEAVY_WATER.asFluid()) {
            return HEAVY_WATER;
        }
        if (fluid == MIFluids.HIGH_PRESSURE_WATER.asFluid()) {
            return HIGH_PRESSURE_WATER;
        }
        if (fluid == MIFluids.HIGH_PRESSURE_HEAVY_WATER.asFluid()) {
            return HIGH_PRESSURE_HEAVY_WATER;
        }
        return null;
    }

    private static INuclearComponent<FluidVariant> create(class_3611 fluid, final double heatConduction, final double density, final NuclearConstant.ScatteringType type, final NuclearConstant.IsotopeParams params, final FluidVariant neutronProduct, final boolean highPressure) {
        final FluidVariant variant = FluidVariant.of((class_3611)fluid);
        return new INuclearComponent<FluidVariant>(){

            @Override
            public double getHeatConduction() {
                return heatConduction * density;
            }

            @Override
            public INeutronBehaviour getNeutronBehaviour() {
                return INeutronBehaviour.of(type, params, density);
            }

            @Override
            public FluidVariant getVariant() {
                return variant;
            }

            @Override
            public FluidVariant getNeutronProduct() {
                return neutronProduct;
            }

            @Override
            public long getNeutronProductAmount() {
                return highPressure ? 8L : 1L;
            }

            @Override
            public double getNeutronProductProbability() {
                return highPressure ? 0.125 : 1.0;
            }
        };
    }
}

