/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.pipes.PipeStatsCollector;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3218;

public class FluidNetwork
extends PipeNetwork {
    final int nodeCapacity;
    final PipeStatsCollector stats = new PipeStatsCollector();

    public FluidNetwork(int id, PipeNetworkData data, int nodeCapacity) {
        super(id, data == null ? new FluidNetworkData(FluidVariant.blank()) : data);
        this.nodeCapacity = nodeCapacity;
    }

    @Override
    public void tick(class_3218 world) {
        ArrayList<FluidTarget> targets = new ArrayList<FluidTarget>();
        long networkAmount = 0L;
        int loadedNodeCount = 0;
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            FluidNetworkNode fluidNode = (FluidNetworkNode)entry.getNode();
            fluidNode.gatherTargetsAndPickFluid(world, entry.getPos(), targets);
            networkAmount += fluidNode.amount;
            ++loadedNodeCount;
        }
        long networkCapacity = (long)loadedNodeCount * (long)this.nodeCapacity;
        FluidVariant fluid = ((FluidNetworkData)this.data).fluid;
        long extracted = 0L;
        long inserted = 0L;
        if (!fluid.isBlank()) {
            try (Transaction transaction = Transaction.openOuter();){
                extracted = FluidNetwork.transferByPriority(Storage::extract, targets, fluid, networkCapacity - networkAmount, (TransactionContext)transaction);
                inserted = FluidNetwork.transferByPriority(Storage::insert, targets, fluid, networkAmount += extracted, (TransactionContext)transaction);
                networkAmount -= inserted;
                transaction.commit();
            }
            for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
                FluidNetworkNode fluidNode = (FluidNetworkNode)entry.getNode();
                fluidNode.amount = networkAmount / (long)loadedNodeCount;
                networkAmount -= fluidNode.amount;
                --loadedNodeCount;
            }
        }
        this.stats.addValue(Math.max(extracted, inserted));
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ((FluidNetworkNode)entry.getNode()).afterTick(world, entry.getPos());
        }
    }

    private static long transferByPriority(TransferOperation operation, List<FluidTarget> targets, FluidVariant fluid, long maxAmount, TransactionContext transaction) {
        targets.sort(Comparator.comparingInt(target -> -target.priority));
        long transferredAmount = 0L;
        int bucketStart = 0;
        for (int i = 0; i < targets.size(); ++i) {
            if (i != targets.size() - 1 && targets.get((int)bucketStart).priority == targets.get((int)(i + 1)).priority) continue;
            transferredAmount += FluidNetwork.transferForBucket(operation, targets.subList(bucketStart, i + 1), fluid, maxAmount - transferredAmount, transaction);
            bucketStart = i + 1;
        }
        return transferredAmount;
    }

    private static long transferForBucket(TransferOperation operation, List<FluidTarget> bucket, FluidVariant fluid, long maxAmount, TransactionContext transaction) {
        Collections.shuffle(bucket);
        for (FluidTarget target2 : bucket) {
            Transaction nested = transaction.openNested();
            try {
                target2.simulationResult = operation.transfer(target2.storage, fluid, maxAmount, (TransactionContext)nested);
            }
            finally {
                if (nested == null) continue;
                nested.close();
            }
        }
        bucket.sort(Comparator.comparingLong(target -> target.simulationResult));
        long transferredAmount = 0L;
        for (int i = 0; i < bucket.size(); ++i) {
            FluidTarget target3 = bucket.get(i);
            int remainingTargets = bucket.size() - i;
            long remainingAmount = maxAmount - transferredAmount;
            long targetMaxAmount = remainingAmount / (long)remainingTargets;
            transferredAmount += operation.transfer(target3.storage, fluid, targetMaxAmount, transaction);
        }
        return transferredAmount;
    }

    @Override
    public PipeNetworkData merge(PipeNetwork other) {
        FluidNetworkData thisData = (FluidNetworkData)this.data;
        FluidNetworkData otherData = (FluidNetworkData)other.data;
        for (int i = 0; i < 2; ++i) {
            boolean onlyFluid;
            boolean bl = onlyFluid = i == 0;
            if (this.isEmpty(onlyFluid)) {
                return otherData.clone();
            }
            if (!((FluidNetwork)other).isEmpty(onlyFluid)) continue;
            return thisData.clone();
        }
        return null;
    }

    private boolean isEmpty(boolean onlyFluid) {
        if (((FluidNetworkData)this.data).fluid.isBlank()) {
            return true;
        }
        if (onlyFluid) {
            return false;
        }
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            if (node != null && ((FluidNetworkNode)node).amount == 0L) continue;
            return false;
        }
        return true;
    }

    protected void setFluid(FluidVariant fluid) {
        if (((FluidNetworkData)this.data).fluid.isBlank()) {
            ((FluidNetworkData)this.data).fluid = fluid;
        }
    }

    protected void clearFluid() {
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            if (node != null) continue;
            return;
        }
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            ((FluidNetworkNode)node).amount = 0L;
        }
        ((FluidNetworkData)this.data).fluid = FluidVariant.blank();
    }

    @FunctionalInterface
    private static interface TransferOperation {
        public long transfer(Storage<FluidVariant> var1, FluidVariant var2, long var3, TransactionContext var5);
    }
}

