/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.impl.PipeMeshBuilder;
import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PipeMeshCache
implements PipeRenderer {
    private final ConcurrentMap<ConnectionMeshKey, Mesh> connectionMeshes = new ConcurrentHashMap<ConnectionMeshKey, Mesh>(128, 0.5f);
    private final Function<ConnectionMeshKey, Mesh> connectionMeshBuilder;
    private final ConcurrentMap<CenterMeshKey, Mesh> centerMeshes = new ConcurrentHashMap<CenterMeshKey, Mesh>(128, 0.5f);
    private final Function<CenterMeshKey, Mesh> centerMeshBuilder;
    private final RenderMaterial fluidMaterial;

    public PipeMeshCache(Function<class_4730, class_1058> textureGetter, class_4730[] spriteIds, boolean innerQuads) {
        Renderer renderer = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer());
        this.connectionMeshBuilder = key -> {
            int i = key.endpointType;
            int logicalSlot = key.logicalSlot;
            class_2350 direction = class_2350.method_10143((int)key.directionId);
            int j = key.renderType;
            class_1058 sprite = (class_1058)textureGetter.apply(spriteIds[i]);
            MeshBuilder meshBuilder = renderer.meshBuilder();
            PipeMeshBuilder pmb = innerQuads ? new PipeMeshBuilder.InnerQuads(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite) : new PipeMeshBuilder(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite);
            boolean reduced = j >= 4;
            boolean end = i != 0;
            int renderType = j % 4;
            if (renderType == 0) {
                pmb.straightLine(reduced, end);
            } else if (renderType == 1) {
                pmb.shortBend(reduced, end);
            } else if (renderType == 2) {
                pmb.farShortBend(reduced, end);
            } else {
                pmb.longBend(reduced, end);
            }
            return meshBuilder.build();
        };
        class_1058 sprite = textureGetter.apply(spriteIds[0]);
        this.centerMeshBuilder = key -> {
            int logicalSlot = key.logicalSlot;
            int mask = key.bitmask;
            MeshBuilder meshBuilder = renderer.meshBuilder();
            for (class_2350 direction : class_2350.values()) {
                PipeMeshBuilder pmb = innerQuads ? new PipeMeshBuilder.InnerQuads(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite) : new PipeMeshBuilder(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite);
                pmb.noConnection(mask);
            }
            return meshBuilder.build();
        };
        this.fluidMaterial = renderer.materialFinder().blendMode(BlendMode.SOLID).emissive(true).ambientOcclusion(TriState.FALSE).find();
    }

    @Override
    public void draw(@Nullable class_1920 view, @Nullable class_2338 pos, RenderContext ctx, int logicalSlot, PipeEndpointType[][] connections, class_2487 customData) {
        int[] renderTypes = new int[6];
        class_2350[] initialDirections = new class_2350[6];
        int[] connectionsInDirection = new int[6];
        int directionsMask = 0;
        for (class_2350 direction : class_2350.values()) {
            int i = direction.method_10146();
            renderTypes[i] = PipePartBuilder.getRenderType(logicalSlot, direction, connections);
            if (renderTypes[i] == 0) continue;
            initialDirections[i] = PipePartBuilder.getInitialDirection(logicalSlot, direction, renderTypes[i]);
            int n = initialDirections[i].method_10146();
            connectionsInDirection[n] = connectionsInDirection[n] + 1;
            directionsMask |= 1 << initialDirections[i].method_10146();
        }
        if (customData.method_10545("fluid")) {
            FluidVariant fluid = NbtHelper.getFluidCompatible(customData, "fluid");
            class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluid);
            int color = FluidVariantRendering.getColor((FluidVariant)fluid, (class_1920)view, (class_2338)pos);
            ctx.pushTransform(quad -> {
                if (quad.tag() == 1) {
                    if (still != null) {
                        quad.spriteBake(still, 4);
                        quad.color(color, color, color, color);
                        quad.material(this.fluidMaterial);
                        return true;
                    }
                    return false;
                }
                return true;
            });
        }
        for (int i = 0; i < 6; ++i) {
            PipeEndpointType endpointType = connections[logicalSlot][i];
            if (endpointType == null) continue;
            int renderType = renderTypes[i] - 1;
            if (connectionsInDirection[initialDirections[i].method_10146()] > 1) {
                renderType += 4;
            }
            Mesh mesh = this.connectionMeshes.computeIfAbsent(new ConnectionMeshKey(endpointType.getId(), logicalSlot, i, renderType), this.connectionMeshBuilder);
            mesh.outputTo(ctx.getEmitter());
        }
        this.centerMeshes.computeIfAbsent(new CenterMeshKey(logicalSlot, directionsMask), this.centerMeshBuilder).outputTo(ctx.getEmitter());
        if (customData.method_10545("fluid")) {
            ctx.popTransform();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record ConnectionMeshKey(int endpointType, int logicalSlot, int directionId, int renderType) {
    }

    @Environment(value=EnvType.CLIENT)
    private record CenterMeshKey(int logicalSlot, int bitmask) {
    }
}

