/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.pipe.item.SpeedUpgrade;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.pipes.item.ItemNetwork;
import aztech.modern_industrialization.pipes.item.ItemPipeInterface;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class ItemNetworkNode
extends PipeNetworkNode {
    final List<ItemConnection> connections = new ArrayList<ItemConnection>();
    int inactiveTicks = 0;

    @Override
    public void updateConnections(class_1937 world, class_2338 pos) {
        PipeNetworks levelNetworks = PipeNetworks.get((class_3218)world);
        this.connections.removeIf(connection -> {
            for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
                PipeNetworkManager manager = levelNetworks.getOptionalManager(type);
                if (manager == null || !manager.hasLink(pos, connection.direction)) continue;
                connection.dropUpgrades(world, pos);
                return true;
            }
            return false;
        });
    }

    private boolean canConnect(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 adjPos = pos.method_10093(direction);
        return ItemStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153()) != null;
    }

    @Override
    public PipeEndpointType[] getConnections(class_2338 pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (class_2350 direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.method_10146()] = PipeEndpointType.PIPE;
        }
        for (ItemConnection connection : this.connections) {
            connections[connection.direction.method_10146()] = connection.type;
        }
        return connections;
    }

    @Override
    public void removeConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ItemConnection conn = this.connections.get(i);
            if (conn.direction != direction) continue;
            if (conn.type == PipeEndpointType.BLOCK_IN) {
                conn.type = PipeEndpointType.BLOCK_IN_OUT;
            } else if (conn.type == PipeEndpointType.BLOCK_IN_OUT) {
                conn.type = PipeEndpointType.BLOCK_OUT;
            } else {
                conn.dropUpgrades(world, pos);
                this.connections.remove(i);
            }
            return;
        }
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, class_1657 player, class_1937 world, class_2338 pos, class_2350 direction) {
        for (ItemConnection connection : this.connections) {
            if (connection.direction != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            ItemConnection conn = new ItemConnection(direction, PipeEndpointType.BLOCK_IN, 0, -10);
            this.connections.add(conn);
            class_1799 offHandItem = player.method_6079();
            if (MIItem.CONFIG_CARD.is(offHandItem)) {
                conn.applyConfig(pipe, offHandItem.method_7941("savedconfig"), player);
            }
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        for (ItemConnection connection : this.connections) {
            class_2487 connectionTag = new class_2487();
            connectionTag.method_10567("connections", (byte)ItemNetworkNode.encodeConnectionType(connection.type));
            connectionTag.method_10556("whitelist", connection.whitelist);
            connectionTag.method_10569("insertPriority", connection.insertPriority);
            connectionTag.method_10569("extractPriority", connection.extractPriority);
            for (int i = 0; i < 21; ++i) {
                connectionTag.method_10566(Integer.toString(i), (class_2520)connection.stacks[i].method_7953(new class_2487()));
            }
            connectionTag.method_10566("upgradeStack", (class_2520)connection.upgradeStack.method_7953(new class_2487()));
            tag.method_10566(connection.direction.toString(), (class_2520)connectionTag);
        }
        tag.method_10569("inactiveTicks", this.inactiveTicks);
        return tag;
    }

    @Override
    public void fromTag(class_2487 tag) {
        for (class_2350 direction : class_2350.values()) {
            if (!tag.method_10545(direction.toString())) continue;
            class_2487 connectionTag = tag.method_10562(direction.toString());
            int insertPriority = connectionTag.method_10550("insertPriority");
            int extractPriority = connectionTag.method_10550("extractPriority");
            ItemConnection connection = new ItemConnection(direction, ItemNetworkNode.decodeConnectionType(connectionTag.method_10571("connections")), insertPriority, extractPriority);
            connection.whitelist = connectionTag.method_10577("whitelist");
            for (int i = 0; i < 21; ++i) {
                connection.stacks[i] = class_1799.method_7915((class_2487)connectionTag.method_10562(Integer.toString(i)));
                if (connection.stacks[i].method_7960()) continue;
                connection.stacks[i].method_7939(1);
            }
            connection.refreshStacksCache();
            connection.upgradeStack = class_1799.method_7915((class_2487)connectionTag.method_10562("upgradeStack"));
            this.connections.add(connection);
        }
        this.inactiveTicks = tag.method_10550("inactiveTicks");
    }

    private static PipeEndpointType decodeConnectionType(int i) {
        return i == 0 ? PipeEndpointType.BLOCK_IN : (i == 1 ? PipeEndpointType.BLOCK_IN_OUT : PipeEndpointType.BLOCK_OUT);
    }

    private static int encodeConnectionType(PipeEndpointType connection) {
        return connection == PipeEndpointType.BLOCK_IN ? 0 : (connection == PipeEndpointType.BLOCK_IN_OUT ? 1 : 2);
    }

    @Override
    public ExtendedScreenHandlerFactory getConnectionGui(class_2350 guiDirection, IPipeScreenHandlerHelper helper) {
        for (ItemConnection connection : this.connections) {
            if (connection.direction != guiDirection) continue;
            ItemConnection itemConnection = connection;
            Objects.requireNonNull(itemConnection);
            return itemConnection.new ItemConnection.ScreenHandlerFactory(helper, this.getType().getIdentifier());
        }
        return null;
    }

    @Override
    public void appendDroppedStacks(List<class_1799> droppedStacks) {
        for (ItemConnection conn : this.connections) {
            if (conn.upgradeStack.method_7960()) continue;
            droppedStacks.add(conn.upgradeStack);
            conn.upgradeStack = class_1799.field_8037;
        }
    }

    @Override
    public boolean customUse(PipeBlockEntity pipe, class_1657 player, class_1268 hand, @Nullable class_2350 hitDirection) {
        for (ItemConnection conn : this.connections) {
            if (conn.direction != hitDirection) continue;
            class_1799 stack = player.method_5998(hand);
            if (!MIItem.CONFIG_CARD.is(stack)) {
                return false;
            }
            if (player.method_5715()) {
                stack.method_7983("camouflage");
                stack.method_7948().method_10566("savedconfig", (class_2520)conn.getConfig());
                player.method_7353((class_2561)MIText.ConfigCardSet.text(), true);
            } else if (stack.method_7941("savedconfig") != null) {
                conn.applyConfig(pipe, stack.method_7941("savedconfig"), player);
                player.method_7353((class_2561)MIText.ConfigCardApplied.text(), true);
            }
            return true;
        }
        return false;
    }

    public InGameInfo collectNetworkInfo() {
        ItemNetwork itemNetwork = (ItemNetwork)this.network;
        return new InGameInfo(itemNetwork.lastMovedItems, itemNetwork.inactiveTicks);
    }

    class ItemConnection {
        final class_2350 direction;
        private PipeEndpointType type;
        boolean whitelist = true;
        int insertPriority;
        int extractPriority;
        private final class_1799[] stacks = new class_1799[21];
        final Set<ItemVariant> stacksCache = new HashSet<ItemVariant>();
        private class_1799 upgradeStack = class_1799.field_8037;
        BlockApiCache<Storage<ItemVariant>, class_2350> cache = null;

        private ItemConnection(class_2350 direction, PipeEndpointType type, int insertPriority, int extractPriority) {
            this.direction = direction;
            this.type = type;
            this.insertPriority = insertPriority;
            this.extractPriority = extractPriority;
            for (int i = 0; i < 21; ++i) {
                this.stacks[i] = class_1799.field_8037;
            }
        }

        private void refreshStacksCache() {
            this.stacksCache.clear();
            for (class_1799 stack : this.stacks) {
                if (stack.method_7960()) continue;
                this.stacksCache.add(ItemVariant.of((class_1799)stack));
            }
        }

        boolean canInsert() {
            return this.type == PipeEndpointType.BLOCK_IN || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        boolean canExtract() {
            return this.type == PipeEndpointType.BLOCK_OUT || this.type == PipeEndpointType.BLOCK_IN_OUT;
        }

        boolean canStackMoveThrough(ItemVariant key) {
            return this.stacksCache.contains(key) == this.whitelist;
        }

        long getMoves() {
            return 16L + SpeedUpgrade.UPGRADES.getOrDefault(this.upgradeStack.method_7909(), 0L) * (long)this.upgradeStack.method_7947();
        }

        private void dropUpgrades(class_1937 world, class_2338 pos) {
            if (!this.upgradeStack.method_7960()) {
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), this.upgradeStack));
                this.upgradeStack = class_1799.field_8037;
            }
        }

        class_2487 getConfig() {
            class_2487 tag = new class_2487();
            tag.method_10569("connectionType", ItemNetworkNode.encodeConnectionType(this.type));
            tag.method_10556("whitelist", this.whitelist);
            tag.method_10569("insertPriority", this.insertPriority);
            tag.method_10569("extractPriority", this.extractPriority);
            class_2499 filterTag = new class_2499();
            for (class_1799 itemStack : this.stacks) {
                filterTag.add((Object)itemStack.method_7953(new class_2487()));
            }
            tag.method_10566("filter", (class_2520)filterTag);
            tag.method_10566("upgrade", (class_2520)this.upgradeStack.method_7953(new class_2487()));
            return tag;
        }

        void applyConfig(PipeBlockEntity pipe, @Nullable class_2487 tag, class_1657 player) {
            if (tag == null) {
                return;
            }
            PipeEndpointType decodedType = ItemNetworkNode.decodeConnectionType(tag.method_10550("connectionType"));
            boolean remesh = decodedType != this.type;
            this.type = decodedType;
            this.whitelist = tag.method_10577("whitelist");
            this.insertPriority = tag.method_10550("insertPriority");
            this.extractPriority = tag.method_10550("extractPriority");
            class_2499 filterTag = tag.method_10554("filter", 10);
            for (int i = 0; i < 21; ++i) {
                this.stacks[i] = class_1799.method_7915((class_2487)filterTag.method_10602(i));
                if (this.stacks[i].method_7960()) continue;
                this.stacks[i].method_7939(1);
            }
            this.refreshStacksCache();
            class_1799 requestedUpgrade = class_1799.method_7915((class_2487)tag.method_10562("upgrade"));
            if (player.method_31549().field_7477) {
                this.upgradeStack = requestedUpgrade;
            } else {
                ItemVariant requestedVariant = ItemVariant.of((class_1799)requestedUpgrade);
                if (requestedVariant.matches(this.upgradeStack)) {
                    int delta = requestedUpgrade.method_7947() - this.upgradeStack.method_7947();
                    if (delta > 0) {
                        this.upgradeStack.method_7933(this.fetchItems(player, requestedVariant, delta));
                    } else {
                        player.method_31548().method_7398(this.upgradeStack.method_7971(-delta));
                    }
                } else {
                    player.method_31548().method_7398(this.upgradeStack);
                    this.upgradeStack = requestedVariant.toStack(this.fetchItems(player, requestedVariant, requestedUpgrade.method_7947()));
                }
            }
            pipe.method_5431();
            if (remesh) {
                pipe.sync();
            }
        }

        private int fetchItems(class_1657 player, ItemVariant what, int maxAmount) {
            try (Transaction tx = Transaction.openOuter();){
                int extracted = (int)PlayerInventoryStorage.of((class_1657)player).extract((Object)what, (long)maxAmount, (TransactionContext)tx);
                tx.commit();
                int n = extracted;
                return n;
            }
        }

        private class ScreenHandlerFactory
        implements ExtendedScreenHandlerFactory {
            private final ItemPipeInterface iface;
            private final class_2960 pipeType;

            private ScreenHandlerFactory(final IPipeScreenHandlerHelper helper, class_2960 pipeType) {
                this.iface = new ItemPipeInterface(){

                    @Override
                    public boolean isWhitelist() {
                        return ItemConnection.this.whitelist;
                    }

                    @Override
                    public void setWhitelist(boolean whitelist) {
                        ItemConnection.this.whitelist = whitelist;
                        helper.callMarkDirty();
                    }

                    @Override
                    public class_1799 getStack(int slot) {
                        return ItemConnection.this.stacks[slot];
                    }

                    @Override
                    public void setStack(int slot, class_1799 stack) {
                        ItemConnection.this.stacks[slot] = stack;
                        ItemConnection.this.refreshStacksCache();
                        helper.callMarkDirty();
                    }

                    @Override
                    public class_1799 getUpgradeStack() {
                        return ItemConnection.this.upgradeStack;
                    }

                    @Override
                    public void setUpgradeStack(class_1799 stack) {
                        ItemConnection.this.upgradeStack = stack;
                        helper.callMarkDirty();
                    }

                    @Override
                    public int getConnectionType() {
                        return ItemNetworkNode.encodeConnectionType(ItemConnection.this.type);
                    }

                    @Override
                    public void setConnectionType(int type) {
                        if (0 <= type && type < 3) {
                            ItemConnection.this.type = ItemNetworkNode.decodeConnectionType(type);
                            helper.callMarkDirty();
                            helper.callSync();
                        }
                    }

                    @Override
                    public int getPriority(int channel) {
                        return channel == 0 ? ItemConnection.this.insertPriority : ItemConnection.this.extractPriority;
                    }

                    @Override
                    public void setPriority(int channel, int priority) {
                        if (channel == 0) {
                            ItemConnection.this.insertPriority = priority;
                        } else {
                            ItemConnection.this.extractPriority = priority;
                        }
                        helper.callMarkDirty();
                    }

                    @Override
                    public boolean canUse(class_1657 player) {
                        if (!helper.isWithinUseDistance(player)) {
                            return false;
                        }
                        return helper.doesNodeStillExist(ItemNetworkNode.this) && ItemNetworkNode.this.connections.contains(ItemConnection.this);
                    }
                };
                this.pipeType = pipeType;
            }

            public class_2561 method_5476() {
                return class_2561.method_43471((String)("item." + this.pipeType.method_12836() + "." + this.pipeType.method_12832()));
            }

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new ItemPipeScreenHandler(syncId, inv, this.iface);
            }

            public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
                this.iface.toBuf(packetByteBuf);
            }
        }
    }

    public record InGameInfo(long movedItems, int pulse) {
    }
}

