/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.bom;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.bom.MaterialTree;
import dev.emi.emi.data.RecipeDefaults;
import dev.emi.emi.runtime.EmiPersistentData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;

public class BoM {
    private static RecipeDefaults defaults = new RecipeDefaults();
    public static MaterialTree tree;
    public static Map<EmiIngredient, EmiRecipe> defaultRecipes;
    public static Map<EmiIngredient, EmiRecipe> addedRecipes;
    public static Set<EmiRecipe> disabledRecipes;
    public static boolean craftingMode;

    public static void setDefaults(RecipeDefaults defaults) {
        BoM.defaults = defaults;
        class_310.method_1551().execute(() -> BoM.reload());
    }

    public static JsonObject saveAdded() {
        JsonArray added = new JsonArray();
        JsonObject addedTags = new JsonObject();
        JsonObject resolutions = new JsonObject();
        HashSet placed = Sets.newHashSet();
        for (Map.Entry<EmiIngredient, EmiRecipe> entry : addedRecipes.entrySet()) {
            EmiRecipe recipe = entry.getValue();
            if (recipe instanceof EmiResolutionRecipe) {
                EmiResolutionRecipe err = (EmiResolutionRecipe)recipe;
                EmiIngredient emiIngredient = err.ingredient;
                if (!(emiIngredient instanceof TagEmiIngredient)) continue;
                TagEmiIngredient tei = (TagEmiIngredient)emiIngredient;
                JsonElement el = EmiIngredientSerializer.getSerialized(tei.copy().setAmount(1L).setChance(1.0f));
                JsonElement val = EmiIngredientSerializer.getSerialized(err.stack);
                if (el == null || !class_3518.method_15286((JsonElement)el) || val == null) continue;
                addedTags.add(el.getAsString(), val);
                continue;
            }
            if (recipe == null || recipe.getId() == null || placed.contains(recipe.getId())) continue;
            DefaultStatus status = BoM.getRecipeStatus(recipe);
            placed.add(recipe.getId());
            if (status == DefaultStatus.FULL) {
                added.add(recipe.getId().toString());
                continue;
            }
            if (status != DefaultStatus.PARTIAL) continue;
            JsonArray arr = new JsonArray();
            for (EmiStack stack : recipe.getOutputs()) {
                JsonElement el;
                if (BoM.getRecipe(stack) != recipe || (el = EmiIngredientSerializer.getSerialized(stack)) == null) continue;
                arr.add(el);
            }
            if (arr.isEmpty()) continue;
            resolutions.add(recipe.getId().toString(), (JsonElement)arr);
        }
        JsonArray disabled = new JsonArray();
        for (EmiRecipe recipe : disabledRecipes) {
            if (recipe == null || recipe.getId() == null) continue;
            disabled.add(recipe.getId().toString());
        }
        JsonObject obj = new JsonObject();
        obj.add("added", (JsonElement)added);
        obj.add("tags", (JsonElement)addedTags);
        obj.add("resolutions", (JsonElement)resolutions);
        obj.add("disabled", (JsonElement)disabled);
        return obj;
    }

    public static void loadAdded(JsonObject object) {
        addedRecipes.clear();
        disabledRecipes.clear();
        JsonArray disabled = class_3518.method_15292((JsonObject)object, (String)"disabled", (JsonArray)new JsonArray());
        for (Object el : disabled) {
            class_2960 id = new class_2960(el.getAsString());
            EmiRecipe recipe = EmiApi.getRecipeManager().getRecipe(id);
            disabledRecipes.add(recipe);
        }
        JsonArray added = class_3518.method_15292((JsonObject)object, (String)"added", (JsonArray)new JsonArray());
        for (Object el : added) {
            class_2960 id = new class_2960(el.getAsString());
            EmiRecipe recipe = EmiApi.getRecipeManager().getRecipe(id);
            if (recipe == null || disabledRecipes.contains(recipe)) continue;
            for (EmiStack output : recipe.getOutputs()) {
                addedRecipes.put(output, recipe);
            }
        }
        JsonObject resolutions = class_3518.method_15281((JsonObject)object, (String)"resolutions", (JsonObject)new JsonObject());
        for (String key : resolutions.keySet()) {
            class_2960 id = new class_2960(key);
            EmiRecipe recipe = EmiApi.getRecipeManager().getRecipe(id);
            if (recipe == null || !class_3518.method_15264((JsonObject)resolutions, (String)key)) continue;
            JsonArray arr = class_3518.method_15261((JsonObject)resolutions, (String)key);
            for (JsonElement el : arr) {
                EmiIngredient stack = EmiIngredientSerializer.getDeserialized(el);
                if (stack.isEmpty()) continue;
                addedRecipes.put(stack, recipe);
            }
        }
        JsonObject addedTags = class_3518.method_15281((JsonObject)object, (String)"tags", (JsonObject)new JsonObject());
        for (String key : addedTags.keySet()) {
            EmiIngredient tag = EmiIngredientSerializer.getDeserialized((JsonElement)new JsonPrimitive(key));
            EmiIngredient stack = EmiIngredientSerializer.getDeserialized(addedTags.get(key));
            if (tag.isEmpty() || stack.isEmpty() || stack.getEmiStacks().size() != 1 || !tag.getEmiStacks().containsAll(stack.getEmiStacks())) continue;
            addedRecipes.put(tag, new EmiResolutionRecipe(tag, stack.getEmiStacks().get(0)));
        }
    }

    public static void reload() {
        defaultRecipes = defaults.bake();
    }

    public static boolean isRecipeEnabled(EmiRecipe recipe) {
        return !disabledRecipes.contains(recipe) && (defaultRecipes.values().contains(recipe) || addedRecipes.values().contains(recipe));
    }

    public static DefaultStatus getRecipeStatus(EmiRecipe recipe) {
        int found = 0;
        for (EmiStack stack : recipe.getOutputs()) {
            if (BoM.getRecipe(stack) != recipe) continue;
            ++found;
        }
        if (found == 0) {
            return DefaultStatus.EMPTY;
        }
        if (found >= recipe.getOutputs().size()) {
            return DefaultStatus.FULL;
        }
        return DefaultStatus.PARTIAL;
    }

    public static EmiRecipe getRecipe(EmiIngredient stack) {
        EmiRecipe recipe = addedRecipes.get(stack);
        if (recipe == null && (recipe = defaultRecipes.get(stack)) != null && disabledRecipes.contains(recipe)) {
            return null;
        }
        return recipe;
    }

    public static void setGoal(EmiRecipe recipe) {
        tree = new MaterialTree(recipe);
        craftingMode = false;
    }

    public static void addResolution(EmiIngredient ingredient, EmiRecipe recipe) {
        tree.addResolution(ingredient, recipe);
    }

    public static void addRecipe(EmiRecipe recipe) {
        disabledRecipes.remove(recipe);
        for (EmiStack stack : recipe.getOutputs()) {
            addedRecipes.put(stack, recipe);
        }
        EmiPersistentData.save();
        BoM.recalculate();
    }

    public static void addRecipe(EmiIngredient stack, EmiRecipe recipe) {
        addedRecipes.put(stack, recipe);
        EmiPersistentData.save();
        BoM.recalculate();
    }

    public static void removeRecipe(EmiRecipe recipe) {
        for (EmiStack stack : recipe.getOutputs()) {
            addedRecipes.remove(stack, recipe);
        }
        if (BoM.getRecipeStatus(recipe) != DefaultStatus.EMPTY) {
            disabledRecipes.add(recipe);
        }
        EmiPersistentData.save();
        BoM.recalculate();
    }

    private static void recalculate() {
        if (tree != null) {
            tree.recalculate();
        }
    }

    static {
        defaultRecipes = Maps.newHashMap();
        addedRecipes = Maps.newHashMap();
        disabledRecipes = Sets.newHashSet();
        craftingMode = false;
    }

    public static enum DefaultStatus {
        EMPTY,
        PARTIAL,
        FULL;

    }
}

