/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.collective_common_forge.services.Services;
import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class DuskConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final HashMap<String, List<EntryInfo>> entryHashMap = new HashMap();
    public static final Map<String, Class<?>> configClass = new HashMap();
    private static final HashMap<String, String> modidToName = new HashMap();
    private static final HashMap<String, Path> pathMap = new HashMap();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).setPrettyPrinting().create();

    public static void init(String name, String modid, Class<?> config) {
        DuskConfig.init(name, modid, config, true);
    }

    public static void init(String name, String modid, Class<?> config, Boolean initial) {
        block16: {
            pathMap.put(modid, DataFunctions.getConfigDirectoryPath().resolve(modid + ".json5"));
            configClass.put(modid, config);
            modidToName.put(modid, name);
            entryHashMap.put(modid, new ArrayList());
            HashMap configMetaData = null;
            try {
                for (Field field : config.getDeclaredFields()) {
                    if (!field.getName().equals("configMetaData")) continue;
                    configMetaData = (HashMap)field.get(config);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Field field : config.getFields()) {
                EntryInfo info = new EntryInfo();
                if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && Services.MODLOADER.isClientSide()) {
                    DuskConfig.initClient(modid, field, info, configMetaData);
                }
                if (field.isAnnotationPresent(Comment.class)) {
                    info.centered = field.getAnnotation(Comment.class).centered();
                }
                if (!field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            try {
                DuskConfig.loadJson(pathMap.get(modid), modid);
            }
            catch (Exception e) {
                DuskConfig.write(modid);
            }
            try {
                for (EntryInfo info : entryHashMap.get(modid)) {
                    if (!info.field.isAnnotationPresent(Entry.class)) continue;
                    try {
                        info.value = info.field.get(null);
                        info.tempValue = info.value.toString();
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            catch (NullPointerException ex) {
                if (!initial.booleanValue()) break block16;
                DuskConfig.init(name, modid, config, false);
            }
        }
    }

    private static void initClient(String modid, Field field, EntryInfo info, HashMap<String, List<String>> configMetaData) {
        List<String> metaData;
        Class<?> type = field.getType();
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.id = modid;
        if (e != null) {
            if (!e.name().equals("")) {
                info.name = Component.m_237115_((String)e.name());
            }
            if (type == Integer.TYPE) {
                if (e.min() != Double.MIN_NORMAL) {
                    info.minValue = (int)e.min();
                    info.maxValue = (int)e.max();
                    info.minMaxSet = true;
                }
                DuskConfig.textField(modid, info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (type == Float.TYPE) {
                if (e.min() != Double.MIN_NORMAL) {
                    info.minValue = (int)e.min();
                    info.maxValue = (int)e.max();
                    info.minMaxSet = true;
                }
                DuskConfig.textField(modid, info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (type == Double.TYPE) {
                if (e.min() != Double.MIN_NORMAL) {
                    info.minValue = (int)e.min();
                    info.maxValue = (int)e.max();
                    info.minMaxSet = true;
                }
                DuskConfig.textField(modid, info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class || type == List.class) {
                info.max = e.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)e.max();
                DuskConfig.textField(modid, info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.m_237115_((String)((Boolean)value != false ? "gui.yes" : "gui.no")).m_130940_((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            } else if (type.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.m_237115_((String)(modid + ".duskconfig.enum." + type.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            }
        }
        String fieldname = field.getName();
        if (configMetaData != null && configMetaData.containsKey(fieldname) && (metaData = configMetaData.get(fieldname)).size() > 0) {
            info.description = metaData.get(0);
            if (metaData.size() > 1) {
                info.range = metaData.get(1);
            }
        }
        if (!entryHashMap.containsKey(modid)) {
            entryHashMap.put(modid, new ArrayList());
        }
        entryHashMap.get(modid).add(info);
    }

    private static void textField(String modid, EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!((String)s).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                value = (Number)f.apply((String)s);
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)t, Component.m_237113_((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))));
            }
            info.tempValue = s;
            t.m_94202_(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.f_93623_ = entryHashMap.get(modid).stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = isNumber ? value : s;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).toList().get(0));
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.colorButton.m_93666_((Component)Component.m_237113_((String)"\u2b1b").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static void write(String modid) {
        Path path = DataFunctions.getConfigDirectoryPath().resolve(modid + ".json5");
        pathMap.put(modid, path);
        try {
            Class<?> cC;
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            if ((cC = configClass.get(modid)) == null) {
                return;
            }
            HashMap configMetaData = null;
            String lastline = "";
            StringBuilder json5 = new StringBuilder("{");
            for (Field field : cC.getDeclaredFields()) {
                if (!field.getName().equals("configMetaData")) continue;
                configMetaData = (HashMap)field.get(cC);
                break;
            }
            for (Field field : cC.getDeclaredFields()) {
                String fieldname = field.getName();
                if (fieldname.equals("configMetaData")) continue;
                if (configMetaData != null && configMetaData.containsKey(fieldname)) {
                    Entry e;
                    List metaData = (List)configMetaData.get(fieldname);
                    for (String metaDataValue : metaData) {
                        json5.append("\n\t// ").append(metaDataValue);
                    }
                    if (field.isAnnotationPresent(Entry.class) && (e = field.getAnnotation(Entry.class)).min() != Double.MIN_NORMAL) {
                        Object rangeValue = "min: " + e.min() + ", max: " + e.max();
                        if (field.getType() == Integer.TYPE) {
                            rangeValue = ((String)rangeValue).replace(".0", "");
                        }
                        json5.append("\n\t// ").append((String)rangeValue);
                    }
                }
                if (field.getType().isAssignableFrom(String.class)) {
                    Object fieldvalue = field.get(cC).toString();
                    if (((String)fieldvalue).length() > 0) {
                        if (((String)fieldvalue).charAt(0) != '\"') {
                            fieldvalue = "\"" + (String)fieldvalue + "\"";
                        }
                    } else {
                        fieldvalue = "\"\"";
                    }
                    json5.append("\n\t\"").append(fieldname).append("\": ").append((String)fieldvalue).append(",");
                } else {
                    json5.append("\n\t\"").append(fieldname).append("\": ").append(field.get(cC)).append(",");
                }
                if (lastline.equals("")) continue;
                json5.append(lastline);
            }
            json5.setLength(json5.length() - 1);
            json5.append("\n}");
            Files.write(path, json5.toString().getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadJson(Path path, String modid) throws JsonSyntaxException, IOException {
        Path oldForgeTomlPath;
        boolean rewriteConfig = false;
        Path oldFabricJsonPath = DataFunctions.getConfigDirectoryPath().resolve(modid + ".json");
        if (Files.exists(oldFabricJsonPath, new LinkOption[0])) {
            Files.move(oldFabricJsonPath, path, StandardCopyOption.REPLACE_EXISTING);
            rewriteConfig = true;
        }
        if (Files.exists(oldForgeTomlPath = DataFunctions.getConfigDirectoryPath().resolve(modid + "-common.toml"), new LinkOption[0])) {
            DuskConfig.convertTomlToJson(oldForgeTomlPath, path);
            rewriteConfig = true;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            rewriteConfig = true;
        }
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        content = Stream.of(content.split("\n")).filter(s -> !s.startsWith("\t//")).collect(Collectors.joining("\n"));
        gson.fromJson((Reader)new StringReader(content), configClass.get(modid));
        if (rewriteConfig) {
            DuskConfig.write(modid);
        }
    }

    private static void convertTomlToJson(Path oldTomlPath, Path newJsonPath) throws IOException {
        JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(newJsonPath.toString()));
        jsonWriter.beginObject();
        String tomlContent = Files.readString(oldTomlPath, StandardCharsets.UTF_8);
        for (String line : tomlContent.split("\n")) {
            String[] linespl;
            if ((line = line.trim()).startsWith("[") || line.startsWith("#") || (linespl = line.split(" = ", 2)).length != 2) continue;
            String key = linespl[0];
            String rawValue = linespl[1].strip();
            if (rawValue.equals("true") || rawValue.equals("false")) {
                jsonWriter.name(key).value(Boolean.parseBoolean(rawValue));
                continue;
            }
            if (NumberFunctions.isNumeric(rawValue)) {
                if (rawValue.contains(".")) {
                    jsonWriter.name(key).value(Double.parseDouble(rawValue));
                    continue;
                }
                jsonWriter.name(key).value((long)Integer.parseInt(rawValue));
                continue;
            }
            jsonWriter.name(key).value(rawValue);
        }
        jsonWriter.endObject();
        jsonWriter.close();
        Files.delete(oldTomlPath);
    }

    protected static class EntryInfo {
        Field field;
        Object widget;
        int width;
        double minValue;
        double maxValue;
        boolean minMaxSet = false;
        int max;
        boolean centered;
        Map.Entry<EditBox, Component> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        String id;
        Component name;
        String description = "";
        String range = "";
        int index;
        AbstractWidget colorButton;

        protected EntryInfo() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 100;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public boolean isColor() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font font = Minecraft.m_91087_().f_91062_;
        public final List<AbstractWidget> buttons;
        private final Component text;
        public final EntryInfo info;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        public static final Map<AbstractWidget, Component> buttonsWithComponent = new HashMap<AbstractWidget, Component>();

        private ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            if (!buttons.isEmpty()) {
                buttonsWithComponent.put(buttons.get(0), text);
            }
            this.buttons = buttons;
            this.text = text;
            this.info = info;
            this.children.addAll(buttons);
        }

        public static ButtonEntry create(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            return new ButtonEntry(buttons, text, info);
        }

        public void m_6311_(@NotNull GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.m_253211_(y);
                b.m_88315_(matrices, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                if (this.info.centered) {
                    matrices.m_280430_(font, this.text, (int)((float)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0f - (float)font.m_92852_((FormattedText)this.text) / 2.0f), y + 5, 0xFFFFFF);
                } else {
                    matrices.m_280430_(font, this.text, 12, y + 5, 0xFFFFFF);
                }
            }
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }

    public static class DuskConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font font;

        public DuskConfigListWidget(Minecraft client, int i, int j, int k, int l, int m) {
            super(client, i, j, k, l, m);
            this.f_93394_ = false;
            this.font = client.f_91062_;
        }

        public int m_5756_() {
            return this.f_93388_ - 7;
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.m_7085_((AbstractSelectionList.Entry)ButtonEntry.create(buttons, text, info));
        }

        public int m_5759_() {
            return 10000;
        }

        public Optional<AbstractWidget> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.m_6702_()) {
                if (buttonEntry.buttons.isEmpty() || !buttonEntry.buttons.get(0).m_5953_(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.buttons.get(0));
            }
            return Optional.empty();
        }
    }

    public static class DuskConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final Screen parent;
        public final String modid;
        public DuskConfigListWidget list;
        public boolean reload = false;

        protected DuskConfigScreen(Screen parent, String modid) {
            super((Component)Component.m_237113_((String)(StringUtils.capitalize((String)modidToName.get(modid)) + " Config")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".duskconfig.";
        }

        public static Screen getScreen(Screen parent, String modid) {
            return new DuskConfigScreen(parent, modid);
        }

        public void m_86600_() {
            super.m_86600_();
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateResetButtons();
        }

        public void updateResetButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.m_6702_()) {
                    AbstractWidget abstractWidget;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || !((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.f_93623_ = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public void loadValues() {
            try {
                DuskConfig.loadJson(pathMap.get(this.modid), this.modid);
            }
            catch (Exception e) {
                DuskConfig.write(this.modid);
            }
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.value.toString();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        public void m_7856_() {
            super.m_7856_();
            if (!this.reload) {
                this.loadValues();
            }
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
                this.loadValues();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }).m_252794_(this.f_96543_ / 2 - 154, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
            Button done = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
                for (EntryInfo info : entryHashMap.get(this.modid)) {
                    if (!info.id.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                DuskConfig.write(this.modid);
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }).m_252794_(this.f_96543_ / 2 + 4, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
            this.list = new DuskConfigListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.list.m_93488_(false);
            }
            this.m_7787_((GuiEventListener)this.list);
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                if (info.id.equals(this.modid)) {
                    String namestring = info.field.getName();
                    namestring = namestring.replace("_", " ").strip();
                    String[] nsspl = namestring.split("(?<=.)(?=\\p{Lu})");
                    ArrayList<Object> correctNameParts = new ArrayList();
                    try {
                        for (int i = 0; i < nsspl.length; ++i) {
                            StringBuilder namePart = new StringBuilder(nsspl[i]);
                            if (namePart.toString().strip().length() == 1) {
                                boolean append = false;
                                while (i < nsspl.length) {
                                    if (append) {
                                        namePart.append(nsspl[i]);
                                    }
                                    if (i + 1 >= nsspl.length || nsspl[i + 1].strip().length() != 1) break;
                                    append = true;
                                    ++i;
                                }
                            }
                            if (correctNameParts.contains(namePart.toString())) continue;
                            correctNameParts.add(namePart.toString());
                        }
                    }
                    catch (Exception ex) {
                        correctNameParts = new ArrayList<String>(Arrays.asList(nsspl));
                    }
                    String formattedName = StringUtils.capitalize((String)String.join((CharSequence)" ", correctNameParts));
                    MutableComponent name = Component.m_237113_((String)formattedName);
                    Button resetButton = Button.m_253074_((Component)Component.m_237113_((String)"Reset").m_130940_(ChatFormatting.RED), button -> {
                        info.value = info.defaultValue;
                        info.tempValue = info.defaultValue.toString();
                        info.index = 0;
                        double scrollAmount = this.list.m_93517_();
                        this.reload = true;
                        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                        this.list.m_93410_(scrollAmount);
                    }).m_252794_(this.f_96543_ - 205, 0).m_253046_(40, 20).m_253136_();
                    if (info.widget instanceof Map.Entry) {
                        widget = (Map.Entry)info.widget;
                        if (info.field.getType().isEnum()) {
                            widget.setValue(value -> Component.m_237115_((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                        }
                        this.list.addButton(List.of(Button.m_253074_((Component)((Component)((Function)widget.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)widget.getKey())).m_252794_(this.f_96543_ - 160, 0).m_253046_(150, 20).m_253136_(), resetButton), (Component)name, info);
                    } else if (info.field.getType() == List.class) {
                        if (!this.reload) {
                            info.index = 0;
                        }
                        widget = new EditBox(this.f_96547_, this.f_96543_ - 160, 0, 150, 20, null);
                        widget.m_94199_(Integer.MAX_VALUE);
                        if (info.index < ((List)info.value).size()) {
                            widget.m_94144_(String.valueOf(((List)info.value).get(info.index)));
                        } else {
                            widget.m_94144_("");
                        }
                        processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                        widget.m_94153_(processor);
                        resetButton.m_93674_(20);
                        resetButton.m_93666_((Component)Component.m_237113_((String)"R").m_130940_(ChatFormatting.RED));
                        Button cycleButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(info.index)), button -> {
                            ((List)info.value).remove("");
                            double scrollAmount = this.list.m_93517_();
                            this.reload = true;
                            ++info.index;
                            if (info.index > ((List)info.value).size()) {
                                info.index = 0;
                            }
                            Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                            this.list.m_93410_(scrollAmount);
                        }).m_252794_(this.f_96543_ - 185, 0).m_253046_(20, 20).m_253136_();
                        this.list.addButton(List.of(widget, resetButton, cycleButton), (Component)name, info);
                    } else if (info.widget != null) {
                        widget = new EditBox(this.f_96547_, this.f_96543_ - 160, 0, 150, 20, null);
                        widget.m_94199_(Integer.MAX_VALUE);
                        widget.m_94144_(info.tempValue);
                        processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                        widget.m_94153_(processor);
                        if (info.field.getAnnotation(Entry.class).isColor()) {
                            resetButton.m_93674_(20);
                            resetButton.m_93666_((Component)Component.m_237113_((String)"R").m_130940_(ChatFormatting.RED));
                            Button colorButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2b1b"), button -> {}).m_252794_(this.f_96543_ - 185, 0).m_253046_(20, 20).m_253136_();
                            try {
                                colorButton.m_93666_((Component)Component.m_237113_((String)"\u2b1b").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.colorButton = colorButton;
                            colorButton.f_93623_ = false;
                            this.list.addButton(List.of(widget, resetButton, colorButton), (Component)name, info);
                        } else {
                            this.list.addButton(List.of(widget, resetButton), (Component)name, info);
                        }
                    } else {
                        this.list.addButton(List.of(), (Component)name, info);
                    }
                    Object rangeValue = "";
                    if (info.minMaxSet) {
                        rangeValue = "min: " + info.minValue + ", max: " + info.maxValue;
                        if (info.field.getType() == Integer.TYPE) {
                            rangeValue = ((String)rangeValue).replace(".0", "");
                        }
                    } else if (!info.range.equals("")) {
                        rangeValue = info.range;
                    }
                    if (!((String)rangeValue).equals("")) {
                        EditBox label = new EditBox(this.f_96547_, this.f_96543_ - 155, 0, 145, 20, null);
                        label.m_94144_((String)rangeValue);
                        label.m_94182_(false);
                        label.m_94186_(false);
                        this.list.addButton(List.of(label), (Component)Component.m_237113_((String)""), info);
                    }
                }
                this.updateResetButtons();
            }
        }

        public void m_88315_(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
            this.m_280273_(matrices);
            this.list.m_88315_(matrices, mouseX, mouseY, delta);
            matrices.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
            for (EntryInfo info : entryHashMap.get(this.modid)) {
                if (!info.id.equals(this.modid) || !this.list.getHoveredButton(mouseX, mouseY).isPresent()) continue;
                AbstractWidget Button2 = this.list.getHoveredButton(mouseX, mouseY).get();
                Component text = ButtonEntry.buttonsWithComponent.get(Button2);
                MutableComponent name = Component.m_237115_((String)(this.translationPrefix + info.field.getName()));
                String key = this.translationPrefix + info.field.getName() + ".tooltip";
                if (info.error != null && text.equals(name)) {
                    matrices.m_280557_(this.f_96547_, info.error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!I18n.m_118936_((String)key) || !text.equals(name)) continue;
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                for (String str : I18n.m_118938_((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add(Component.m_237113_((String)str));
                }
                matrices.m_280666_(this.f_96547_, list, mouseX, mouseY);
            }
            super.m_88315_(matrices, mouseX, mouseY, delta);
        }
    }
}

