/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui.render;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_367;
import net.minecraft.class_368;
import net.minecraft.class_3928;
import net.minecraft.class_433;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class AdvancementPlaque {
    private final class_367 toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private class_368.class_369 visibility = class_368.class_369.field_2210;
    private class_310 mc;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(class_367 toastIn, class_310 mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.mc = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public class_367 getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = class_3532.method_15363((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == class_368.class_369.field_2209 ? 1.0f - f : f;
    }

    private class_368.class_369 drawPlaque(class_332 graphics, long displayTime) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 instanceof class_433 || mc.field_1755 instanceof class_3928) {
            return class_368.class_369.field_2210;
        }
        class_185 displayInfo = this.toast.field_2205.method_686();
        class_4587 poseStack = graphics.method_51448();
        if (displayInfo != null) {
            float alpha;
            float fadeOutTime;
            float fadeInTime;
            float duration = switch (displayInfo.method_815()) {
                default -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskDuration.get() * 1000.0);
                }
                case class_189.field_1249 -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalDuration.get() * 1000.0);
                }
                case class_189.field_1250 -> {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeOutTime.get() * 1000.0);
                    yield (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeDuration.get() * 1000.0);
                }
            };
            if ((float)displayTime >= fadeInTime) {
                alpha = 1.0f;
                if ((float)displayTime > duration) {
                    alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                    if (FabricLoader.getInstance().isModLoaded("canvas")) {
                        alpha = 0.0f;
                    }
                }
                int tempColor = (int)((Long)AdvancementPlaquesConfig.INSTANCE.titleColor.get()).longValue();
                int tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int titleColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                tempColor = (int)((Long)AdvancementPlaquesConfig.INSTANCE.nameColor.get()).longValue();
                tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int nameColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                RenderSystem.setShaderTexture((int)0, (class_2960)AdvancementPlaques.TEXTURE_PLAQUES);
                int frameOffset = 0;
                if (displayInfo.method_815() == class_189.field_1249) {
                    frameOffset = 1;
                } else if (displayInfo.method_815() == class_189.field_1250) {
                    frameOffset = 2;
                }
                GuiHelper.blit((class_4587)graphics.method_51448(), (int)-1, (int)-1, (int)this.width(), (int)this.height(), (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (int)256, (int)256);
                if (alpha > 0.1f) {
                    int typeWidth = mc.field_1772.method_27525((class_5348)displayInfo.method_815().method_30756());
                    graphics.method_51439(mc.field_1772, displayInfo.method_815().method_30756(), (int)((float)(this.width() - typeWidth) / 2.0f + 15.0f), 5, titleColor, false);
                    int titleWidth = mc.field_1772.method_27525((class_5348)displayInfo.method_811());
                    if ((float)titleWidth <= 146.66667f) {
                        poseStack.method_22903();
                        poseStack.method_22905(1.5f, 1.5f, 1.0f);
                        graphics.method_51430(mc.field_1772, class_2477.method_10517().method_30934((class_5348)displayInfo.method_811()), (int)(((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f), 9, nameColor, false);
                        poseStack.method_22909();
                    } else {
                        graphics.method_51430(mc.field_1772, class_2477.method_10517().method_30934((class_5348)displayInfo.method_811()), (int)((float)(this.width() - titleWidth) / 2.0f + 15.0f), 15, nameColor, false);
                    }
                }
                poseStack.method_22903();
                poseStack.method_46416(1.0f, 1.0f, 0.0f);
                poseStack.method_22905(1.5f, 1.5f, 1.0f);
                if (FabricLoader.getInstance().isModLoaded("canvas")) {
                    if (alpha > 0.0f) {
                        poseStack.method_46416(0.0f, 0.0f, -2000.0f);
                        graphics.method_51427(displayInfo.method_821(), 1, 1);
                    }
                } else {
                    this.itemRenderer.renderItemModelIntoGUIWithAlpha(poseStack, displayInfo.method_821(), 1, 1, alpha);
                }
                poseStack.method_22909();
                if (!this.hasPlayedSound) {
                    this.hasPlayedSound = true;
                    try {
                        switch (displayInfo.method_815()) {
                            case field_1254: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteTasks.get()).booleanValue()) {
                                    mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)AdvancementPlaques.TASK_COMPLETE, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            case field_1249: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteGoals.get()).booleanValue()) {
                                    mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)AdvancementPlaques.GOAL_COMPLETE, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            default: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteChallenges.get()).booleanValue()) {
                                    mc.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15195, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        AdvancementPlaques.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered! Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                    }
                }
            }
            if ((float)displayTime < fadeInTime + fadeOutTime) {
                alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                if ((float)displayTime < fadeInTime) {
                    alpha = (float)displayTime / fadeInTime;
                }
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, 95.0f);
                RenderSystem.setShaderTexture((int)0, (class_2960)AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                if (displayInfo.method_815() == class_189.field_1250) {
                    GuiHelper.blit((class_4587)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                } else {
                    GuiHelper.blit((class_4587)poseStack, (int)-16, (int)-16, (int)(this.width() + 32), (int)(this.height() + 32), (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                }
                poseStack.method_22909();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
        }
        return class_368.class_369.field_2209;
    }

    public boolean render(int screenWidth, int index, class_332 graphics) {
        long currentTime = class_156.method_658();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
        }
        if (this.visibility == class_368.class_369.field_2210 && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        RenderSystem.disableDepthTest();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        if (((Boolean)AdvancementPlaquesConfig.INSTANCE.onTop.get()).booleanValue()) {
            poseStack.method_46416((float)(this.mc.method_22683().method_4486() - this.width()) / 2.0f + (float)((Integer)AdvancementPlaquesConfig.INSTANCE.horizontalOffset.get()).intValue(), (float)((Integer)AdvancementPlaquesConfig.INSTANCE.distance.get()).intValue(), 800.0f + (float)index);
        } else {
            poseStack.method_46416((float)(this.mc.method_22683().method_4486() - this.width()) / 2.0f + (float)((Integer)AdvancementPlaquesConfig.INSTANCE.horizontalOffset.get()).intValue(), (float)(this.mc.method_22683().method_4502() - (this.height() + (Integer)AdvancementPlaquesConfig.INSTANCE.distance.get())), 800.0f + (float)index);
        }
        class_368.class_369 newVisibility = this.drawPlaque(graphics, currentTime - this.visibleTime);
        poseStack.method_22909();
        RenderSystem.enableDepthTest();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == class_368.class_369.field_2209 && currentTime - this.animationTime > 200L;
    }
}

