/*
 * Decompiled with CFR 0.152.
 */
package dev.alexnijjar.extractinator.client;

import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import dev.alexnijjar.extractinator.client.ClientPlatformUtils;
import dev.alexnijjar.extractinator.common.block.ExtractinatorBlock;
import dev.alexnijjar.extractinator.common.block.ExtractinatorBlockEntity;
import dev.alexnijjar.extractinator.common.registry.ModBlocks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class ExtractinatorRenderer
implements class_827<ExtractinatorBlockEntity> {
    public static final class_2960 BASE = new class_2960("extractinator", "block/extractinator/base");
    public static final class_2960 PUMP = new class_2960("extractinator", "block/extractinator/pump");
    public static final class_2960 TORQUE_WHEEL = new class_2960("extractinator", "block/extractinator/torque_wheel");
    public static final class_2960 COGWHEEL = new class_2960("extractinator", "block/extractinator/cogwheel");
    public static final class_2960 CHIMNEY = new class_2960("extractinator", "block/extractinator/chimney");

    public ExtractinatorRenderer(class_5614.class_5615 ctx) {
    }

    public void render(ExtractinatorBlockEntity extractinator, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        long time = extractinator.method_10997() == null ? 0L : extractinator.method_10997().method_8510();
        class_2350 dir = (class_2350)extractinator.method_11010().method_11654((class_2769)ExtractinatorBlock.FACING);
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_22904(0.5, 1.0, 0.5);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(dir.method_10144()));
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
            poseStack.method_22904(-0.5, -1.0, -0.5);
            try (CloseablePoseStack ignored1 = new CloseablePoseStack(poseStack);){
                ExtractinatorRenderer.renderPump(time, poseStack, bufferSource, packedLight, packedOverlay);
                ExtractinatorRenderer.renderCogwheel(time, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
                ExtractinatorRenderer.renderChimney(time, poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
    }

    protected static void renderPump(long time, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        long animationTime = time % 80L;
        long frameTime = time % 20L;
        float translation = (float)((int)((float)animationTime / 20.0f)) * 0.0625f;
        if ((int)((float)animationTime / 20.0f) < 3) {
            if (frameTime > 17L) {
                translation += (float)(frameTime - 17L) * 0.03125f;
            }
        } else {
            translation = 0.1875f;
            if (frameTime > 14L) {
                translation -= (float)(frameTime - 14L) * 0.0375f;
            }
        }
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_46416(0.0f, -translation, 0.0f);
            ExtractinatorRenderer.renderBlock(PUMP, poseStack, buffer, packedLight, packedOverlay);
            ExtractinatorRenderer.renderTorqueWheel(time, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderTorqueWheel(long time, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        long animationTime = time % 80L;
        long frameTime = time % 20L;
        float offset = ((int)((float)animationTime / 20.0f) - 1) * 90;
        float frameRot = frameTime < 2L ? 0.0f : (frameTime < 6L ? (float)(frameTime - 2L) * 11.25f : (frameTime < 10L ? 45.0f + (float)(frameTime - 5L) * 2.5f : (frameTime < 16L ? 55.0f + (float)(frameTime - 9L) * 7.5f : 100.0f - ((float)frameTime - 15.0f) * 2.5f)));
        float angle = Math.min(offset + frameRot, offset + 100.0f);
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_22904(0.65625, 0.0, 0.34375);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(angle));
            ExtractinatorRenderer.renderBlock(TORQUE_WHEEL, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderCogwheel(long time, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_22904(0.34375, 0.0, 0.65625);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)((double)((float)time + partialTick) * -5.0)));
            ExtractinatorRenderer.renderBlock(COGWHEEL, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderChimney(long time, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        long animationTime = time % 80L;
        float scale = 1.0f;
        if (animationTime > 74L) {
            scale += 0.4f - (float)(animationTime - 70L) * 0.04f;
        } else if (animationTime > 70L) {
            scale += (float)(animationTime - 70L) * 0.08f;
        }
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_46416(0.125f, 0.625f, 0.25f);
            poseStack.method_22905(scale, scale, scale);
            ExtractinatorRenderer.renderBlock(CHIMNEY, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderBlock(class_2960 model, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_1087 blockModel = ClientPlatformUtils.getModel(class_310.method_1551().method_1554(), model);
        class_310.method_1551().method_1541().method_3350().method_3367(poseStack.method_23760(), buffer.getBuffer(class_4722.method_24074()), ((class_2248)ModBlocks.EXTRACTINATOR.get()).method_9564(), blockModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
    }

    public static class ExtractinatorItemRenderer
    extends class_756 {
        public ExtractinatorItemRenderer() {
            super(class_310.method_1551().method_31975(), class_310.method_1551().method_31974());
        }

        public void method_3166(class_1799 stack, class_811 itemDisplayContext, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
            ExtractinatorRenderer.renderBlock(BASE, poseStack, buffer, packedLight, packedOverlay);
            class_310 minecraft = class_310.method_1551();
            long time = minecraft.field_1687 == null ? 0L : minecraft.field_1687.method_8510();
            ExtractinatorRenderer.renderPump(time, poseStack, buffer, packedLight, packedOverlay);
            ExtractinatorRenderer.renderCogwheel(time, minecraft.method_1534(), poseStack, buffer, packedLight, packedOverlay);
            ExtractinatorRenderer.renderChimney(time, poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

