/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import java.util.HashSet;
import java.util.Set;
import journeypac.platform.ConfigFacade;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class JPACConfig
implements ConfigFacade {
    public static final JPACConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    private final ForgeConfigSpec.BooleanValue showClaims;
    private final ForgeConfigSpec.BooleanValue showForceloads;
    private final ForgeConfigSpec.BooleanValue showClaimant;
    private final ForgeConfigSpec.DoubleValue claimOpacity;
    private final ForgeConfigSpec.DoubleValue forceloadOpacity;
    private final ForgeConfigSpec.DoubleValue forceloadStroke;
    private final ForgeConfigSpec.DoubleValue validAreaOpacity;
    private Set<Runnable> onConfigReload = new HashSet<Runnable>();

    private JPACConfig(ForgeConfigSpec.Builder builder) {
        this.showClaims = builder.comment("Whether claims are currently shown, toggleable from the fullscreen map").define("show_claims", true);
        this.showForceloads = builder.comment("Whether forceloaded chunks are marked with an outline (only if claims are shown)").worldRestart().define("show_forceloads", true);
        this.showClaimant = builder.comment("Whether claim owners are shown when hovering over a chunk").worldRestart().define("show_claimant", true);
        this.claimOpacity = builder.comment("Opacity of a claim on the map (0 is invisible)").worldRestart().defineInRange("claim_opacity", 0.25, 0.0, 1.0);
        this.forceloadOpacity = builder.comment("Opacity of the forceload marker (0 is invisible)").worldRestart().defineInRange("forceload_opacity", 1.0, 0.0, 1.0);
        this.forceloadStroke = builder.comment("Thickness of the forceload marker (in pixels)").worldRestart().defineInRange("forceload_stroke", 2.0, 0.0, 16.0);
        this.validAreaOpacity = builder.comment("Opacity of the claimable area outline (0 is invisible)").defineInRange("valid_area_opacity", 0.5, 0.0, 1.0);
    }

    @Override
    public boolean getShowClaims() {
        return (Boolean)this.showClaims.get();
    }

    @Override
    public void setShowClaims(boolean show) {
        this.showClaims.set((Object)show);
        this.showClaims.save();
    }

    @Override
    public boolean getShowForceloads() {
        return (Boolean)this.showForceloads.get();
    }

    @Override
    public boolean getShowClaimant() {
        return (Boolean)this.showClaimant.get();
    }

    @Override
    public double getClaimOpacity() {
        return (Double)this.claimOpacity.get();
    }

    @Override
    public double getForceloadOpacity() {
        return (Double)this.forceloadOpacity.get();
    }

    @Override
    public double getForceloadStroke() {
        return (Double)this.forceloadStroke.get();
    }

    @Override
    public double getValidAreaOpacity() {
        return (Double)this.validAreaOpacity.get();
    }

    public void fireConfigReload() {
        this.onConfigReload.forEach(Runnable::run);
    }

    @Override
    public void onConfigReload(Runnable func) {
        this.onConfigReload.add(func);
    }

    static {
        Pair configPair = new ForgeConfigSpec.Builder().configure(JPACConfig::new);
        CONFIG = (JPACConfig)configPair.getLeft();
        SPEC = (ForgeConfigSpec)configPair.getRight();
    }
}

