/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_773;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ClientSpecialModelsManager {
    private static final Map<class_2248, class_2960> SPECIAL_MOUNT_TEXTURES = new IdentityHashMap<class_2248, class_2960>();
    private static final Map<class_2248, class_2960> SPECIAL_LANTERN_MODELS = new IdentityHashMap<class_2248, class_2960>();
    private static final Set<class_2248> POSSIBLE_LANTERNS = new HashSet<class_2248>();
    private static boolean initialized = false;

    public static void refreshModels(class_3300 manager) {
        ClientSpecialModelsManager.reloadTextures(manager);
        ClientSpecialModelsManager.reloadModels(manager);
    }

    private static void reloadModels(class_3300 manager) {
        if (!initialized) {
            ClientSpecialModelsManager.initialize();
            initialized = true;
        }
        SPECIAL_LANTERN_MODELS.clear();
        for (class_2248 l : POSSIBLE_LANTERNS) {
            class_2960 reg = Utils.getID((class_2248)l);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("supplementaries") ? "" : reg.method_12836() + "/";
            String s = "block/custom_wall_lanterns/" + (String)namespace + reg.method_12832();
            class_2960 fullPath = Supplementaries.res("models/" + s + ".json");
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            SPECIAL_LANTERN_MODELS.put(l, Supplementaries.res(s));
        }
    }

    private static void reloadTextures(class_3300 manager) {
        if (!initialized) {
            ClientSpecialModelsManager.initialize();
            initialized = true;
        }
        SPECIAL_MOUNT_TEXTURES.clear();
        for (class_2248 l : POSSIBLE_LANTERNS) {
            class_2960 reg = Utils.getID((class_2248)l);
            Object namespace = reg.method_12836().equals("minecraft") || reg.method_12836().equals("supplementaries") ? "" : reg.method_12836() + "/";
            String s = "textures/block/wall_lanterns/" + (String)namespace + reg.method_12832() + ".json";
            class_2960 fullPath = Supplementaries.res(s);
            Optional resource = manager.method_14486(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((class_3298)resource.get()).method_14482();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_MOUNT_TEXTURES.put(l, new class_2960(texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void initialize() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_2248 i : class_7923.field_41175) {
            if (!WallLanternBlock.isValidBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS.clear();
        POSSIBLE_LANTERNS.addAll((Collection<class_2248>)builder.build());
    }

    @Nullable
    public static class_1058 getTextureForLantern(class_2248 block) {
        class_2960 res = SPECIAL_MOUNT_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(res);
    }

    public static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        SPECIAL_LANTERN_MODELS.values().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
    }

    public static class_1087 getWallLanternModel(class_773 blockModelShaper, class_2680 lantern) {
        class_2960 special = SPECIAL_LANTERN_MODELS.get(lantern.method_26204());
        if (special != null) {
            return ClientHelper.getModel((class_1092)class_310.method_1551().method_1554(), (class_2960)special);
        }
        return blockModelShaper.method_3335(lantern);
    }
}

