/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class FilteredPlayerListWidget
implements class_6379,
class_364,
class_4068 {
    private static final int ENTRY_PER_SCREEN = 3;
    private static final int ITEM_HEIGHT = 12;
    private static final int WIDTH = 101;
    private static final int HEIGHT = 36;
    private static final int SCROLLER_W = 6;
    private static final int SCROLLER_H = 17;
    private static final int SCROLLER_X = 102;
    private final List<SimplePlayerEntry> allPlayers = new ArrayList<SimplePlayerEntry>();
    private final List<SimplePlayerEntry> filtered = new ArrayList<SimplePlayerEntry>();
    private final class_310 minecraft;
    protected final int x;
    protected final int y;
    protected final int x1;
    protected final int y1;
    private final Consumer<String> onClick;
    private String filter;
    private int scrollOff;
    private boolean isDragging;
    private boolean focused;

    public FilteredPlayerListWidget(class_310 minecraft, int x, int y, Consumer<String> onClick) {
        this.minecraft = minecraft;
        this.x = x;
        this.y = y;
        this.x1 = x + 101;
        this.y1 = y + 36;
        this.onClick = onClick;
        Collection collection = this.minecraft.field_1724.field_3944.method_31363();
        for (UUID uuid : collection) {
            class_640 playerinfo = this.minecraft.field_1724.field_3944.method_2871(uuid);
            if (playerinfo == null) continue;
            this.allPlayers.add(new SimplePlayerEntry(playerinfo, this.minecraft.field_1772));
        }
        this.filtered.addAll(this.allPlayers);
    }

    public void method_25365(boolean bl) {
        this.focused = bl;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public List<String> setFilter(@Nullable String filter) {
        if (filter == null) {
            filter = "";
        }
        this.filter = filter.toLowerCase(Locale.ROOT);
        this.updateFilteredEntries();
        return this.filtered.stream().map(SimplePlayerEntry::getName).toList();
    }

    private void updateFilteredEntries() {
        this.filtered.clear();
        this.filtered.addAll(this.allPlayers.stream().filter(s -> s.getName().toLowerCase(Locale.ROOT).startsWith(this.filter)).toList());
    }

    public void addPlayer(class_640 info) {
        this.allPlayers.add(new SimplePlayerEntry(info, this.minecraft.field_1772));
        this.updateFilteredEntries();
    }

    public void removePlayer(UUID id) {
        for (SimplePlayerEntry simplePlayerEntry : this.allPlayers) {
            if (!simplePlayerEntry.getId().equals(id)) continue;
            this.allPlayers.remove(simplePlayerEntry);
            this.updateFilteredEntries();
            return;
        }
    }

    private boolean canScroll() {
        return this.filtered.size() > 3;
    }

    public boolean method_25402(double mouseX, double mouseY, int key) {
        SimplePlayerEntry e;
        boolean bl = this.isDragging = this.canScroll() && mouseX > (double)(this.x + 102) && mouseX < (double)(this.x + 102 + 6) && mouseY > (double)this.y && mouseY <= (double)(this.y + 36 + 1);
        if (this.method_25405(mouseX, mouseY) && (e = this.getEntryAtPosition(mouseX, mouseY)) != null) {
            this.onClick.accept(e.playerName);
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
        return false;
    }

    public boolean method_25403(double dx, double dy, int key, double mouseX, double mouseY) {
        if (this.isDragging) {
            int j = this.filtered.size() - 3;
            float f = ((float)dy - (float)this.y - 13.5f) / ((float)(this.y1 - this.y) - 17.0f);
            f = f * (float)j + 0.5f;
            this.scrollOff = class_3532.method_15340((int)((int)f), (int)0, (int)j);
            return true;
        }
        return false;
    }

    public boolean method_25401(double a, double b, double c) {
        if (this.canScroll()) {
            int j = this.filtered.size() - 3;
            this.scrollOff = (int)((double)this.scrollOff - c);
            this.scrollOff = class_3532.method_15340((int)this.scrollOff, (int)0, (int)j);
        }
        return true;
    }

    public boolean method_25404(int key, int a, int b) {
        if (key == 265) {
            this.scrollOff = Math.max(0, this.scrollOff - 1);
            return true;
        }
        if (key == 264) {
            this.scrollOff = class_3532.method_15340((int)(this.scrollOff + 1), (int)0, (int)(this.filtered.size() - 3));
            return true;
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.y && mouseY <= (double)this.y1 && mouseX >= (double)this.x && mouseX <= (double)this.x1;
    }

    @Nullable
    protected final SimplePlayerEntry getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX > (double)this.x1) {
            return null;
        }
        int rel = class_3532.method_15357((double)(mouseY - (double)this.y));
        int ind = this.scrollOff + rel / 12;
        return rel >= 0 && ind < this.filtered.size() ? this.filtered.get(ind) : null;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int size = this.filtered.size();
        this.renderScroller(graphics, size);
        if (size != 0) {
            SimplePlayerEntry hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
            int currentY = this.y;
            for (int i = 0; this.scrollOff + i < size && i < 3; ++i) {
                SimplePlayerEntry e = this.filtered.get(this.scrollOff + i);
                e.render(graphics, this.scrollOff + i, this.x, currentY, 101, 12, mouseX, mouseY, Objects.equals(hovered, e), partialTicks);
                currentY += 12;
            }
        }
    }

    private void renderScroller(class_332 graphics, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int currentIndex = size + 1 - 3;
        if (currentIndex > 1) {
            int a = 36 - (17 + (currentIndex - 1) * 36 / currentIndex);
            int b = 1 + a / currentIndex + 36 / currentIndex;
            int scroll = Math.min(19, this.scrollOff * b);
            if (this.scrollOff == currentIndex - 1) {
                scroll = 19;
            }
            graphics.method_25291(ModTextures.PRESENT_GUI_TEXTURE, this.x + 102, this.y + scroll, 0, 0.0f, 232.0f, 6, 17, 256, 256);
        } else {
            graphics.method_25291(ModTextures.PRESENT_GUI_TEXTURE, this.x + 102, this.y, 0, 6.0f, 232.0f, 6, 17, 256, 256);
        }
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public void setState(boolean hasItem, boolean packed) {
        this.filtered.clear();
        if (!packed && hasItem) {
            this.filtered.addAll(this.allPlayers);
        }
    }

    public static class SimplePlayerEntry {
        private static final int SKIN_SIZE = 8;
        private final class_327 font;
        private final UUID id;
        private final String playerName;
        private final Supplier<class_2960> skinGetter;

        public SimplePlayerEntry(class_640 playerInfo, class_327 font) {
            this.id = playerInfo.method_2966().getId();
            this.playerName = playerInfo.method_2966().getName();
            this.skinGetter = () -> ((class_640)playerInfo).method_2968();
            this.font = font;
        }

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.playerName;
        }

        public void render(class_332 graphics, int pIndex, int pLeft, int pTop, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean hovered, float pPartialTicks) {
            int i = pLeft + 2;
            int j = pTop + (pHeight - 8) / 2;
            int k = i + 8 + 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25291(ModTextures.PRESENT_GUI_TEXTURE, pLeft, pTop, 0, 0.0f, 220.0f, pWidth, pHeight, 256, 256);
            class_2960 resourceLocation = this.skinGetter.get();
            graphics.method_25293(resourceLocation, i, j, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.method_25293(resourceLocation, i, j, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            graphics.method_25303(this.font, this.playerName, k, j, hovered ? -1 : 0);
        }
    }
}

