/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BlockGeneratorBlockTile
extends class_2586 {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private final AtomicReference<List<StructureLocator.LocatedStruct>> threadResult = new AtomicReference<Object>(null);
    private boolean firstTick = true;
    private RoadSignFeature.Config config = null;

    public BlockGeneratorBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BlockGeneratorBlockTile tile) {
        if (tile.firstTick) {
            tile.firstTick = false;
            class_3218 serverLevel = (class_3218)level;
            EXECUTORS.submit(() -> {
                try {
                    tile.threadResult.set(StructureLocator.findNearestMapFeatures(serverLevel, ModTags.WAY_SIGN_DESTINATIONS, pos, 250, false, 2, false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        try {
            List<StructureLocator.LocatedStruct> result = tile.threadResult.get();
            if (result != null) {
                RoadSignFeature.applyPostProcess(tile.config, (class_3218)level, pos, result);
            }
        }
        catch (Exception e) {
            level.method_8650(pos, false);
            Supplementaries.LOGGER.error("Failed to generate road sign at " + pos + ": " + e);
        }
    }

    public void setConfig(RoadSignFeature.Config c) {
        this.config = c;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.config != null) {
            tag.method_10566("config", (class_2520)RoadSignFeature.Config.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.config).getOrThrow(false, s -> {}));
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("config")) {
            this.config = (RoadSignFeature.Config)((Pair)RoadSignFeature.Config.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("config")).getOrThrow(true, s -> {})).getFirst();
        }
    }
}

