/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.NoticeBoardContainerMenu;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CCCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1745;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_4730;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements class_1275,
IMapDisplay,
ITextHolderProvider {
    private final TextHolder textHolder;
    private boolean isWaxed = false;
    private int pageNumber = 0;
    @Nullable
    private UUID playerWhoMayEdit;
    private String text = null;
    private float fontScale = 1.0f;
    private List<class_5481> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;
    private class_4730 cachedPattern = null;
    private boolean isNormalItem = false;

    public NoticeBoardBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.NOTICE_BOARD_TILE.get(), pos, state);
        this.textHolder = new TextHolder(1, 90);
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.notice_board");
    }

    public void updateTileOnInventoryChanged() {
        boolean shouldHaveBook = !this.getDisplayedItem().method_7960();
        class_2680 state = this.method_11010();
        if ((Boolean)state.method_11654((class_2769)class_2741.field_17393) != shouldHaveBook) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_17393, (Comparable)Boolean.valueOf(shouldHaveBook)), 2);
            if (shouldHaveBook) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.85f);
            } else {
                this.pageNumber = 0;
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public class_1799 getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        class_1799 itemstack = this.getDisplayedItem();
        class_1792 item = itemstack.method_7909();
        this.cachedPattern = null;
        if (item instanceof class_1745) {
            class_1745 bannerPatternItem = (class_1745)item;
            this.cachedPattern = ModMaterials.getFlagMaterialForPatternItem(bannerPatternItem);
        }
        this.needsVisualRefresh = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
        this.updateText();
        this.isNormalItem = !NoticeBoardBlockTile.isPageItem(itemstack.method_7909());
    }

    public boolean isNormalItem() {
        return this.isNormalItem;
    }

    public void updateText() {
        class_1799 itemstack = this.getDisplayedItem();
        class_1792 item = itemstack.method_7909();
        class_2487 com = itemstack.method_7969();
        if (item instanceof class_1843 && class_1843.method_8053((class_2487)com) || item instanceof class_1840 && class_1840.method_8047((class_2487)com)) {
            class_2499 pages = com.method_10554("pages", 8).method_10612();
            if (!pages.isEmpty()) {
                if (this.pageNumber >= pages.size()) {
                    this.pageNumber %= pages.size();
                }
                this.text = pages.method_10608(this.pageNumber);
            }
        } else if (CompatHandler.COMPUTERCRAFT && CCCompat.isPrintedBook(item) && com != null) {
            int pages = CCCompat.getPages(itemstack);
            if (this.pageNumber >= pages) {
                this.pageNumber %= pages;
            }
            String[] text = CCCompat.getText(itemstack);
            StringBuilder combined = new StringBuilder();
            for (int i = 0; i < 21; ++i) {
                int ind = this.pageNumber * 21 + i;
                if (ind >= text.length) continue;
                combined.append(text[ind]);
                combined.append(" ");
            }
            this.text = combined.toString();
        }
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.pageNumber = compound.method_10550("PageNumber");
        this.textHolder.load(compound, this.field_11863, this.field_11867);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("PageNumber", this.pageNumber);
        this.textHolder.save(tag);
    }

    public class_1703 method_5465(int id, class_1661 player) {
        return new NoticeBoardContainerMenu(id, player, this);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return this.method_5442() && (CommonConfigs.Building.NOTICE_BOARDS_UNRESTRICTED.get() != false || NoticeBoardBlockTile.isPageItem(stack.method_7909()));
    }

    public static boolean isPageItem(class_1792 item) {
        return item.method_40131().method_40220(class_3489.field_21465) || item instanceof class_1806 || item instanceof class_1745 || CompatHandler.COMPUTERCRAFT && CCCompat.isPrintedBook(item);
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public boolean shouldSkipTileRenderer() {
        return (Boolean)this.method_11010().method_11654((class_2769)NoticeBoardBlock.CULLED) != false || (Boolean)this.method_11010().method_11654((class_2769)NoticeBoardBlock.HAS_BOOK) == false;
    }

    public class_4730 getCachedPattern() {
        return this.cachedPattern;
    }

    public String getText() {
        return this.text;
    }

    public class_1767 getDyeColor() {
        return this.textHolder.getColor();
    }

    public boolean isGlowing() {
        return this.textHolder.hasGlowingText();
    }

    public boolean hasAntiqueInk() {
        return this.textHolder.hasAntiqueInk();
    }

    public TextUtil.RenderProperties computeRenderProperties(int frontLight, Vector3f normal, BooleanSupplier isNear) {
        return this.textHolder.computeRenderProperties(frontLight, normal, isNear);
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<class_5481> l) {
        this.cachedPageLines = l;
    }

    public List<class_5481> getRendererLines() {
        return this.cachedPageLines;
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)NoticeBoardBlock.FACING);
    }

    public void turnPage() {
        ++this.pageNumber;
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 1.45f);
        this.method_5431();
    }

    public class_1269 interact(class_1657 player, class_1268 handIn, class_2338 pos, class_2680 state, class_3965 hit) {
        class_1269 res;
        class_1937 level = player.method_37908();
        if (player.method_5715() && !this.method_5442() && player.method_5998(handIn).method_7960()) {
            class_1799 it = this.method_5441(0);
            class_2338 newPos = pos.method_10081(((class_2350)state.method_11654((class_2769)NoticeBoardBlock.FACING)).method_10163());
            class_1542 drop = new class_1542(level, (double)newPos.method_10263() + 0.5, (double)newPos.method_10264() + 0.5, (double)newPos.method_10260() + 0.5, it);
            drop.method_6988();
            level.method_8649((class_1297)drop);
            this.method_5431();
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (hit.method_17780() == state.method_11654((class_2769)NoticeBoardBlock.FACING) && (res = super.interact(player, handIn)).method_23665()) {
            return res;
        }
        class_1269 r = this.interactWithTextHolder(0, level, pos, state, player, handIn);
        if (r != class_1269.field_5811) {
            return r;
        }
        if (!CommonConfigs.Building.NOTICE_BOARD_GUI.get().booleanValue()) {
            return class_1269.field_5811;
        }
        if (!level.field_9236) {
            this.tryOpeningEditGui((class_3222)player, pos);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @Override
    public void setPlayerWhoMayEdit(@Nullable UUID uuid) {
        this.playerWhoMayEdit = uuid;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    @Override
    public TextHolder getTextHolder(int ind) {
        return this.textHolder;
    }

    public void openScreen(class_1937 level, class_2338 pos, class_1657 player) {
    }

    @Override
    public boolean shouldUseContainerMenu() {
        return true;
    }

    @Override
    public boolean isWaxed() {
        return this.isWaxed;
    }

    @Override
    public void setWaxed(boolean b) {
        this.isWaxed = b;
    }
}

