/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.PresentContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4838;
import org.jetbrains.annotations.Nullable;

public class PresentBlockTile
extends AbstractPresentBlockTile {
    public static final String PUBLIC_KEY = "@e";
    private String recipient = "";
    private String sender = "";
    private String description = "";

    public PresentBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.PRESENT_TILE.get(), pos, state);
    }

    @Override
    public boolean canHoldItems() {
        return this.isPacked();
    }

    public boolean isPacked() {
        return (Boolean)this.method_11010().method_11654((class_2769)PresentBlock.PACKED);
    }

    public String getSender() {
        return this.sender;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecipient() {
        if (this.recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return "";
        }
        return this.recipient;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setPublic() {
        this.setRecipient(PUBLIC_KEY);
    }

    public void updateState(boolean shouldPack, String newRecipient, String sender, String description) {
        if (shouldPack) {
            if (newRecipient.isEmpty()) {
                newRecipient = PUBLIC_KEY;
            }
            this.recipient = newRecipient;
            this.sender = sender;
            this.description = description;
        } else {
            this.recipient = "";
            this.sender = "";
            this.description = "";
        }
        if (!this.field_11863.field_9236 && this.isPacked() != shouldPack) {
            if (shouldPack) {
                this.field_11863.method_8396(null, this.field_11867, ModSounds.PRESENT_PACK.get(), class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.95f);
            } else {
                this.field_11863.method_8396(null, this.field_11867, ModSounds.PRESENT_OPEN.get(), class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 1.2f);
            }
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)PresentBlock.PACKED, (Comparable)Boolean.valueOf(shouldPack)), 3);
        }
    }

    public boolean method_17489(class_1657 player) {
        if (!super.method_17489(player)) {
            return false;
        }
        if (!this.isUnused()) {
            return false;
        }
        if (player.method_7337()) {
            return true;
        }
        return this.recipient.isEmpty() || this.recipient.equalsIgnoreCase(PUBLIC_KEY) || this.recipient.equalsIgnoreCase(player.method_5477().getString()) || this.sender.equalsIgnoreCase(player.method_5477().getString());
    }

    @Override
    public class_1269 interact(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (this.isUnused()) {
            if (this.method_17489(player)) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    PlatHelper.openCustomMenu((class_3222)serverPlayer, (class_3908)this, (class_2338)pos);
                    class_4838.method_24733((class_1657)player, (boolean)true);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
            player.method_7353((class_2561)class_2561.method_43469((String)"message.supplementaries.present.info", (Object[])new Object[]{this.recipient}), true);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"gui.supplementaries.present");
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.recipient = "";
        this.sender = "";
        this.description = "";
        if (tag.method_10545("Recipient")) {
            this.recipient = tag.method_10558("Recipient");
        }
        if (tag.method_10545("Sender")) {
            this.sender = tag.method_10558("Sender");
        }
        if (tag.method_10545("Description")) {
            this.description = tag.method_10558("Description");
        }
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (!this.recipient.isEmpty()) {
            tag.method_10582("Recipient", this.recipient);
        }
        if (!this.sender.isEmpty()) {
            tag.method_10582("Sender", this.sender);
        }
        if (!this.description.isEmpty()) {
            tag.method_10582("Description", this.description);
        }
    }

    @Override
    public class_1703 method_5465(int id, class_1661 player) {
        return new PresentContainerMenu(id, player, this);
    }

    @Nullable
    public class_2561 getSenderMessage() {
        return PresentBlockTile.getSenderMessage(this.sender);
    }

    @Nullable
    public static class_2561 getSenderMessage(String sender) {
        if (sender.isEmpty()) {
            return null;
        }
        return class_2561.method_43469((String)"message.supplementaries.present.from", (Object[])new Object[]{sender});
    }

    @Nullable
    public class_2561 getRecipientMessage() {
        return PresentBlockTile.getRecipientMessage(this.recipient);
    }

    @Nullable
    public static class_2561 getRecipientMessage(String recipient) {
        if (recipient.isEmpty()) {
            return null;
        }
        if (recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return class_2561.method_43471((String)"message.supplementaries.present.public");
        }
        return class_2561.method_43469((String)"message.supplementaries.present.to", (Object[])new Object[]{recipient});
    }
}

