/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.PulleyBlockContainerMenu;
import net.mehvahdjukaar.supplementaries.common.misc.RopeHelper;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_5172;
import org.jetbrains.annotations.Nullable;

public class PulleyBlockTile
extends ItemDisplayTile {
    public PulleyBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.PULLEY_BLOCK_TILE.get(), pos, state);
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public void updateTileOnInventoryChanged() {
        ModBlockProperties.Winding type = PulleyBlockTile.getContentType(this.getDisplayedItem().method_7909());
        class_2680 state = this.method_11010();
        if (state.method_11654(PulleyBlock.TYPE) != type) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657(PulleyBlock.TYPE, (Comparable)((Object)type)));
        }
    }

    public static ModBlockProperties.Winding getContentType(class_1792 item) {
        class_1747 bi;
        ModBlockProperties.Winding type = ModBlockProperties.Winding.NONE;
        if (item instanceof class_1747 && (bi = (class_1747)item).method_7711() instanceof class_5172 || item.method_40131().method_40220(ModTags.CHAINS)) {
            type = ModBlockProperties.Winding.CHAIN;
        } else if (item.method_40131().method_40220(ModTags.ROPES)) {
            type = ModBlockProperties.Winding.ROPE;
        }
        return type;
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"block.supplementaries.pulley_block");
    }

    public class_1703 method_5465(int id, class_1661 player) {
        return new PulleyBlockContainerMenu(id, player, (class_1263)this);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return PulleyBlockTile.getContentType(stack.method_7909()) != ModBlockProperties.Winding.NONE;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public int method_5444() {
        return 64;
    }

    public boolean rotateDirectly(class_2470 rot) {
        if (rot == class_2470.field_11463) {
            return this.pullRopeUp();
        }
        if (rot == class_2470.field_11465) {
            return this.releaseRopeDown();
        }
        return false;
    }

    public boolean pullRopeUp() {
        return this.pullRope(class_2350.field_11033, Integer.MAX_VALUE, true);
    }

    public boolean pullRope(class_2350 moveDir, int maxDist, boolean addItem) {
        class_1799 stack = this.getDisplayedItem();
        boolean addNewItem = false;
        if (stack.method_7960()) {
            class_1792 i = this.field_11863.method_8320(this.field_11867.method_10074()).method_26204().method_8389();
            if (PulleyBlockTile.getContentType(i) == ModBlockProperties.Winding.NONE) {
                return false;
            }
            stack = new class_1799((class_1935)i);
            addNewItem = true;
        }
        if (stack.method_7947() + 1 > stack.method_7914() || !(stack.method_7909() instanceof class_1747)) {
            return false;
        }
        class_2248 ropeBlock = ((class_1747)stack.method_7909()).method_7711();
        boolean success = RopeHelper.removeRope(this.field_11867.method_10093(moveDir), this.field_11863, ropeBlock, moveDir, maxDist);
        if (success) {
            class_2498 soundtype = ropeBlock.method_9564().method_26231();
            this.field_11863.method_8396(null, this.field_11867, soundtype.method_10595(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
            if (addNewItem) {
                this.setDisplayedItem(stack);
            } else if (addItem) {
                stack.method_7933(1);
            }
            this.method_5431();
        }
        return success;
    }

    public boolean releaseRopeDown() {
        return this.releaseRope(class_2350.field_11033, Integer.MAX_VALUE, true);
    }

    public boolean releaseRope(class_2350 dir, int maxDist, boolean removeItem) {
        class_1792 class_17922;
        class_1799 stack = this.getDisplayedItem();
        if (stack.method_7947() < 1 || !((class_17922 = stack.method_7909()) instanceof class_1747)) {
            return false;
        }
        class_1747 bi = (class_1747)class_17922;
        class_2248 ropeBlock = bi.method_7711();
        boolean success = RopeHelper.addRope(this.field_11867.method_10093(dir), this.field_11863, null, class_1268.field_5808, ropeBlock, dir, dir == class_2350.field_11033, maxDist);
        if (success) {
            class_2498 soundtype = ropeBlock.method_9564().method_26231();
            this.field_11863.method_8396(null, this.field_11867, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
            if (removeItem) {
                stack.method_7934(1);
                this.method_5431();
            }
        }
        return success;
    }

    public boolean rotateIndirect(class_1657 player, class_1268 hand, class_2248 ropeBlock, class_2350 moveDir, boolean retracting) {
        class_2350[] class_2350Array;
        class_1799 stack = this.getDisplayedItem();
        if (stack.method_7960()) {
            if (retracting) {
                return false;
            }
            this.setDisplayedItem(new class_1799((class_1935)ropeBlock));
            return true;
        }
        if (!stack.method_31574(ropeBlock.method_8389())) {
            return false;
        }
        class_2680 state = this.method_11010();
        class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)PulleyBlock.field_11459);
        if (axis == moveDir.method_10166()) {
            return false;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_28493((class_2769)PulleyBlock.FLIPPED));
        if (moveDir.method_10166().method_10179()) {
            class_2350[] class_2350Array2 = new class_2350[1];
            class_2350Array = class_2350Array2;
            class_2350Array2[0] = class_2350.field_11033;
        } else {
            class_2350[] class_2350Array3 = new class_2350[3];
            class_2350Array3[0] = moveDir;
            class_2350Array3[1] = moveDir.method_35833(axis);
            class_2350Array = class_2350Array3;
            class_2350Array3[2] = moveDir.method_35834(axis);
        }
        class_2350[] order = class_2350Array;
        ArrayList<class_2350> remaining = new ArrayList<class_2350>();
        int maxSideDist = 7;
        for (class_2350 d : order) {
            if (RopeHelper.isCorrectRope(ropeBlock, this.field_11863.method_8320(this.field_11867.method_10093(d)), d)) {
                return this.moveConnected(retracting, maxSideDist, d);
            }
            remaining.add(d);
        }
        for (class_2350 d : remaining) {
            if (!this.moveConnected(retracting, maxSideDist, d)) continue;
            return true;
        }
        if (retracting) {
            stack.method_7934(1);
            this.method_5431();
            return true;
        }
        return false;
    }

    private boolean moveConnected(boolean retracting, int maxSideDist, class_2350 d) {
        int dist;
        int n = dist = d == class_2350.field_11033 ? Integer.MAX_VALUE : maxSideDist;
        if (retracting) {
            return this.pullRope(d, dist, false);
        }
        return this.releaseRope(d, dist, false);
    }
}

