/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.PlayerSuggestionBoxWidget;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlintBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantMenu;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.AntiqueInkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendLoginPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3419;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ClientReceivers {
    private static void withPlayerDo(Consumer<class_1657> action) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            action.accept((class_1657)player);
        }
    }

    private static void withLevelDo(Consumer<class_1937> action) {
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            action.accept((class_1937)level);
        }
    }

    public static void handlePlaySpeakerMessagePacket(ClientBoundPlaySpeakerMessagePacket message) {
        class_2561 str;
        SpeakerBlockTile.Mode mode = message.mode;
        class_2561 class_25612 = str = class_310.method_1551().method_33883() ? message.filtered : message.message;
        if (mode == SpeakerBlockTile.Mode.NARRATOR && !ClientConfigs.Blocks.SPEAKER_BLOCK_MUTE.get().booleanValue()) {
            class_310.method_1551().method_44713().field_2055.say(str.getString(), true);
        } else if (mode == SpeakerBlockTile.Mode.TITLE) {
            class_329 gui = class_310.method_1551().field_1705;
            gui.method_34003();
            gui.method_1742();
            gui.method_34004(str);
        } else {
            ClientReceivers.withPlayerDo(p -> p.method_7353(str, mode == SpeakerBlockTile.Mode.STATUS_MESSAGE));
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1297 e = l.method_8469(message.id);
            if (e != null) {
                e.method_18799(e.method_18798().method_1031(message.knockbackX, message.knockbackY, message.knockbackZ));
            }
        });
    }

    public static void handleLoginPacket(ClientBoundSendLoginPacket message) {
        ClientReceivers.withPlayerDo(p -> PlayerSuggestionBoxWidget.setUsernameCache(message.usernameCache));
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            switch (message.id) {
                case BUBBLE_BLOW: {
                    ParticleUtil.spawnParticlesOnBlockFaces((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (class_6019)class_6019.method_35017((int)2, (int)4), (float)0.001f, (float)0.01f, (boolean)true);
                    break;
                }
                case BUBBLE_CLEAN: {
                    ParticleUtil.spawnParticleOnBlockShape((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (class_6019)class_6019.method_35017((int)2, (int)4), (float)0.01f);
                    break;
                }
                case WAX_ON: {
                    ParticleUtil.spawnParticleOnBlockShape((class_1937)l, (class_2338)class_2338.method_49638((class_2374)message.pos), (class_2394)class_2398.field_29642, (class_6019)class_6019.method_35017((int)3, (int)5), (float)0.01f);
                    break;
                }
                case BUBBLE_CLEAN_ENTITY: {
                    class_1297 e;
                    if (message.extraData == null || (e = l.method_8469(message.extraData.intValue())) == null) break;
                    ParticleUtil.spawnParticleOnBoundingBox((class_238)e.method_5829(), (class_1937)l, (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (class_6019)class_6019.method_35017((int)2, (int)4), (float)0.01f);
                    break;
                }
                case DISPENSER_MINECART: {
                    boolean j1 = false;
                    boolean j2 = true;
                    boolean k2 = false;
                    double d18 = message.pos.field_1352 + (double)j1 * 0.6;
                    double d24 = message.pos.field_1351 + (double)j2 * 0.6;
                    double d28 = message.pos.field_1350 + (double)k2 * 0.6;
                    for (int i3 = 0; i3 < 10; ++i3) {
                        double d4 = l.field_9229.method_43058() * 0.2 + 0.01;
                        double d6 = d18 + (double)j1 * 0.01 + (l.field_9229.method_43058() - 0.5) * (double)k2 * 0.5;
                        double d8 = d24 + (double)j2 * 0.01 + (l.field_9229.method_43058() - 0.5) * (double)j2 * 0.5;
                        double d30 = d28 + (double)k2 * 0.01 + (l.field_9229.method_43058() - 0.5) * (double)j1 * 0.5;
                        double d9 = (double)j1 * d4 + l.field_9229.method_43059() * 0.01;
                        double d10 = (double)j2 * d4 + l.field_9229.method_43059() * 0.01;
                        double d11 = (double)k2 * d4 + l.field_9229.method_43059() * 0.01;
                        l.method_8406((class_2394)class_2398.field_11251, d6, d8, d30, d9, d10, d11);
                    }
                    break;
                }
                case FLINT_BLOCK_IGNITE: {
                    if (message.extraData == null || message.pos == null) break;
                    boolean isIronMoving = message.extraData == 1;
                    class_2338 pos = class_2338.method_49638((class_2374)message.pos);
                    for (class_2350 ironDir : class_2350.values()) {
                        class_2338 facingPos = pos.method_10093(ironDir);
                        class_2680 facingState = l.method_8320(facingPos);
                        if (!(isIronMoving ? facingState.method_27852(ModRegistry.FLINT_BLOCK.get()) : FlintBlock.canBlockCreateSpark(facingState, l, facingPos, ironDir.method_10153()))) continue;
                        for (int i = 0; i < 6; ++i) {
                            ParticleUtil.spawnParticleOnFace((class_1937)l, (class_2338)facingPos, (class_2350)ironDir.method_10153(), (class_2394)class_2398.field_11205, (float)-0.5f, (float)0.5f, (boolean)false);
                        }
                    }
                    break;
                }
            }
        });
    }

    public static void handleSyncAntiqueInkPacket(ClientBoundSyncAntiqueInk message) {
        ClientReceivers.withLevelDo(l -> {
            class_2586 tile = l.method_8321(message.pos);
            if (tile != null) {
                AntiqueInkHelper.setAntiqueInk(tile, message.ink);
            }
        });
    }

    public static void handlePlaySongNotesPacket(ClientBoundPlaySongNotesPacket message) {
        ClientReceivers.withLevelDo(l -> {
            class_1657 p;
            class_1792 patt7604$temp;
            class_1297 e = l.method_8469(message.entityID);
            if (e instanceof class_1657 && (patt7604$temp = (p = (class_1657)e).method_6030().method_7909()) instanceof InstrumentItem) {
                InstrumentItem instrumentItem = (InstrumentItem)patt7604$temp;
                IntListIterator intListIterator = message.notes.iterator();
                while (intListIterator.hasNext()) {
                    int note = (Integer)intListIterator.next();
                    if (note <= 0) continue;
                    l.method_43128((class_1657)class_310.method_1551().field_1724, p.method_23317(), p.method_23318(), p.method_23321(), instrumentItem.getSound(), class_3419.field_15248, instrumentItem.getVolume(), instrumentItem.getPitch(note));
                    instrumentItem.spawnNoteParticle((class_1937)l, (class_1309)p, note);
                }
            }
        });
    }

    public static void handleSyncTradesPacket(ClientBoundSyncTradesPacket message) {
        ClientReceivers.withPlayerDo(p -> {
            class_1703 container = p.field_7512;
            if (message.containerId == container.field_7763 && container instanceof RedMerchantMenu) {
                RedMerchantMenu containerMenu = (RedMerchantMenu)container;
                containerMenu.setOffers(new class_1916(message.offers.method_8268()));
                containerMenu.setXp(message.villagerXp);
                containerMenu.setMerchantLevel(message.villagerLevel);
                containerMenu.setShowProgressBar(message.showProgress);
                containerMenu.setCanRestock(message.canRestock);
            }
        });
    }
}

