/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2272;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2665;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2745;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class BlockUtil {
    public static <T extends Comparable<T>, A extends class_2769<T>> class_2680 replaceProperty(class_2680 from, class_2680 to, A property) {
        if (from.method_28498(property)) {
            return (class_2680)to.method_11657(property, from.method_11654(property));
        }
        return to;
    }

    public static <T extends class_2586> void addOptionalOwnership(class_1309 placer, T tileEntity) {
        if (CommonConfigs.General.SERVER_PROTECTION.get().booleanValue() && placer instanceof class_1657) {
            ((IOwnerProtected)tileEntity).setOwner(placer.method_5667());
        }
    }

    public static void addOptionalOwnership(class_1309 placer, class_1937 world, class_2338 pos) {
        class_2586 class_25862;
        if (CommonConfigs.General.SERVER_PROTECTION.get().booleanValue() && placer instanceof class_1657 && (class_25862 = world.method_8321(pos)) instanceof IOwnerProtected) {
            IOwnerProtected tile = (IOwnerProtected)class_25862;
            tile.setOwner(placer.method_5667());
        }
    }

    public static Optional<class_2350> tryRotatingBlockAndConnected(class_2350 face, boolean ccw, class_2338 targetPos, class_1937 level, class_243 hit) {
        class_2680 state = level.method_8320(targetPos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)class_22482;
            return rotatable.rotateOverAxis(state, (class_1936)level, targetPos, ccw ? class_2470.field_11465 : class_2470.field_11463, face, hit);
        }
        Optional<class_2350> special = BlockUtil.tryRotatingSpecial(face, ccw, targetPos, level, state, hit);
        if (special.isPresent()) {
            return special;
        }
        Optional<class_2350> ret = BlockUtil.tryRotatingBlock(face, ccw, targetPos, level, state, hit);
        if (ret.isEmpty()) {
            ret = BlockUtil.tryRotatingBlock(class_2350.field_11036, ccw, targetPos, level, level.method_8320(targetPos), hit);
        }
        return ret;
    }

    public static Optional<class_2350> tryRotatingBlock(class_2350 face, boolean ccw, class_2338 targetPos, class_1937 level, class_243 hit) {
        return BlockUtil.tryRotatingBlock(face, ccw, targetPos, level, level.method_8320(targetPos), hit);
    }

    public static Optional<class_2350> tryRotatingBlock(class_2350 dir, boolean ccw, class_2338 targetPos, class_1937 world, class_2680 state, class_243 hit) {
        class_2680 rotated;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)class_22482;
            return rotatable.rotateOverAxis(state, (class_1936)world, targetPos, ccw ? class_2470.field_11465 : class_2470.field_11463, dir, hit);
        }
        Optional<class_2680> optional = BlockUtil.getRotatedState(dir, ccw, targetPos, world, state);
        if (optional.isPresent() && (rotated = optional.get()).method_26184((class_4538)world, targetPos) && (rotated = class_2248.method_9510((class_2680)rotated, (class_1936)world, (class_2338)targetPos)) != state) {
            if (world instanceof class_3218) {
                world.method_8652(targetPos, rotated, 11);
                world.method_41410(rotated, targetPos, rotated.method_26204(), targetPos, false);
            }
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    public static Optional<class_2680> getRotatedState(class_2350 dir, boolean ccw, class_2338 targetPos, class_1937 world, class_2680 state) {
        if (BlockUtil.isBlacklisted(state)) {
            return Optional.empty();
        }
        class_2470 rot = ccw ? class_2470.field_11465 : class_2470.field_11463;
        class_2248 block = state.method_26204();
        if (state.method_28498((class_2769)ModBlockProperties.FLIPPED)) {
            return Optional.of((class_2680)state.method_28493((class_2769)ModBlockProperties.FLIPPED));
        }
        if (dir.method_10166() == class_2350.class_2351.field_11052) {
            int bites;
            if (block == class_2246.field_10183 && (bites = ((Integer)state.method_11654((class_2769)class_2272.field_10739)).intValue()) != 0) {
                return Optional.of(ForgeHelper.rotateBlock((class_2680)((class_2680)ModRegistry.DIRECTIONAL_CAKE.get().method_9564().method_11657((class_2769)class_2272.field_10739, (Comparable)Integer.valueOf(bites))), (class_1937)world, (class_2338)targetPos, (class_2470)rot));
            }
            class_2680 rotated = ForgeHelper.rotateBlock((class_2680)state, (class_1937)world, (class_2338)targetPos, (class_2470)rot);
            if (rotated == state) {
                if (state.method_28498((class_2769)class_2741.field_12525)) {
                    rotated = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
                } else if (state.method_28498((class_2769)class_2741.field_12481)) {
                    rotated = (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
                } else if (state.method_28498((class_2769)class_2465.field_11459)) {
                    rotated = class_2465.method_36377((class_2680)state, (class_2470)rot);
                } else if (state.method_28498((class_2769)class_2741.field_12529)) {
                    rotated = (class_2680)state.method_28493((class_2769)class_2741.field_12529);
                }
            }
            return Optional.of(rotated);
        }
        if (state.method_28498((class_2769)class_2741.field_12555) && state.method_28498((class_2769)class_2741.field_12481)) {
            return Optional.of(BlockUtil.rotateFaceBlockHorizontal(dir, ccw, state));
        }
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            return Optional.of(BlockUtil.rotateBlockStateOnAxis(state, dir, ccw));
        }
        if (state.method_28498((class_2769)class_2741.field_12496)) {
            class_2350.class_2351 targetAxis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
            class_2350.class_2351 myAxis = dir.method_10166();
            if (myAxis == class_2350.class_2351.field_11048) {
                return Optional.of((class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)(targetAxis == class_2350.class_2351.field_11052 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11052)));
            }
            if (myAxis == class_2350.class_2351.field_11051) {
                return Optional.of((class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)(targetAxis == class_2350.class_2351.field_11052 ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052)));
            }
        }
        if (block instanceof class_2510) {
            boolean positive;
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
            if (facing.method_10166() == dir.method_10166()) {
                return Optional.empty();
            }
            boolean flipped = dir.method_10171() == class_2350.class_2352.field_11056 ^ ccw;
            class_2760 half = (class_2760)state.method_11654((class_2769)class_2510.field_11572);
            boolean top = half == class_2760.field_12619;
            boolean bl = positive = facing.method_10171() == class_2350.class_2352.field_11056;
            if (top ^ positive ^ flipped) {
                half = top ? class_2760.field_12617 : class_2760.field_12619;
            } else {
                facing = facing.method_10153();
            }
            return Optional.of((class_2680)((class_2680)state.method_11657((class_2769)class_2510.field_11572, (Comparable)half)).method_11657((class_2769)class_2510.field_11571, (Comparable)facing));
        }
        if (state.method_28498((class_2769)class_2482.field_11501)) {
            class_2771 type = (class_2771)state.method_11654((class_2769)class_2482.field_11501);
            if (type == class_2771.field_12682) {
                return Optional.empty();
            }
            return Optional.of((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)(type == class_2771.field_12681 ? class_2771.field_12679 : class_2771.field_12681)));
        }
        if (state.method_28498((class_2769)class_2533.field_11625)) {
            return Optional.of((class_2680)state.method_28493((class_2769)class_2533.field_11625));
        }
        return Optional.empty();
    }

    private static class_2680 rotateBlockStateOnAxis(class_2680 state, class_2350 axis, boolean ccw) {
        class_243 rotated;
        class_243 targetNormal = MthUtils.V3itoV3((class_2382)((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10163());
        class_243 myNormal = MthUtils.V3itoV3((class_2382)axis.method_10163());
        if (!ccw) {
            targetNormal = targetNormal.method_1021(-1.0);
        }
        if ((rotated = myNormal.method_1036(targetNormal)) != class_243.field_1353) {
            class_2350 newDir = class_2350.method_10142((double)rotated.method_10216(), (double)rotated.method_10214(), (double)rotated.method_10215());
            return (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)newDir);
        }
        return state;
    }

    private static boolean isBlacklisted(class_2680 state) {
        if (state.method_26204() instanceof class_2244) {
            return true;
        }
        if (state.method_28498((class_2769)class_2741.field_12506) && state.method_11654((class_2769)class_2741.field_12506) != class_2745.field_12569) {
            return true;
        }
        if (state.method_28498((class_2769)class_2741.field_12552) && ((Boolean)state.method_11654((class_2769)class_2741.field_12552)).booleanValue()) {
            return true;
        }
        if (state.method_28498((class_2769)class_2741.field_12535)) {
            return true;
        }
        return state.method_26164(ModTags.ROTATION_BLACKLIST);
    }

    private static Optional<class_2350> tryRotatingSpecial(class_2350 face, boolean ccw, class_2338 pos, class_1937 level, class_2680 state, class_243 hit) {
        class_2470 rot;
        class_2248 b = state.method_26204();
        class_2470 class_24702 = rot = ccw ? class_2470.field_11465 : class_2470.field_11463;
        if (state.method_28498((class_2769)class_2741.field_12532)) {
            int r = (Integer)state.method_11654((class_2769)class_2741.field_12532);
            if ((r += ccw ? -1 : 1) < 0) {
                r += 16;
            }
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(r %= 16)), 2);
            return Optional.of(class_2350.field_11036);
        }
        if (state.method_28498((class_2769)class_2741.field_12552) && ((Boolean)state.method_11654((class_2769)class_2741.field_12552)).booleanValue() && state.method_28498((class_2769)class_2671.field_10927)) {
            class_2338 newHeadPos;
            class_2680 newBase = BlockUtil.rotateBlockStateOnAxis(state, face, ccw);
            class_2338 headPos = pos.method_10093((class_2350)state.method_11654((class_2769)class_2671.field_10927));
            if (level.method_8320(headPos).method_28498((class_2769)class_2671.field_12227) && level.method_8320(newHeadPos = pos.method_10093((class_2350)newBase.method_11654((class_2769)class_2671.field_10927))).method_45474()) {
                level.method_8652(newHeadPos, BlockUtil.rotateBlockStateOnAxis(level.method_8320(headPos), face, ccw), 2);
                level.method_8652(pos, newBase, 2);
                level.method_8650(headPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (state.method_28498((class_2769)class_2741.field_12535) && state.method_28498((class_2769)class_2671.field_10927)) {
            class_2338 newHeadPos;
            class_2680 newBase = BlockUtil.rotateBlockStateOnAxis(state, face, ccw);
            class_2338 headPos = pos.method_10093(((class_2350)state.method_11654((class_2769)class_2671.field_10927)).method_10153());
            if (level.method_8320(headPos).method_28498((class_2769)class_2665.field_12191) && level.method_8320(newHeadPos = pos.method_10093(((class_2350)newBase.method_11654((class_2769)class_2671.field_10927)).method_10153())).method_45474()) {
                level.method_8652(newHeadPos, BlockUtil.rotateBlockStateOnAxis(level.method_8320(headPos), face, ccw), 2);
                level.method_8652(pos, newBase, 2);
                level.method_8650(headPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (b instanceof class_2244) {
            class_2680 newBed = ForgeHelper.rotateBlock((class_2680)state, (class_1937)level, (class_2338)pos, (class_2470)rot);
            class_2338 oldPos = pos.method_10093(BlockUtil.getConnectedBedDirection(state));
            class_2338 targetPos = pos.method_10093(BlockUtil.getConnectedBedDirection(newBed));
            if (level.method_8320(targetPos).method_45474()) {
                level.method_8652(targetPos, ForgeHelper.rotateBlock((class_2680)level.method_8320(oldPos), (class_1937)level, (class_2338)oldPos, (class_2470)rot), 2);
                level.method_8652(pos, newBed, 2);
                level.method_8650(oldPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (b instanceof class_2281) {
            if (state.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569) {
                class_2680 newChest = ForgeHelper.rotateBlock((class_2680)state, (class_1937)level, (class_2338)pos, (class_2470)rot);
                class_2338 oldPos = pos.method_10093(class_2281.method_9758((class_2680)state));
                class_2338 targetPos = pos.method_10093(class_2281.method_9758((class_2680)newChest));
                if (level.method_8320(targetPos).method_45474()) {
                    class_2680 connectedNewState = ForgeHelper.rotateBlock((class_2680)level.method_8320(oldPos), (class_1937)level, (class_2338)oldPos, (class_2470)rot);
                    level.method_8652(targetPos, connectedNewState, 2);
                    level.method_8652(pos, newChest, 2);
                    class_2586 tile = level.method_8321(oldPos);
                    if (tile != null) {
                        class_2487 tag = tile.method_38244();
                        class_2586 class_25862 = level.method_8321(targetPos);
                        if (class_25862 instanceof class_2595) {
                            class_2595 newChestTile = (class_2595)class_25862;
                            newChestTile.method_11014(tag);
                        }
                        tile.method_11012();
                    }
                    level.method_8501(oldPos, class_2246.field_10124.method_9564());
                    return Optional.of(face);
                }
            }
            return Optional.empty();
        }
        if (class_2323.method_24796((class_2680)state)) {
            // empty if block
        }
        if (CompatHandler.QUARK && QuarkCompat.tryRotateStool(level, state, pos)) {
            return Optional.of(face);
        }
        return Optional.empty();
    }

    public static class_2350 getConnectedBedDirection(class_2680 bedState) {
        class_2742 part = (class_2742)bedState.method_11654((class_2769)class_2244.field_9967);
        class_2350 dir = (class_2350)bedState.method_11654((class_2769)class_2244.field_11177);
        return part == class_2742.field_12557 ? dir : dir.method_10153();
    }

    private static class_2680 rotateFaceBlockHorizontal(class_2350 dir, boolean ccw, class_2680 original) {
        class_2350 facingDir = (class_2350)original.method_11654((class_2769)class_2741.field_12481);
        if (facingDir.method_10166() == dir.method_10166()) {
            return original;
        }
        class_2738 face = (class_2738)original.method_11654((class_2769)class_2741.field_12555);
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2738.field_12475 -> (class_2680)((class_2680)original.method_11657((class_2769)class_2741.field_12555, (Comparable)class_2738.field_12471)).method_11657((class_2769)class_2741.field_12481, (Comparable)(ccw ? dir.method_10170() : dir.method_10160()));
            case class_2738.field_12473 -> (class_2680)((class_2680)original.method_11657((class_2769)class_2741.field_12555, (Comparable)class_2738.field_12471)).method_11657((class_2769)class_2741.field_12481, (Comparable)(!ccw ? dir.method_10170() : dir.method_10160()));
            case class_2738.field_12471 -> (class_2680)original.method_11657((class_2769)class_2741.field_12555, (Comparable)(facingDir.method_10171() == class_2350.class_2352.field_11056 ^ (ccw ^= dir.method_10171() != class_2350.class_2352.field_11056) ? class_2738.field_12473 : class_2738.field_12475));
        };
    }
}

