/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonParser;
import java.util.List;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.ImageTransformer;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.ClientSpecialModelsManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.misc.CakeRegistry;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_799;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(class_3300 manager) {
        Object respriter;
        TextureImage template;
        ClientSpecialModelsManager.refreshModels(manager);
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
        ((DynamicTexturePack)this.dynamicPack).addItemModel(new class_2960("crossbow_arrow"), JsonParser.parseString((String)"{\n    \"parent\": \"item/crossbow\",\n    \"textures\": {\n        \"layer0\": \"item/crossbow_arrow_base\",\n        \"layer1\": \"item/crossbow_arrow_tip\"\n    }\n}\n"));
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)new class_2960("crossbow"), e -> e.add(new class_799(new class_2960("item/crossbow_rope_arrow"), List.of(new class_799.class_5826(new class_2960("charged"), 1.0f), new class_799.class_5826(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)new class_2960("written_book"), e -> e.add(new class_799(new class_2960("item/written_book_tattered"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
            RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)new class_2960("filled_map"), e -> e.add(new class_799(new class_2960("item/antique_map"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
        }
        RPUtils.appendModelOverride((class_3300)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (class_2960)Supplementaries.res("globe"), e -> {
            int i = 0;
            for (class_2960 text : GlobeManager.Type.textures) {
                String name = text.method_12832().split("/")[3].split("\\.")[0];
                e.add(new class_799(Supplementaries.res("item/" + name), List.of(new class_799.class_5826(Supplementaries.res("type"), (float)i))));
                ++i;
                ((DynamicTexturePack)this.dynamicPack).addItemModel(Supplementaries.res(name), JsonParser.parseString((String)("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"supplementaries:item/globes/" + name + "\"    }\n}\n")));
            }
        });
        StaticResource spItemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Supplementaries.res("sign_post_oak")));
        StaticResource spBlockModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Supplementaries.res("sign_posts/sign_post_oak")));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((class_1792)sign).method_12832();
            try {
                this.addSimilarJsonResource(manager, spItemModel, "sign_post_oak", id);
                this.addSimilarJsonResource(manager, spBlockModel, "sign_post_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)sign, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/sign_posts/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((arg_0, arg_1) -> this.lambda$regenerateDynamicAssets$5(manager, (Respriter)respriter, arg_0, arg_1));
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("block/sign_posts/sign_post_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((arg_0, arg_1) -> this.lambda$regenerateDynamicAssets$6(manager, (Respriter)respriter, arg_0, arg_1));
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
        ImageTransformer transformer = ImageTransformer.builder((int)32, (int)64, (int)16, (int)16).copyRect(26, 0, 2, 4, 4, 0).copyRect(26, 8, 6, 8, 4, 4).copyRect(28, 24, 4, 8, 0, 4).copyRect(26, 20, 2, 4, 6, 0).copyRect(26, 28, 1, 8, 11, 4).copyRect(27, 28, 1, 8, 10, 4).build();
        for (WoodType w : WoodTypeRegistry.getTypes()) {
            try {
                TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)class_4722.method_45781((class_4719)w.toVanilla()).method_24147());
                try {
                    TextureImage flipped = vanillaTexture.createRotated(class_2470.field_11463);
                    TextureImage newIm = flipped.createResized(0.5f, 0.25f);
                    newIm.clear();
                    transformer.apply(flipped, newIm);
                    flipped.close();
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/signs/hanging/" + w.getVariantId("extension")), newIm);
                }
                finally {
                    if (vanillaTexture == null) continue;
                    vanillaTexture.close();
                }
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.warn("Failed to generate hanging sign extension texture for {}. Could be that the target mod isnt registering their wood type properly", (Object)w, (Object)e2);
            }
        }
        if (CompatHandler.FARMERS_DELIGHT) {
            try (TextureImage vanillaTexture = TextureImage.open((class_3300)manager, (class_2960)new class_2960("farmersdelight:entity/signs/hanging/canvas"));){
                TextureImage flipped = vanillaTexture.createRotated(class_2470.field_11463);
                TextureImage newIm = flipped.createResized(0.5f, 0.25f);
                newIm.clear();
                transformer.apply(flipped, newIm);
                flipped.close();
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/signs/hanging/farmersdelight/extension_canvas"), newIm);
            }
            catch (Exception e3) {
                Supplementaries.LOGGER.warn("Failed to generate hanging sign extension texture for {}, ", (Object)"canvas sign", (Object)e3);
            }
        }
        StaticResource[] cakeModels = (StaticResource[])Stream.of("full", "slice1", "slice2", "slice3", "slice4", "slice5", "slice6").map(s -> StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Supplementaries.res("double_cake/vanilla_" + s)))).toArray(StaticResource[]::new);
        StaticResource doubleCakeModelState = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.BLOCKSTATES.getPath(Supplementaries.res("double_cake")));
        for (CakeRegistry.CakeType t : CakeRegistry.INSTANCE.getValues()) {
            if (t.isVanilla()) continue;
            try {
                class_2960 dcId = Utils.getID((class_2248)t.getBlockOfThis("double_cake"));
                class_2960 top = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("top"));
                class_2960 side = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("side"));
                class_2960 bottom = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("bottom"));
                class_2960 inner = RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)t.cake, s -> s.contains("inner"));
                for (StaticResource m : cakeModels) {
                    this.addSimilarJsonResource(manager, m, s -> s.replace("supplementaries:block/double_cake", "").replace("supplementaries:block/cake", "").replace("\"/", "\"supplementaries:block/double_cake/").replace("_top", top.toString()).replace("_side", side.toString()).replace("_inner", inner.toString()).replace("_bottom", bottom.toString()), s -> s.replace("vanilla", dcId.method_12832()));
                }
                this.addSimilarJsonResource(manager, doubleCakeModelState, s -> s.replace("vanilla", dcId.method_12832()), s -> s.replace("double_cake", dcId.method_12832()));
            }
            catch (Exception e4) {
                Supplementaries.LOGGER.error("Failed to generate model for double cake {},", (Object)t, (Object)e4);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static TextureImage recolorFromVanilla(class_3300 manager, TextureImage vanillaTexture, class_2960 vanillaMask, class_2960 templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((class_3300)manager, (class_2960)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((class_3300)manager, (class_2960)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.SIGN_POST_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.sign_post", (BlockType)type, (class_1792)item));
    }

    private /* synthetic */ void lambda$regenerateDynamicAssets$6(class_3300 manager, Respriter respriter, WoodType wood, SignPostItem sign) {
        class_2960 textureRes = Supplementaries.res("block/sign_posts/" + Utils.getID((class_1792)sign).method_12832());
        if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
            return;
        }
        try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
            Palette palette = Palette.fromImage((TextureImage)plankTexture);
            TextureImage newImage = respriter.recolor(palette);
            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
        }
        catch (Exception ex) {
            this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
        }
    }

    private /* synthetic */ void lambda$regenerateDynamicAssets$5(class_3300 manager, Respriter respriter, WoodType wood, SignPostItem sign) {
        class_2960 textureRes = Supplementaries.res("item/sign_posts/" + Utils.getID((class_1792)sign).method_12832());
        if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
            return;
        }
        TextureImage newImage = null;
        class_1792 signItem = wood.getItemOfThis("sign");
        if (signItem != null) {
            try (TextureImage vanillaSign2 = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)signItem));
                 TextureImage signMask = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/hanging_signs/sign_board_mask"));){
                List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                newImage = respriter.recolor(targetPalette);
                try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign2, Supplementaries.res("item/hanging_signs/sign_scribbles_mask"), Supplementaries.res("item/sign_posts/scribbles_template"));){
                    newImage.applyOverlay(new TextureImage[]{scribbles});
                }
                catch (Exception ex) {
                    this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                }
            }
            catch (Exception vanillaSign2) {
                // empty catch block
            }
        }
        if (newImage == null) {
            try (TextureImage plankPalette = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                newImage = respriter.recolor(targetPalette);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
            }
        }
        if (newImage != null) {
            ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
        }
    }
}

