/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat;

import ad_astra_giselle_addon.common.compat.CompatibleManagerDelegate;
import ad_astra_giselle_addon.common.compat.CompatibleMod;
import ad_astra_giselle_addon.common.compat.JeiCompat;
import ad_astra_giselle_addon.common.compat.ReiCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompatibleManager {
    private static final Delegate DELEGATE = new CompatibleManagerDelegate();
    public static final List<CompatibleMod> COMMON_MODS;
    public static final JeiCompat JEI;
    public static final ReiCompat REI;
    public final List<CompatibleMod> all_mods;
    public final List<CompatibleMod> loaded_mods;

    public CompatibleManager() {
        ArrayList<CompatibleMod> mods = new ArrayList<CompatibleMod>();
        mods.addAll(COMMON_MODS);
        mods.addAll(DELEGATE.getMods());
        this.all_mods = Collections.unmodifiableList(mods);
        this.all_mods.forEach(CompatibleMod::tryLoad);
        this.loaded_mods = this.all_mods.stream().filter(CompatibleMod::isLoaded).toList();
    }

    static {
        ArrayList<CompatibleMod> mods = new ArrayList<CompatibleMod>();
        JEI = new JeiCompat();
        mods.add(JEI);
        REI = new ReiCompat();
        mods.add(REI);
        COMMON_MODS = Collections.unmodifiableList(mods);
    }

    public static interface Delegate {
        public List<CompatibleMod> getMods();
    }
}

