/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.enchantment;

import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class EnchantmentHelper2 {
    private static final Map<class_1887, String> DESCRIPTION_KEYS = new HashMap<class_1887, String>();
    private static final Map<class_1887, class_2561> DESCRIPTION_TEXTS = new HashMap<class_1887, class_2561>();
    private static final Map<class_1887, List<? extends class_2561>> DESCRIPTION_TEXTS_MULTILINES = new HashMap<class_1887, List<? extends class_2561>>();
    private static final List<String> DESCRIPTION_SUFFIXES = Lists.newArrayList((Object[])new String[]{"desc", "description"});

    public static List<String> getDescriptionSuffixes() {
        return Collections.unmodifiableList(DESCRIPTION_SUFFIXES);
    }

    public static boolean addDescriptionSuffix(String suffix) {
        return DESCRIPTION_SUFFIXES.add(suffix);
    }

    public static String getDescriptionKey(class_1887 enchantment) {
        return DESCRIPTION_KEYS.computeIfAbsent(enchantment, e -> {
            String descriptionId = e.method_8184();
            for (String suffix : DESCRIPTION_SUFFIXES) {
                String key = descriptionId + "." + suffix;
                if (!class_1074.method_4663((String)key)) continue;
                return key;
            }
            return descriptionId + DESCRIPTION_SUFFIXES.get(0);
        });
    }

    public static class_2561 getDescriptionText(class_1887 enchantment) {
        return DESCRIPTION_TEXTS.computeIfAbsent(enchantment, e -> class_2561.method_43471((String)EnchantmentHelper2.getDescriptionKey(enchantment)).method_27692(class_124.field_1065));
    }

    public static void clearDescriptionsCache() {
        DESCRIPTION_TEXTS_MULTILINES.clear();
    }

    public static List<? extends class_2561> getDescriptionTexts(class_1887 enchantment) {
        return DESCRIPTION_TEXTS_MULTILINES.computeIfAbsent(enchantment, e -> Arrays.stream(class_2561.method_43471((String)EnchantmentHelper2.getDescriptionKey(enchantment)).getString().split("\n")).map(class_2561::method_43470).map(s -> s.method_27692(class_124.field_1065)).toList());
    }

    @NotNull
    public static Pair<ItemStackReference, Integer> getEnchantmentItemAndLevel(class_1887 enchantment, class_1309 living) {
        Map map = enchantment.method_8185(living);
        class_1304 slot = null;
        int level = 0;
        for (Map.Entry pair : map.entrySet()) {
            int i = class_1890.method_8225((class_1887)enchantment, (class_1799)((class_1799)pair.getValue()));
            if (i <= level) continue;
            slot = (class_1304)pair.getKey();
            level = i;
        }
        if (slot != null) {
            return Pair.of((Object)((Object)new ItemStackReference(living.method_6118(slot), ItemStackConsumers.equipment(slot, (arg_0, arg_1) -> ((class_1309)living).method_5673(arg_0, arg_1)))), (Object)level);
        }
        return Pair.of(null, (Object)level);
    }

    private EnchantmentHelper2() {
    }
}

