/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidHandler;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidItemHandler;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public abstract class UniveralFluidHandler
implements PlatformFluidHandler {
    private UniveralFluidHandler() {
    }

    public boolean supportsInsertion() {
        return true;
    }

    public boolean supportsExtraction() {
        return true;
    }

    @Nullable
    public static Optional<UniveralFluidHandler> fromSafe(ItemStackHolder item) {
        if (FluidHooks.isFluidContainingItem((class_1799)item.getStack())) {
            return Optional.of(new UniveralFluidItemHandler(item));
        }
        return Optional.empty();
    }

    public static UniveralFluidHandler from(ItemStackHolder item) {
        return new UniveralFluidItemHandler(item);
    }

    @Nullable
    public static Optional<UniveralFluidHandler> fromSafe(class_2586 blockEntity, @Nullable class_2350 direction) {
        if (FluidHooks.isFluidContainingBlock((class_2586)blockEntity, (class_2350)direction)) {
            return Optional.of(new UniveralFluidBlockHandler(blockEntity, direction));
        }
        return Optional.empty();
    }

    public static UniveralFluidHandler from(class_2586 blockEntity, @Nullable class_2350 direction) {
        return new UniveralFluidBlockHandler(blockEntity, direction);
    }

    public static UniveralFluidHandler from(FluidContainer container) {
        return new UniveralFluidContainerHandler(container);
    }

    public static class UniveralFluidItemHandler
    extends UniveralFluidHandler {
        private final ItemStackHolder item;

        public UniveralFluidItemHandler(ItemStackHolder item) {
            this.item = item;
        }

        private ItemStackHolder getItem(boolean simulate) {
            if (simulate) {
                return new ItemStackHolder(this.item.getStack().method_7972());
            }
            return this.item;
        }

        private PlatformFluidItemHandler getInternalHandler() {
            return FluidHooks.getItemFluidManager((class_1799)this.getItem(false).getStack());
        }

        public long insertFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().insertFluid(this.getItem(simulate), fluid, simulate);
        }

        public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().extractFluid(this.getItem(simulate), fluid, simulate);
        }

        public int getTankAmount() {
            return this.getInternalHandler().getTankAmount();
        }

        public FluidHolder getFluidInTank(int tank) {
            return this.getInternalHandler().getFluidInTank(tank);
        }

        public List<FluidHolder> getFluidTanks() {
            ArrayList<FluidHolder> list = new ArrayList<FluidHolder>();
            for (int i = 0; i < this.getTankAmount(); ++i) {
                list.add(this.getFluidInTank(i));
            }
            return list;
        }

        public long getTankCapacity(int tank) {
            return this.getInternalHandler().getTankCapacity(tank);
        }
    }

    public static class UniveralFluidBlockHandler
    extends UniveralFluidHandler {
        private final class_2586 blockEntity;
        private final class_2350 direction;

        public UniveralFluidBlockHandler(class_2586 blockEntity, @Nullable class_2350 direction) {
            this.blockEntity = blockEntity;
            this.direction = direction;
        }

        public class_2586 getBlockEntity() {
            return this.blockEntity;
        }

        public class_2350 getDirection() {
            return this.direction;
        }

        public PlatformFluidHandler getInternalHandler() {
            return FluidHooks.getBlockFluidManager((class_2586)this.getBlockEntity(), (class_2350)this.getDirection());
        }

        public long insertFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().insertFluid(fluid, simulate);
        }

        public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
            return this.getInternalHandler().extractFluid(fluid, simulate);
        }

        public int getTankAmount() {
            return this.getInternalHandler().getTankAmount();
        }

        public FluidHolder getFluidInTank(int tank) {
            return this.getInternalHandler().getFluidInTank(tank);
        }

        public List<FluidHolder> getFluidTanks() {
            ArrayList<FluidHolder> list = new ArrayList<FluidHolder>();
            for (int i = 0; i < this.getTankAmount(); ++i) {
                list.add(this.getFluidInTank(i));
            }
            return list;
        }

        public long getTankCapacity(int tank) {
            return this.getInternalHandler().getTankCapacity(tank);
        }
    }

    public static class UniveralFluidContainerHandler
    extends UniveralFluidHandler {
        private final FluidContainer container;

        public UniveralFluidContainerHandler(FluidContainer container) {
            this.container = container;
        }

        public FluidContainer getContainer() {
            return this.container;
        }

        public long insertFluid(FluidHolder fluid, boolean simulate) {
            return this.getContainer().insertFluid(fluid, simulate);
        }

        public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
            return this.getContainer().extractFluid(fluid, simulate);
        }

        public int getTankAmount() {
            return this.getContainer().getSize();
        }

        public FluidHolder getFluidInTank(int tank) {
            return this.getFluidTanks().get(tank);
        }

        public List<FluidHolder> getFluidTanks() {
            return this.getContainer().getFluids();
        }

        public long getTankCapacity(int tank) {
            return this.getContainer().getTankCapacity(tank);
        }
    }
}

