/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteHelper;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockData;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class ConnectingBakedModel
extends WrappedBakedModel {
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = ConnectingBakedModel.findUVOffset(class_290.field_1590);
    private final class_4590 modelRotation;
    private final List<ConnectionPredicate> predicates;
    private final Map<class_2350, Map<Integer, List<class_777>>> quadCache = new HashMap<class_2350, Map<Integer, List<class_777>>>();
    private final Map<Integer, List<class_777>> directionlessQuadCache = new HashMap<Integer, List<class_777>>();
    private final ThreadLocal<Pair<class_1920, class_2338>> levelCapture = new ThreadLocal();

    public ConnectingBakedModel(class_1087 original, class_4590 modelRotation, List<ConnectionPredicate> predicates) {
        super(original);
        this.modelRotation = modelRotation;
        this.predicates = predicates;
        for (class_2350 direction : class_2350.values()) {
            this.quadCache.put(direction, new HashMap());
        }
    }

    @Override
    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.levelCapture.set(Pair.of(blockView, pos));
        context.bakedModelConsumer().accept((class_1087)this, state);
        this.levelCapture.set(null);
    }

    @Override
    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.bakedModelConsumer().accept((class_1087)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 random) {
        List<class_777> quads;
        Map<Integer, List<class_777>> cache;
        SurroundingBlockData data = this.levelCapture.get() == null ? null : this.getModelData(this.levelCapture.get().left(), this.levelCapture.get().right(), state);
        int hashCode = data == null ? 0 : data.hashCode();
        Map<Integer, List<class_777>> map = cache = side == null ? this.directionlessQuadCache : this.quadCache.get(side);
        synchronized (map) {
            quads = cache.get(hashCode);
        }
        if (quads == null) {
            quads = this.remapQuads(this.original.method_4707(state, side, random), data);
            map = cache;
            synchronized (map) {
                if (!cache.containsKey(hashCode)) {
                    cache.put(hashCode, quads);
                } else {
                    quads = cache.get(hashCode);
                }
            }
        }
        if (quads == null) {
            throw new IllegalStateException("Tried returning null list from ConnectingBakedModel#getQuads for side '" + side + "'!");
        }
        return quads;
    }

    private List<class_777> remapQuads(List<class_777> originalQuads, SurroundingBlockData surroundingBlocks) {
        if (surroundingBlocks == null) {
            return originalQuads;
        }
        return originalQuads.stream().map(quad -> this.remapQuad((class_777)quad, surroundingBlocks)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected class_777 remapQuad(class_777 quad, SurroundingBlockData surroundingBlocks) {
        class_1058 sprite = quad.method_35788();
        if (SpriteHelper.getTextureType(sprite) != DefaultTextureTypes.CONNECTING) {
            return quad;
        }
        ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).getLayout();
        int[] vertexData = quad.method_3357();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        SurroundingBlockData.SideConnections connections = surroundingBlocks.getConnections(quad.method_3358());
        int[] uv = ConnectingTextureType.getStatePosition(layout, connections.top, connections.topRight, connections.right, connections.bottomRight, connections.bottom, connections.bottomLeft, connections.left, connections.topLeft);
        ConnectingBakedModel.adjustVertexDataUV(vertexData, uv[0], uv[1], sprite);
        return new class_777(vertexData, quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, class_1058 sprite) {
        int vertexSize = class_290.field_1590.method_1359();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.method_4577() - sprite.method_4594();
            float u = Float.intBitsToFloat(vertexData[offset]) + width * (float)newU;
            vertexData[offset] = Float.floatToRawIntBits(u);
            float height = sprite.method_4575() - sprite.method_4593();
            float v = Float.intBitsToFloat(vertexData[offset + 1]) + height * (float)newV;
            vertexData[offset + 1] = Float.floatToRawIntBits(v);
        }
        return vertexData;
    }

    private static int findUVOffset(class_293 vertexFormat) {
        int index;
        class_296 element = null;
        for (index = 0; index < vertexFormat.method_1357().size(); ++index) {
            class_296 el = (class_296)vertexFormat.method_1357().get(index);
            if (el.method_1382() != class_296.class_298.field_1636) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.method_1357().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a UV attribute");
        }
        if (element.method_1386() != class_296.class_297.field_1623) {
            throw new RuntimeException("Expected UV attribute to have data type FLOAT");
        }
        if (element.method_1387() < 4) {
            throw new RuntimeException("Expected UV attribute to have at least 4 dimensions");
        }
        return vertexFormat.field_1597.getInt(index);
    }

    public SurroundingBlockData getModelData(class_1920 level, class_2338 pos, class_2680 state) {
        return SurroundingBlockData.create(level, pos, this.modelRotation, this.predicates);
    }

    @Override
    public boolean isVanillaAdapter() {
        return false;
    }

    @Override
    public boolean method_4713() {
        return super.method_4713();
    }

    @Override
    public class_809 method_4709() {
        return super.method_4709();
    }

    @Override
    public class_806 method_4710() {
        return class_806.field_4292;
    }
}

