/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.block;

import com.google.common.collect.ImmutableList;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import wraith.alloyforgery.AlloyForgeScreenHandler;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.block.ForgeControllerBlock;
import wraith.alloyforgery.forges.ForgeDefinition;
import wraith.alloyforgery.forges.ForgeFuelRegistry;
import wraith.alloyforgery.forges.ForgeRegistry;
import wraith.alloyforgery.mixin.HopperBlockEntityAccessor;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class ForgeControllerBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278,
class_3908,
InsertionOnlyStorage<FluidVariant> {
    private static final int[] DOWN_SLOTS = new int[]{10, 11};
    private static final int[] RIGHT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] LEFT_SLOTS = new int[]{11};
    public static final int INVENTORY_SIZE = 12;
    private final class_2371<class_1799> items = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    private final FluidHolder fluidHolder = new FluidHolder();
    private final ForgeDefinition forgeDefinition;
    private final ImmutableList<class_2338> multiblockPositions;
    private final class_2350 facing;
    private float fuel;
    private int currentSmeltTime;
    private int smeltProgress;
    private int fuelProgress;
    private int lavaProgress;
    private final class_3913 properties = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ForgeControllerBlockEntity.this.smeltProgress;
                case 1 -> ForgeControllerBlockEntity.this.fuelProgress;
                default -> ForgeControllerBlockEntity.this.lavaProgress;
            };
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return 3;
        }
    };

    public ForgeControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(AlloyForgery.FORGE_CONTROLLER_BLOCK_ENTITY, pos, state);
        this.forgeDefinition = ((ForgeControllerBlock)state.method_26204()).forgeDefinition;
        this.facing = (class_2350)state.method_11654((class_2769)ForgeControllerBlock.FACING);
        this.multiblockPositions = ForgeControllerBlockEntity.generateMultiblockPositions(pos.method_10062(), (class_2350)state.method_11654((class_2769)ForgeControllerBlock.FACING));
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.items);
        this.currentSmeltTime = nbt.method_10550("CurrentSmeltTime");
        this.fuel = nbt.method_10550("Fuel");
        class_2487 fluidNbt = nbt.method_10562("FuelFluidInput");
        this.fluidHolder.amount = fluidNbt.method_10537("Amount");
        this.fluidHolder.variant = FluidVariant.fromNbt((class_2487)nbt.method_10562("Variant"));
    }

    public void method_11007(class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.items);
        nbt.method_10569("Fuel", Math.round(this.fuel));
        nbt.method_10569("CurrentSmeltTime", this.currentSmeltTime);
        class_2487 fluidNbt = new class_2487();
        fluidNbt.method_10544("Amount", this.fluidHolder.amount);
        fluidNbt.method_10566("Variant", (class_2520)((FluidVariant)this.fluidHolder.variant).toNbt());
        nbt.method_10566("FuelFluidInput", (class_2520)fluidNbt);
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public class_1799 getFuelStack() {
        return this.method_5438(11);
    }

    public boolean canAddFuel(int fuel) {
        return this.fuel + (float)fuel <= (float)this.forgeDefinition.fuelCapacity();
    }

    public void addFuel(int fuel) {
        this.fuel += (float)fuel;
    }

    public int getSmeltProgress() {
        return this.smeltProgress;
    }

    public int getCurrentSmeltTime() {
        return this.currentSmeltTime;
    }

    public void tick() {
        class_1799 fuelStack;
        ForgeFuelRegistry.ForgeFuelDefinition fuelDefinition;
        this.smeltProgress = Math.round((float)this.currentSmeltTime / (float)this.forgeDefinition.maxSmeltTime() * 19.0f);
        this.fuelProgress = Math.round(this.fuel / (float)this.forgeDefinition.fuelCapacity() * 48.0f);
        this.lavaProgress = Math.round((float)this.fluidHolder.getAmount() / 81000.0f * 50.0f);
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        if (!this.verifyMultiblock()) {
            this.currentSmeltTime = 0;
            class_2680 currentState = this.field_11863.method_8320(this.field_11867);
            if (((Boolean)currentState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
                this.field_11863.method_8501(this.field_11867, (class_2680)currentState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
            return;
        }
        if (!this.getFuelStack().method_7960() && (fuelDefinition = ForgeFuelRegistry.getFuelForItem((fuelStack = this.getFuelStack()).method_7909())) != ForgeFuelRegistry.ForgeFuelDefinition.EMPTY && this.canAddFuel(fuelDefinition.fuel())) {
            if (!ItemOps.emptyAwareDecrement((class_1799)this.getFuelStack())) {
                this.method_5447(11, fuelDefinition.hasReturnType() ? new class_1799((class_1935)fuelDefinition.returnType()) : class_1799.field_8037);
            }
            this.fuel += (float)fuelDefinition.fuel();
        }
        if (this.fluidHolder.amount >= 81L) {
            float fuelInsertAmount = Math.min((float)this.fluidHolder.amount / 81.0f * 24.0f, ((float)this.forgeDefinition.fuelCapacity() - this.fuel) / 24.0f * 24.0f);
            this.fuel += fuelInsertAmount;
            this.fluidHolder.amount = (long)((float)this.fluidHolder.amount - fuelInsertAmount / 24.0f * 81.0f);
        }
        class_2680 currentBlockState = this.field_11863.method_8320(this.field_11867);
        if (this.fuel > 100.0f && !((Boolean)currentBlockState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)currentBlockState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (this.fuel < 100.0f && ((Boolean)currentBlockState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)currentBlockState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (!this.method_5442()) {
            Optional recipeOptional = this.field_11863.method_8433().method_8132((class_3956)AlloyForgeRecipe.Type.INSTANCE, (class_1263)this, this.field_11863);
            if (recipeOptional.isEmpty()) {
                this.currentSmeltTime = 0;
            } else {
                AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeOptional.get();
                if (recipe.getMinForgeTier() > this.forgeDefinition.forgeTier()) {
                    this.currentSmeltTime = 0;
                    return;
                }
                class_1799 outputStack = this.method_5438(10);
                class_1799 recipeOutput = recipe.getOutput(this.forgeDefinition.forgeTier());
                if (!outputStack.method_7960() && !ItemOps.canStack((class_1799)outputStack, (class_1799)recipeOutput)) {
                    this.currentSmeltTime = 0;
                    return;
                }
                if (this.currentSmeltTime < this.forgeDefinition.maxSmeltTime()) {
                    float fuelRequirement = (float)recipe.getFuelPerTick() * this.forgeDefinition.speedMultiplier();
                    if (this.fuel - fuelRequirement < 0.0f) {
                        this.currentSmeltTime = 0;
                        return;
                    }
                    ++this.currentSmeltTime;
                    this.fuel -= fuelRequirement;
                    if (this.field_11863.field_9229.method_43058() > 0.75) {
                        AlloyForgery.FORGE_PARTICLES.spawn(this.field_11863, class_243.method_24954((class_2382)this.field_11867), (Object)this.facing);
                    }
                } else {
                    class_2371<class_1799> remainderList = recipe.gatherRemainders((class_1263)this);
                    recipe.method_8116((class_1263)this, this.field_11863.method_30349());
                    if (remainderList != null) {
                        this.handleForgingRemainders(remainderList);
                    }
                    if (outputStack.method_7960()) {
                        this.method_5447(10, recipeOutput);
                    } else {
                        outputStack.method_7933(recipeOutput.method_7947());
                    }
                    this.currentSmeltTime = 0;
                }
            }
        } else {
            this.currentSmeltTime = 0;
        }
    }

    private void handleForgingRemainders(class_2371<class_1799> remainderList) {
        for (int i = 0; i < remainderList.size(); ++i) {
            class_1799 inputStack = this.method_5438(i);
            class_1799 remainderStack = (class_1799)remainderList.get(i);
            if (remainderStack.method_7960()) continue;
            if (inputStack.method_7960()) {
                this.method_5447(i, remainderStack);
                continue;
            }
            if (class_1799.method_7984((class_1799)inputStack, (class_1799)remainderStack) && class_1799.method_7973((class_1799)inputStack, (class_1799)remainderStack)) {
                remainderStack.method_7933(inputStack.method_7947());
                if (remainderStack.method_7947() > remainderStack.method_7914()) {
                    int excess = remainderStack.method_7947() - remainderStack.method_7914();
                    remainderStack.method_7934(excess);
                    class_1799 insertStack = remainderStack.method_7972();
                    insertStack.method_7939(excess);
                    if (!this.attemptToInsertIntoHopper(insertStack)) {
                        class_2338 frontForgePos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)ForgeControllerBlock.FACING));
                        this.field_11863.method_43128(null, (double)frontForgePos.method_10263(), (double)frontForgePos.method_10264(), (double)frontForgePos.method_10260(), class_3417.field_15197, class_3419.field_15245, 1.0f, 0.2f);
                        class_1264.method_5449((class_1937)this.field_11863, (double)frontForgePos.method_10263(), (double)frontForgePos.method_10264(), (double)frontForgePos.method_10260(), (class_1799)insertStack);
                    }
                }
                this.method_5447(i, remainderStack);
                continue;
            }
            if (this.attemptToInsertIntoHopper(remainderStack)) continue;
            class_2338 frontForgePos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)ForgeControllerBlock.FACING));
            this.field_11863.method_43128(null, (double)frontForgePos.method_10263(), (double)frontForgePos.method_10264(), (double)frontForgePos.method_10260(), class_3417.field_15197, class_3419.field_15245, 1.0f, 0.2f);
            class_1264.method_5449((class_1937)this.field_11863, (double)frontForgePos.method_10263(), (double)frontForgePos.method_10264(), (double)frontForgePos.method_10260(), (class_1799)remainderStack);
        }
    }

    private boolean attemptToInsertIntoHopper(class_1799 remainderStack) {
        if (remainderStack.method_7960()) {
            return true;
        }
        class_2614 blockEntity = null;
        for (int y = 1; y <= 2; ++y) {
            class_2614 hopperBlockEntity;
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10087(y));
            if (!(class_25862 instanceof class_2614)) continue;
            blockEntity = hopperBlockEntity = (class_2614)class_25862;
            break;
        }
        if (blockEntity != null) {
            boolean isHopperEmpty = blockEntity.method_5442();
            for (int slotIndex = 0; slotIndex < blockEntity.method_5439() && !remainderStack.method_7960(); ++slotIndex) {
                if (!blockEntity.method_5438(slotIndex).method_7960()) {
                    class_1799 itemStack = blockEntity.method_5438(slotIndex).method_7972();
                    if (itemStack.method_7960()) {
                        blockEntity.method_5447(slotIndex, remainderStack);
                        remainderStack = class_1799.field_8037;
                        continue;
                    }
                    if (!ItemOps.canStack((class_1799)itemStack, (class_1799)remainderStack)) continue;
                    int availableSpace = itemStack.method_7914() - itemStack.method_7947();
                    int j = Math.min(itemStack.method_7947(), availableSpace);
                    remainderStack.method_7934(j);
                    itemStack.method_7933(j);
                    continue;
                }
                blockEntity.method_5447(slotIndex, remainderStack);
                break;
            }
            if (isHopperEmpty && !((HopperBlockEntityAccessor)blockEntity).alloyForge$isDisabled()) {
                ((HopperBlockEntityAccessor)blockEntity).alloyForge$setTransferCooldown(8);
            }
            blockEntity.method_5431();
            return true;
        }
        return false;
    }

    public boolean verifyMultiblock() {
        class_2680 belowController = this.field_11863.method_8320((class_2338)this.multiblockPositions.get(0));
        if (!belowController.method_27852(class_2246.field_10312) && !this.forgeDefinition.isBlockValid(belowController.method_26204())) {
            return false;
        }
        for (int i = 1; i < this.multiblockPositions.size(); ++i) {
            if (this.forgeDefinition.isBlockValid(this.field_11863.method_8320((class_2338)this.multiblockPositions.get(i)).method_26204())) continue;
            return false;
        }
        return true;
    }

    private static ImmutableList<class_2338> generateMultiblockPositions(class_2338 controllerPos, class_2350 controllerFacing) {
        ArrayList<class_2338> posses = new ArrayList<class_2338>();
        class_2338 center = controllerPos.method_10093(controllerFacing.method_10153());
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(1, -1, 1), (class_2338)center.method_10069(-1, -1, -1))) {
            posses.add(pos.method_10062());
        }
        posses.remove(controllerPos.method_10074());
        posses.add(0, controllerPos.method_10074());
        for (int i = 0; i < 2; ++i) {
            class_2338 newCenter = center.method_10069(0, i, 0);
            posses.add(newCenter.method_10078());
            posses.add(newCenter.method_10067());
            posses.add(newCenter.method_10095());
            posses.add(newCenter.method_10072());
        }
        posses.remove(controllerPos);
        return ImmutableList.copyOf(posses);
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return DOWN_SLOTS;
        }
        if (side == this.facing.method_10170()) {
            return LEFT_SLOTS;
        }
        if (side == this.facing.method_10160() && this.currentSmeltTime == 0) {
            return RIGHT_SLOTS;
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 11 ? ForgeFuelRegistry.hasFuel(stack.method_7909()) : this.method_5438(slot).method_7960();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 10 || slot == 11 && !ForgeFuelRegistry.hasFuel(stack.method_7909());
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.alloy_forgery.forge_controller");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AlloyForgeScreenHandler(syncId, inv, (class_1263)this, this.properties);
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.fluidHolder.insert((TransferVariant)resource, maxAmount, transaction);
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return this.fluidHolder.iterator();
    }

    private class FluidHolder
    extends SingleVariantStorage<FluidVariant>
    implements InsertionOnlyStorage<FluidVariant> {
        private FluidHolder() {
        }

        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        protected long getCapacity(FluidVariant variant) {
            return 81000L;
        }

        protected void onFinalCommit() {
            ForgeControllerBlockEntity.this.method_5431();
        }

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)class_3612.field_15908);
        }

        protected boolean canExtract(FluidVariant variant) {
            return false;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            return super.iterator();
        }
    }

    public static class Type
    extends class_2591<ForgeControllerBlockEntity> {
        public static Type INSTANCE = new Type();

        private Type() {
            super(ForgeControllerBlockEntity::new, ForgeRegistry.controllerBlocksView(), null);
        }
    }
}

