/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.indrev;

import com.kneelawk.extramodintegrations.ExMIMod;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import me.steven.indrev.recipes.machines.IRRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public abstract class IREmiRecipe<R extends IRRecipe>
implements EmiRecipe {
    protected final R recipe;
    protected final class_2960 id;
    protected final List<EmiIngredient> inputs;
    protected final List<EmiStack> outputs;

    protected IREmiRecipe(R recipe) {
        this.recipe = recipe;
        this.id = recipe.getIdentifier();
        this.inputs = Arrays.stream(recipe.getInput()).map(entry -> EmiIngredient.of((class_1856)entry.getIngredient(), (long)entry.getCount())).toList();
        this.outputs = Arrays.stream(recipe.getOutputs()).map(entry -> EmiStack.of((class_1799)entry.getStack()).setChance((float)entry.getChance())).toList();
    }

    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    protected final void checkInputCount(int count) {
        if (this.inputs.size() != count) {
            ExMIMod.LOGGER.warn("Expected recipe {} ({}) to have {} inputs but instead it has {}", new Object[]{this.id, this.recipe, count, this.inputs.size()});
        }
    }

    protected final void checkOutputCount(int count) {
        if (this.outputs.size() != count) {
            ExMIMod.LOGGER.warn("Expected recipe {} ({}) to have {} outputs but instead it has {}", new Object[]{this.id, this.recipe, count, this.outputs.size()});
        }
    }

    protected EmiIngredient getInput(int index) {
        if (index >= this.inputs.size()) {
            return EmiStack.EMPTY;
        }
        return this.inputs.get(index);
    }

    protected EmiStack getOutput(int index) {
        if (index >= this.outputs.size()) {
            return EmiStack.EMPTY;
        }
        return this.outputs.get(index);
    }
}

