/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.indrev;

import com.kneelawk.extramodintegrations.AbstractIRIntegration;
import com.kneelawk.extramodintegrations.ExMIMod;
import com.kneelawk.extramodintegrations.ExMITextures;
import com.kneelawk.extramodintegrations.indrev.CondenserEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.ElectrolysisEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.FluidInfuserEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.LaserEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.ModuleEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.ModuleRecipeHandler;
import com.kneelawk.extramodintegrations.indrev.PulverizerEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.SawmillEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.SimpleOneInputEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.SimpleRecipeHandler;
import com.kneelawk.extramodintegrations.indrev.SimpleTwoInputEmiRecipe;
import com.kneelawk.extramodintegrations.indrev.SmelterEmiRecipe;
import com.kneelawk.extramodintegrations.util.LongHolder;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.List;
import me.steven.indrev.gui.screenhandlers.ScreenhandlersKt;
import me.steven.indrev.recipes.machines.CompressorRecipe;
import me.steven.indrev.recipes.machines.CondenserRecipe;
import me.steven.indrev.recipes.machines.ElectrolysisRecipe;
import me.steven.indrev.recipes.machines.FluidInfuserRecipe;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.InfuserRecipe;
import me.steven.indrev.recipes.machines.LaserRecipe;
import me.steven.indrev.recipes.machines.ModuleRecipe;
import me.steven.indrev.recipes.machines.PulverizerRecipe;
import me.steven.indrev.recipes.machines.RecyclerRecipe;
import me.steven.indrev.recipes.machines.SawmillRecipe;
import me.steven.indrev.recipes.machines.SmelterRecipe;
import me.steven.indrev.registry.IRBlockRegistry;
import me.steven.indrev.registry.MachineRegistry;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3956;

public class IRIntegration
extends AbstractIRIntegration {
    public static final EmiStack[] COMPRESSOR_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getCOMPRESSOR_REGISTRY());
    public static final EmiStack[] COMPRESSOR_FACTORY_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getCOMPRESSOR_FACTORY_REGISTRY());
    public static final EmiStack[] CONDENSER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getCONDENSER_REGISTRY());
    public static final EmiStack[] ELECTROLYSIS_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getELECTROLYTIC_SEPARATOR_REGISTRY());
    public static final EmiStack[] FURNACE_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getELECTRIC_FURNACE_REGISTRY());
    public static final EmiStack[] FURNACE_FACTORY_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getELECTRIC_FURNACE_FACTORY_REGISTRY());
    public static final EmiStack[] FLUID_INFUSER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getFLUID_INFUSER_REGISTRY());
    public static final EmiStack[] SOLID_INFUSER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getSOLID_INFUSER_REGISTRY());
    public static final EmiStack[] SOLID_INFUSER_FACTORY_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getSOLID_INFUSER_FACTORY_REGISTRY());
    public static final EmiStack[] LASER_EMITTER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getLASER_EMITTER_REGISTRY());
    public static final EmiStack CAPSULE_STACK = EmiStack.of((class_1935)IRBlockRegistry.INSTANCE.getCAPSULE_BLOCK());
    public static final EmiStack[] MODULAR_WORKBENCH_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getMODULAR_WORKBENCH_REGISTRY());
    public static final EmiStack[] PULVERIZER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getPULVERIZER_REGISTRY());
    public static final EmiStack[] PULVERIZER_FACTORY_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getPULVERIZER_FACTORY_REGISTRY());
    public static final EmiStack[] RECYCLER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getRECYCLER_REGISTRY());
    public static final EmiStack[] SAWMILL_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getSAWMILL_REGISTRY());
    public static final EmiStack[] SMELTER_STACKS = IRIntegration.getAllTiers(MachineRegistry.Companion.getSMELTER_REGISTRY());
    public static final EmiRecipeCategory COMPRESS_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("compress"), (EmiRenderable)COMPRESSOR_STACKS[0], (EmiRenderable)ExMITextures.COMPRESSING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory CONDENSER_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("condenser"), (EmiRenderable)CONDENSER_STACKS[0], (EmiRenderable)ExMITextures.CONDENSING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory ELECTROLYSIS_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("electrolysis"), (EmiRenderable)ELECTROLYSIS_STACKS[0], (EmiRenderable)ExMITextures.ELECTROLYZING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory FLUID_INFUSE_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("fluid_infuse"), (EmiRenderable)FLUID_INFUSER_STACKS[0], (EmiRenderable)ExMITextures.MIXING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory INFUSE_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("infuse"), (EmiRenderable)SOLID_INFUSER_STACKS[0], (EmiRenderable)ExMITextures.CHEMICAL_REACTING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory LASER_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("laser"), (EmiRenderable)LASER_EMITTER_STACKS[0], (EmiRenderable)ExMITextures.LASERING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory MODULES_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("modules"), (EmiRenderable)MODULAR_WORKBENCH_STACKS[0], (EmiRenderable)ExMITextures.MODULE, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory PULVERIZE_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("pulverize"), (EmiRenderable)PULVERIZER_STACKS[0], (EmiRenderable)ExMITextures.GRINDING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory RECYCLE_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("recycle"), (EmiRenderable)RECYCLER_STACKS[0], (EmiRenderable)ExMITextures.RECYCLING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory SAWMILL_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("sawmill"), (EmiRenderable)SAWMILL_STACKS[0], (EmiRenderable)ExMITextures.SAWMILLING, EmiRecipeSorting.compareOutputThenInput());
    public static final EmiRecipeCategory SMELTER_CATEGORY = new EmiRecipeCategory(IRIntegration.irId("smelter"), (EmiRenderable)SMELTER_STACKS[0], (EmiRenderable)ExMITextures.METAL_SMELTING, EmiRecipeSorting.compareOutputThenInput());

    @Override
    protected void registerImpl(EmiRegistry registry) {
        ExMIMod.LOGGER.info("[Extra Mod Integrations] Loading Industrial Revolution Integration...");
        class_1863 manager = registry.getRecipeManager();
        registry.addCategory(COMPRESS_CATEGORY);
        for (Object stack : COMPRESSOR_STACKS) {
            registry.addWorkstation(COMPRESS_CATEGORY, (EmiIngredient)stack);
        }
        for (Object stack : COMPRESSOR_FACTORY_STACKS) {
            registry.addWorkstation(COMPRESS_CATEGORY, (EmiIngredient)stack);
        }
        for (CompressorRecipe recipe : manager.method_30027((class_3956)CompressorRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new SimpleOneInputEmiRecipe((IRRecipe)recipe, COMPRESS_CATEGORY));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getCOMPRESSOR_HANDLER(), new SimpleRecipeHandler(COMPRESS_CATEGORY, List.of(Integer.valueOf(41)), 0));
        registry.addCategory(CONDENSER_CATEGORY);
        for (Object stack : CONDENSER_STACKS) {
            registry.addWorkstation(CONDENSER_CATEGORY, (EmiIngredient)stack);
        }
        LongHolder maxCondenserVolume = new LongHolder(64800L);
        for (CondenserRecipe recipe : manager.method_30027((class_3956)CondenserRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new CondenserEmiRecipe(recipe, maxCondenserVolume));
        }
        registry.addCategory(ELECTROLYSIS_CATEGORY);
        for (EmiStack stack : ELECTROLYSIS_STACKS) {
            registry.addWorkstation(ELECTROLYSIS_CATEGORY, (EmiIngredient)stack);
        }
        LongHolder maxElectrolyzerVolume = new LongHolder(64800L);
        for (ElectrolysisRecipe recipe : manager.method_30027((class_3956)ElectrolysisRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new ElectrolysisEmiRecipe(recipe, maxElectrolyzerVolume));
        }
        registry.addCategory(FLUID_INFUSE_CATEGORY);
        for (EmiStack stack : FLUID_INFUSER_STACKS) {
            registry.addWorkstation(FLUID_INFUSE_CATEGORY, (EmiIngredient)stack);
        }
        LongHolder maxFluidInfuserVolume = new LongHolder(64800L);
        for (FluidInfuserRecipe recipe : manager.method_30027((class_3956)FluidInfuserRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new FluidInfuserEmiRecipe(recipe, maxFluidInfuserVolume));
        }
        registry.addCategory(INFUSE_CATEGORY);
        for (Object stack : SOLID_INFUSER_STACKS) {
            registry.addWorkstation(INFUSE_CATEGORY, (EmiIngredient)stack);
        }
        for (Object stack : SOLID_INFUSER_FACTORY_STACKS) {
            registry.addWorkstation(INFUSE_CATEGORY, (EmiIngredient)stack);
        }
        for (InfuserRecipe recipe : manager.method_30027((class_3956)InfuserRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new SimpleTwoInputEmiRecipe((IRRecipe)recipe, INFUSE_CATEGORY));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getSOLID_INFUSER_HANDLER(), new SimpleRecipeHandler(INFUSE_CATEGORY, List.of(Integer.valueOf(41), Integer.valueOf(42)), 0));
        registry.addCategory(LASER_CATEGORY);
        for (Object stack : LASER_EMITTER_STACKS) {
            registry.addWorkstation(LASER_CATEGORY, (EmiIngredient)stack);
        }
        registry.addWorkstation(LASER_CATEGORY, (EmiIngredient)CAPSULE_STACK);
        for (LaserRecipe recipe : manager.method_30027((class_3956)LaserRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new LaserEmiRecipe(recipe));
        }
        registry.addCategory(MODULES_CATEGORY);
        for (Object stack : MODULAR_WORKBENCH_STACKS) {
            registry.addWorkstation(MODULES_CATEGORY, (EmiIngredient)stack);
        }
        for (ModuleRecipe recipe : manager.method_30027((class_3956)ModuleRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new ModuleEmiRecipe(recipe));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getMODULAR_WORKBENCH_HANDLER(), (EmiRecipeHandler)new ModuleRecipeHandler());
        registry.addCategory(PULVERIZE_CATEGORY);
        for (Object stack : PULVERIZER_STACKS) {
            registry.addWorkstation(PULVERIZE_CATEGORY, (EmiIngredient)stack);
        }
        for (Object stack : PULVERIZER_FACTORY_STACKS) {
            registry.addWorkstation(PULVERIZE_CATEGORY, (EmiIngredient)stack);
        }
        for (PulverizerRecipe recipe : manager.method_30027((class_3956)PulverizerRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new PulverizerEmiRecipe(recipe));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getPULVERIZER_HANDLER(), new SimpleRecipeHandler(PULVERIZE_CATEGORY, List.of(Integer.valueOf(41)), 0));
        registry.addCategory(RECYCLE_CATEGORY);
        for (Object stack : RECYCLER_STACKS) {
            registry.addWorkstation(RECYCLE_CATEGORY, (EmiIngredient)stack);
        }
        for (RecyclerRecipe recipe : manager.method_30027((class_3956)RecyclerRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new SimpleOneInputEmiRecipe((IRRecipe)recipe, RECYCLE_CATEGORY));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getRECYCLER_HANDLER(), new SimpleRecipeHandler(RECYCLE_CATEGORY, List.of(Integer.valueOf(40)), 0));
        registry.addCategory(SAWMILL_CATEGORY);
        for (Object stack : SAWMILL_STACKS) {
            registry.addWorkstation(SAWMILL_CATEGORY, (EmiIngredient)stack);
        }
        for (SawmillRecipe recipe : manager.method_30027((class_3956)SawmillRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new SawmillEmiRecipe(recipe));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getSAWMILL_HANDLER(), new SimpleRecipeHandler(SAWMILL_CATEGORY, List.of(Integer.valueOf(41)), 0));
        registry.addCategory(SMELTER_CATEGORY);
        for (Object stack : SMELTER_STACKS) {
            registry.addWorkstation(SMELTER_CATEGORY, (EmiIngredient)stack);
        }
        LongHolder maxSmelterVolume = new LongHolder(64800L);
        for (SmelterRecipe recipe : manager.method_30027((class_3956)SmelterRecipe.Companion.getTYPE())) {
            registry.addRecipe((EmiRecipe)new SmelterEmiRecipe(recipe, maxSmelterVolume));
        }
        registry.addRecipeHandler((class_3917)ScreenhandlersKt.getSMELTER_HANDLER(), new SimpleRecipeHandler(SMELTER_CATEGORY, List.of(Integer.valueOf(41)), 0));
        for (EmiStack stack : FURNACE_STACKS) {
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)stack);
        }
        for (EmiStack stack : FURNACE_FACTORY_STACKS) {
            registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, (EmiIngredient)stack);
        }
    }

    private static EmiStack[] getAllTiers(MachineRegistry registry) {
        return (EmiStack[])Arrays.stream(registry.getTiers()).map(arg_0 -> ((MachineRegistry)registry).block(arg_0)).map(EmiStack::of).toArray(EmiStack[]::new);
    }

    public static class_2960 irId(String path) {
        return new class_2960("indrev", path);
    }
}

