/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.techreborn;

import com.kneelawk.extramodintegrations.techreborn.TREmiRecipe;
import com.kneelawk.extramodintegrations.techreborn.TRFluidSlotWidget;
import com.kneelawk.extramodintegrations.techreborn.TRIntegration;
import com.kneelawk.extramodintegrations.techreborn.TRUIUtils;
import com.kneelawk.extramodintegrations.util.LongHolder;
import com.kneelawk.extramodintegrations.util.UIUtils;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.api.recipe.recipes.FluidReplicatorRecipe;

public class FluidReplicatorEmiRecipe
extends TREmiRecipe<FluidReplicatorRecipe> {
    private final List<EmiStack> fluidOutput;
    private final LongHolder capacityHolder;

    public FluidReplicatorEmiRecipe(FluidReplicatorRecipe recipe, LongHolder capacityHolder) {
        super(recipe);
        this.capacityHolder = capacityHolder;
        FluidInstance instance = recipe.getFluidInstance();
        long amount = instance.getAmount().getRawValue();
        this.fluidOutput = List.of(EmiStack.of((class_3611)instance.getFluid(), (class_2487)instance.getTag(), (long)amount));
        if (amount > capacityHolder.getValue()) {
            capacityHolder.setValue(amount);
        }
    }

    public EmiRecipeCategory getCategory() {
        return TRIntegration.FLUID_REPLICATOR_CATEGORY;
    }

    @Override
    public List<EmiStack> getOutputs() {
        return this.fluidOutput;
    }

    public int getDisplayWidth() {
        return 80;
    }

    public int getDisplayHeight() {
        return 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.getInput(0), 16, 19);
        ((TRFluidSlotWidget)widgets.add((Widget)new TRFluidSlotWidget(((FluidReplicatorRecipe)this.recipe).getFluidInstance(), 58, 0, this.capacityHolder.getValue()))).recipeContext(this);
        TRUIUtils.energyBar(widgets, this.recipe, 400, 0, 3);
        TRUIUtils.arrowRight(widgets, this.recipe, 38, 23);
        UIUtils.cookTime(widgets, ((FluidReplicatorRecipe)this.recipe).getTime(), 16, 0);
    }
}

