/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionPieces;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MansionStructurePiece;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3790;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6624;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class MansionStructure
extends class_3195 {
    public static final Codec<MansionStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MansionStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)Codec.STRING.fieldOf("mansion_type").forGetter(structure -> structure.mansionType), (App)class_2680.field_24734.fieldOf("foundation_block").forGetter(structure -> structure.foundationBlock), (App)Codec.BOOL.fieldOf("pillar_only_to_land").orElse((Object)true).forGetter(structure -> structure.pillarOnlyToLand), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius)).apply((Applicative)instance, MansionStructure::new));
    public final String mansionType;
    public final class_2680 foundationBlock;
    public final boolean pillarOnlyToLand;
    public final Optional<Integer> biomeRadius;

    public MansionStructure(class_3195.class_7302 config, String mansionType, class_2680 foundationBlock, boolean pillarOnlyToLand, Optional<Integer> biomeRadius) {
        super(config);
        this.mansionType = mansionType.toLowerCase(Locale.ROOT);
        this.foundationBlock = foundationBlock;
        this.pillarOnlyToLand = pillarOnlyToLand;
        this.biomeRadius = biomeRadius;
    }

    protected boolean extraSpawningChecks(class_3195.class_7149 context, class_2338 blockPos) {
        class_1923 chunkPos = context.comp_568();
        if (this.biomeRadius.isPresent() && !(context.comp_563() instanceof class_1973)) {
            int validBiomeRange = this.biomeRadius.get();
            for (int curChunkX = chunkPos.field_9181 - validBiomeRange; curChunkX <= chunkPos.field_9181 + validBiomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - validBiomeRange; curChunkZ <= chunkPos.field_9180 + validBiomeRange; ++curChunkZ) {
                    class_6880 biome = context.comp_563().method_38109(class_5742.method_33102((int)curChunkX), class_5742.method_33100((int)blockPos.method_10264()), class_5742.method_33102((int)curChunkZ), context.comp_564().method_42371());
                    if (context.comp_570().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_567(), context.comp_568().field_9181, context.comp_568().field_9180);
        class_2470 blockRotation = class_2470.method_16548((class_5819)random);
        int xOffset = 5;
        int zOffset = 5;
        if (blockRotation == class_2470.field_11463) {
            xOffset = -5;
        } else if (blockRotation == class_2470.field_11464) {
            xOffset = -5;
            zOffset = -5;
        } else if (blockRotation == class_2470.field_11465) {
            zOffset = -5;
        }
        int centerX = chunkPos.method_33940();
        int centerZ = chunkPos.method_33942();
        int firstHeight = context.comp_562().method_18028(centerX, centerZ, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
        int secondHeight = context.comp_562().method_18028(centerX, centerZ + zOffset, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
        int thirdHeight = context.comp_562().method_18028(centerX + xOffset, centerZ, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
        int forthheight = context.comp_562().method_18028(centerX + xOffset, centerZ + zOffset, class_2902.class_2903.field_13194, context.comp_569(), context.comp_564());
        int finalheight = Math.min(Math.min(firstHeight, secondHeight), Math.min(thirdHeight, forthheight));
        if (finalheight <= context.comp_562().method_33730()) {
            return Optional.empty();
        }
        if (!this.extraSpawningChecks(context, chunkPos.method_33943(finalheight))) {
            return Optional.empty();
        }
        return Optional.of(new class_3195.class_7150(new class_2338(centerX, finalheight + 1, centerZ), structurePiecesBuilder -> {
            class_2338 blockPos = new class_2338(chunkPos.method_33940(), finalheight + 1, chunkPos.method_33942());
            ArrayList<class_3443> list = new ArrayList<class_3443>();
            MansionPieces.createMansionLayout(context.comp_561(), context.comp_565(), blockPos, blockRotation, list, (class_5819)random, this.mansionType);
            list.forEach(piece -> {
                if (piece instanceof class_3790) {
                    class_3790 poolElementStructurePiece = (class_3790)piece;
                    structurePiecesBuilder.method_35462((class_3443)new MansionStructurePiece(poolElementStructurePiece, this.mansionType, this.foundationBlock, this.pillarOnlyToLand));
                } else {
                    structurePiecesBuilder.method_35462(piece);
                }
            });
        }));
    }

    public void method_38694(class_5281 level, class_5138 structureManager, class_2794 chunkGenerator, class_5819 random, class_3341 boundingBox, class_1923 chunkPos, class_6624 piecesContainer) {
        Object e;
        if (!piecesContainer.method_38708() && (e = piecesContainer.comp_132().get(0)) instanceof MansionStructurePiece) {
            MansionStructurePiece mansionStructurePiece = (MansionStructurePiece)((Object)e);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_3341 box = piecesContainer.method_38712();
            int structureBottomY = box.method_35416();
            int terrainY = Integer.MIN_VALUE;
            for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                block1: for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                    if (chunkPos.field_9181 != x >> 4 || chunkPos.field_9180 != z >> 4) continue;
                    mutableBlockPos.method_10103(x, structureBottomY, z);
                    if (mansionStructurePiece.pillarOnlyToLand && (terrainY = GeneralUtils.getFirstLandYFromPos((class_4538)level, mutableBlockPos.method_10074())) <= chunkGenerator.method_33730() || level.method_22347((class_2338)mutableBlockPos) || !box.method_14662((class_2382)mutableBlockPos) || !piecesContainer.method_38710((class_2338)mutableBlockPos)) continue;
                    for (int currentY = structureBottomY - 1; !(currentY <= chunkGenerator.method_33730() || mansionStructurePiece.pillarOnlyToLand && currentY <= terrainY); --currentY) {
                        class_2338 blockPos2 = new class_2338(x, currentY, z);
                        class_2680 state = level.method_8320(blockPos2);
                        if (!level.method_22347(blockPos2) && state.method_26227().method_15769() && !state.method_26164(class_3481.field_44470) && !state.method_26164(class_3481.field_20339)) continue block1;
                        level.method_8652(blockPos2, mansionStructurePiece.foundationBlock, 2);
                    }
                }
            }
        }
    }

    public class_7151<?> method_41618() {
        return RSStructures.MANSION_STRUCTURE.get();
    }
}

